/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf;

import com.baidu.bjf.remoting.protobuf.EnumReadable;
import com.baidu.bjf.remoting.protobuf.FieldType;
import com.baidu.bjf.remoting.protobuf.annotation.Protobuf;
import com.baidu.bjf.remoting.protobuf.utils.FieldInfo;
import com.baidu.bjf.remoting.protobuf.utils.FieldUtils;
import com.baidu.bjf.remoting.protobuf.utils.ProtobufProxyUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ProtobufIDLGenerator {
    public static String getIDL(Class<?> cls, Set<Class<?>> cachedTypes, Set<Class<?>> cachedEnumTypes, boolean ignoreJava) {
        Set<Class<?>> enumTypes;
        Set<Class<?>> types = cachedTypes;
        if (types == null) {
            types = new HashSet();
        }
        if ((enumTypes = cachedEnumTypes) == null) {
            enumTypes = new HashSet();
        }
        if (types.contains(cls)) {
            return null;
        }
        StringBuilder code = new StringBuilder();
        if (!ignoreJava) {
            code.append("package ").append(cls.getPackage().getName()).append(";\n");
            code.append("option java_outer_classname = \"").append(cls.getSimpleName()).append("$$ByJProtobuf\";\n");
        }
        types.add(cls);
        ProtobufIDLGenerator.generateIDL(code, cls, types, enumTypes);
        return code.toString();
    }

    public static String getIDL(Class<?> cls, Set<Class<?>> cachedTypes, Set<Class<?>> cachedEnumTypes) {
        return ProtobufIDLGenerator.getIDL(cls, cachedTypes, cachedEnumTypes, false);
    }

    public static String getIDL(Class<?> cls) {
        return ProtobufIDLGenerator.getIDL(cls, null, null);
    }

    private static void generateIDL(StringBuilder code, Class<?> cls, Set<Class<?>> cachedTypes, Set<Class<?>> cachedEnumTypes) {
        List<Field> fields = FieldUtils.findMatchedFields(cls, Protobuf.class);
        HashSet subTypes = new HashSet();
        HashSet enumTypes = new HashSet();
        code.append("message ").append(cls.getSimpleName()).append(" {  \n");
        List<FieldInfo> fieldInfos = ProtobufProxyUtils.processDefaultValue(fields);
        for (FieldInfo fieldInfo : fieldInfos) {
            Object type;
            if (fieldInfo.hasDescription()) {
                code.append("// ").append(fieldInfo.getDescription()).append("\n");
            }
            if (fieldInfo.getFieldType() == FieldType.OBJECT || fieldInfo.getFieldType() == FieldType.ENUM) {
                if (fieldInfo.isList()) {
                    String fieldTypeName;
                    Type targetType;
                    ParameterizedType ptype;
                    Type[] actualTypeArguments;
                    type = fieldInfo.getField().getGenericType();
                    if (!(type instanceof ParameterizedType) || (actualTypeArguments = (ptype = (ParameterizedType)type).getActualTypeArguments()) == null || actualTypeArguments.length <= 0 || !((targetType = actualTypeArguments[0]) instanceof Class)) continue;
                    Class c = (Class)targetType;
                    if (ProtobufProxyUtils.isScalarType(c)) {
                        FieldType fieldType = ProtobufProxyUtils.TYPE_MAPPING.get(c);
                        fieldTypeName = fieldType.getType();
                    } else {
                        if (fieldInfo.getFieldType() == FieldType.ENUM) {
                            if (!cachedEnumTypes.contains(c)) {
                                cachedEnumTypes.add(c);
                                enumTypes.add(c);
                            }
                        } else if (!cachedTypes.contains(c)) {
                            cachedTypes.add(c);
                            subTypes.add(c);
                        }
                        fieldTypeName = c.getSimpleName();
                    }
                    code.append("repeated ").append(fieldTypeName).append(" ").append(fieldInfo.getField().getName()).append("=").append(fieldInfo.getOrder()).append(";\n");
                    continue;
                }
                Class<?> c = fieldInfo.getField().getType();
                code.append(ProtobufIDLGenerator.getFieldRequired(fieldInfo.isRequired())).append(" ").append(c.getSimpleName()).append(" ").append(fieldInfo.getField().getName()).append("=").append(fieldInfo.getOrder()).append(";\n");
                if (fieldInfo.getFieldType() == FieldType.ENUM) {
                    if (cachedEnumTypes.contains(c)) continue;
                    cachedEnumTypes.add(c);
                    enumTypes.add(c);
                    continue;
                }
                if (cachedTypes.contains(c)) continue;
                cachedTypes.add(c);
                subTypes.add(c);
                continue;
            }
            type = fieldInfo.getFieldType().getType().toLowerCase();
            if (fieldInfo.getFieldType() == FieldType.ENUM) {
                Class<?> c = fieldInfo.getField().getType();
                if (Enum.class.isAssignableFrom(c)) {
                    type = c.getSimpleName();
                    if (!cachedEnumTypes.contains(c)) {
                        cachedEnumTypes.add(c);
                        enumTypes.add(c);
                    }
                }
            } else if (fieldInfo.getFieldType() == FieldType.MAP) {
                Class<?> keyClass = fieldInfo.getGenericKeyType();
                Class<?> valueClass = fieldInfo.getGenericeValueType();
                type = (String)type + "<" + ProtobufProxyUtils.processProtobufType(keyClass) + ", ";
                type = (String)type + ProtobufProxyUtils.processProtobufType(valueClass) + ">";
                if (ProtobufProxyUtils.isObjectType(keyClass)) {
                    if (Enum.class.isAssignableFrom(keyClass)) {
                        enumTypes.add(keyClass);
                    } else {
                        subTypes.add(keyClass);
                    }
                }
                if (ProtobufProxyUtils.isObjectType(valueClass)) {
                    if (Enum.class.isAssignableFrom(valueClass)) {
                        enumTypes.add(valueClass);
                    } else {
                        subTypes.add(valueClass);
                    }
                }
            }
            String required = ProtobufIDLGenerator.getFieldRequired(fieldInfo.isRequired());
            if (fieldInfo.isList()) {
                required = "repeated";
            }
            code.append(required).append(" ").append((String)type).append(" ").append(fieldInfo.getField().getName()).append("=").append(fieldInfo.getOrder()).append(";\n");
        }
        code.append("}\n");
        for (Class clazz : enumTypes) {
            ProtobufIDLGenerator.generateEnumIDL(code, clazz);
        }
        if (subTypes.isEmpty()) {
            return;
        }
        for (Class clazz : subTypes) {
            ProtobufIDLGenerator.generateIDL(code, clazz, cachedTypes, cachedEnumTypes);
        }
    }

    private static void generateEnumIDL(StringBuilder code, Class<Enum> cls) {
        Field[] fields;
        code.append("enum ").append(cls.getSimpleName()).append(" {  \n");
        for (Field field : fields = cls.getFields()) {
            String name = field.getName();
            code.append(name).append("=");
            try {
                Enum value = Enum.valueOf(cls, name);
                if (value instanceof EnumReadable) {
                    code.append(((EnumReadable)((Object)value)).value());
                } else {
                    code.append(value.ordinal());
                }
                code.append(";\n");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        code.append("}\n ");
    }

    private static String getFieldRequired(boolean required) {
        if (required) {
            return "required";
        }
        return "optional";
    }
}

