/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf;

import com.baidu.bjf.remoting.protobuf.Codec;
import com.baidu.bjf.remoting.protobuf.EnumReadable;
import com.baidu.bjf.remoting.protobuf.FieldType;
import com.baidu.bjf.remoting.protobuf.MapEntry;
import com.baidu.bjf.remoting.protobuf.ProtobufIDLGenerator;
import com.baidu.bjf.remoting.protobuf.ProtobufProxy;
import com.baidu.bjf.remoting.protobuf.descriptor.DescriptorProtoPOJO;
import com.baidu.bjf.remoting.protobuf.descriptor.EnumDescriptorProtoPOJO;
import com.baidu.bjf.remoting.protobuf.descriptor.EnumOptionsPOJO;
import com.baidu.bjf.remoting.protobuf.descriptor.EnumValueDescriptorProtoPOJO;
import com.baidu.bjf.remoting.protobuf.descriptor.ExtensionRangePOJO;
import com.baidu.bjf.remoting.protobuf.descriptor.FieldDescriptorProtoPOJO;
import com.baidu.bjf.remoting.protobuf.descriptor.FileDescriptorProtoPOJO;
import com.baidu.bjf.remoting.protobuf.descriptor.Label;
import com.baidu.bjf.remoting.protobuf.descriptor.MessageOptionsPOJO;
import com.baidu.bjf.remoting.protobuf.descriptor.OneofDescriptorProtoPOJO;
import com.baidu.bjf.remoting.protobuf.descriptor.ServiceDescriptorProtoPOJO;
import com.baidu.bjf.remoting.protobuf.descriptor.Type;
import com.baidu.bjf.remoting.protobuf.utils.ClassHelper;
import com.baidu.bjf.remoting.protobuf.utils.FieldInfo;
import com.baidu.bjf.remoting.protobuf.utils.ProtobufProxyUtils;
import com.baidu.bjf.remoting.protobuf.utils.StringUtils;
import com.baidu.jprotobuf.com.squareup.protoparser.DataType;
import com.baidu.jprotobuf.com.squareup.protoparser.EnumConstantElement;
import com.baidu.jprotobuf.com.squareup.protoparser.EnumElement;
import com.baidu.jprotobuf.com.squareup.protoparser.FieldElement;
import com.baidu.jprotobuf.com.squareup.protoparser.MessageElement;
import com.baidu.jprotobuf.com.squareup.protoparser.OptionElement;
import com.baidu.jprotobuf.com.squareup.protoparser.ProtoFile;
import com.baidu.jprotobuf.com.squareup.protoparser.ProtoParser;
import com.baidu.jprotobuf.com.squareup.protoparser.TypeElement;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyField;
import com.google.protobuf.LazyFieldLite;
import com.google.protobuf.MessageLite;
import com.google.protobuf.WireFormat;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CodedConstant {
    private static final String MAP_ENTRY_SUFFIX = "Entry";
    private static final String WIREFORMAT_CLSNAME = ClassHelper.getInternalName(WireFormat.FieldType.class.getName());
    private static Codec<FileDescriptorProtoPOJO> descriptorCodec = ProtobufProxy.create(FileDescriptorProtoPOJO.class);
    static final int TAG_TYPE_BITS = 3;

    private static String getFieldName(int order) {
        String fieldName = "f_" + order;
        return fieldName;
    }

    public static int computeElementSize(WireFormat.FieldType type, int number, Object value) {
        int tagSize = CodedOutputStream.computeTagSize((int)number);
        if (type == WireFormat.FieldType.GROUP) {
            tagSize *= 2;
        }
        return tagSize + CodedConstant.computeElementSizeNoTag(type, value);
    }

    public static String getMappedTypeDefined(int order, FieldType type, String express, boolean isList, boolean isMap) {
        StringBuilder code = new StringBuilder();
        String fieldName = CodedConstant.getFieldName(order);
        if (!(type != FieldType.STRING && type != FieldType.BYTES || isList)) {
            code.append("com.google.protobuf.ByteString ").append(fieldName).append(" = null").append(";\n");
            code.append("if (!CodedConstant.isNull(").append(express).append(")) {").append("\n");
            String method = "copyFromUtf8";
            if (type == FieldType.BYTES) {
                method = "copyFrom";
            }
            code.append(fieldName).append(" = com.google.protobuf.ByteString.").append(method).append("(").append(express).append(")").append(";\n");
            code.append("}").append("\n");
            return code.toString();
        }
        String defineType = type.getJavaType();
        if (isList) {
            defineType = "List";
        } else if (isMap) {
            defineType = "Map";
        }
        code.setLength(0);
        code.append(defineType).append(" ").append(fieldName).append(" = null").append(";\n");
        code.append("if (!CodedConstant.isNull(").append(express).append(")) {").append("\n");
        code.append(fieldName).append(" = ").append(express).append(";\n");
        code.append("}").append("\n");
        return code.toString();
    }

    public static String getMappedTypeSize(FieldInfo field, int order, FieldType type, boolean isList, boolean isMap, boolean debug, File path) {
        String fieldName = CodedConstant.getFieldName(order);
        String spath = "null";
        if (path != null) {
            spath = "new java.io.File(\"" + path.getAbsolutePath().replace('\\', '/') + "\")";
        }
        String typeString = type.getType().toUpperCase();
        if (isList) {
            return "CodedConstant.computeListSize(" + order + ", " + fieldName + ", FieldType." + typeString + ", " + Boolean.valueOf(debug) + ", " + spath + "," + Boolean.valueOf(field.isPacked()) + ")" + ";\n";
        }
        if (isMap) {
            String joinedSentence = CodedConstant.getMapFieldGenericParameterString(field);
            return "CodedConstant.computeMapSize(" + order + ", " + fieldName + ", " + joinedSentence + ")" + ";\n";
        }
        if (type == FieldType.OBJECT) {
            return "CodedConstant.computeSize(" + order + "," + fieldName + ", FieldType." + typeString + "," + Boolean.valueOf(debug) + "," + spath + ")" + ";\n";
        }
        String t = type.getType();
        if (type == FieldType.STRING || type == FieldType.BYTES) {
            t = "bytes";
        }
        t = CodedConstant.capitalize(t);
        boolean enumSpecial = false;
        if (type == FieldType.ENUM && EnumReadable.class.isAssignableFrom(field.getField().getType())) {
            String clsName = ClassHelper.getInternalName(field.getField().getType().getName());
            fieldName = "((" + clsName + ") " + fieldName + ").value()";
            enumSpecial = true;
        }
        if (!enumSpecial) {
            fieldName = fieldName + type.getToPrimitiveType();
        }
        return "com.google.protobuf.CodedOutputStream.compute" + t + "Size(" + order + "," + fieldName + ")" + ";\n";
    }

    public static String getMapFieldGenericParameterString(FieldInfo field) {
        String defaultValueValue;
        String valueClass;
        String defaultKeyValue;
        String keyClass;
        FieldType fieldType = ProtobufProxyUtils.TYPE_MAPPING.get(field.getGenericKeyType());
        if (fieldType == null) {
            if (Enum.class.isAssignableFrom(field.getGenericKeyType())) {
                keyClass = WIREFORMAT_CLSNAME + ".ENUM";
                Class<?> declaringClass = field.getGenericKeyType();
                Field[] fields = declaringClass.getFields();
                defaultKeyValue = fields != null && fields.length > 0 ? ClassHelper.getInternalName(field.getGenericKeyType().getName()) + "." + fields[0].getName() : "0";
            } else {
                keyClass = WIREFORMAT_CLSNAME + ".MESSAGE";
                boolean hasDefaultConstructor = ClassHelper.hasDefaultConstructor(field.getGenericKeyType());
                if (!hasDefaultConstructor) {
                    throw new IllegalArgumentException("Class '" + field.getGenericKeyType().getName() + "' must has default constructor method with no parameters.");
                }
                defaultKeyValue = "new " + ClassHelper.getInternalName(field.getGenericKeyType().getName()) + "()";
            }
        } else {
            keyClass = WIREFORMAT_CLSNAME + "." + fieldType.toString();
            defaultKeyValue = fieldType.getDefaultValue();
        }
        fieldType = ProtobufProxyUtils.TYPE_MAPPING.get(field.getGenericeValueType());
        if (fieldType == null) {
            if (Enum.class.isAssignableFrom(field.getGenericeValueType())) {
                valueClass = WIREFORMAT_CLSNAME + ".ENUM";
                Class<?> declaringClass = field.getGenericeValueType();
                Field[] fields = declaringClass.getFields();
                defaultValueValue = fields != null && fields.length > 0 ? ClassHelper.getInternalName(field.getGenericeValueType().getName()) + "." + fields[0].getName() : "0";
            } else {
                valueClass = WIREFORMAT_CLSNAME + ".MESSAGE";
                boolean hasDefaultConstructor = ClassHelper.hasDefaultConstructor(field.getGenericeValueType());
                if (!hasDefaultConstructor) {
                    throw new IllegalArgumentException("Class '" + field.getGenericeValueType().getName() + "' must has default constructor method with no parameters.");
                }
                defaultValueValue = "new " + ClassHelper.getInternalName(field.getGenericeValueType().getName()) + "()";
            }
        } else {
            valueClass = WIREFORMAT_CLSNAME + "." + fieldType.toString();
            defaultValueValue = fieldType.getDefaultValue();
        }
        String joinedSentence = keyClass + "," + defaultKeyValue + "," + valueClass + "," + defaultValueValue;
        return joinedSentence;
    }

    public static int computeListSize(int order, List<?> list, FieldType type, boolean debug, File path) {
        return CodedConstant.computeListSize(order, list, type, debug, path, false, false);
    }

    public static int computeListSize(int order, List list, FieldType type, boolean debug, File path, boolean packed) {
        return CodedConstant.computeListSize(order, list, type, debug, path, packed, false);
    }

    public static int computeListSize(int order, List list, FieldType type, boolean debug, File path, boolean packed, boolean sizeOnly) {
        int size = 0;
        if (list == null || list.isEmpty()) {
            return size;
        }
        for (Object object : list) {
            size += CodedConstant.computeSize(order, object, type, debug, path);
        }
        if (type != FieldType.OBJECT) {
            if (packed) {
                if (!sizeOnly) {
                    size += CodedOutputStream.computeInt32SizeNoTag((int)size);
                    ++size;
                }
            } else {
                size += list.size() * CodedOutputStream.computeTagSize((int)order);
            }
        }
        return size;
    }

    public static <K, V> int computeMapSize(int order, Map<K, V> map, WireFormat.FieldType keyType, K defaultKey, WireFormat.FieldType valueType, V defalutValue) {
        int size = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            MapEntry<K, V> valuesDefaultEntry = MapEntry.newDefaultInstance(null, keyType, defaultKey, valueType, defalutValue);
            MapEntry<K, V> values = valuesDefaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)order, values);
        }
        return size;
    }

    public static <K, V> void putMapValue(CodedInputStream input, Map<K, V> map, WireFormat.FieldType keyType, K defaultKey, WireFormat.FieldType valueType, V defalutValue) throws IOException {
        MapEntry<K, V> valuesDefaultEntry = MapEntry.newDefaultInstance(null, keyType, defaultKey, valueType, defalutValue);
        MapEntry values = (MapEntry)input.readMessage(valuesDefaultEntry.getParserForType(), null);
        map.put(values.getKey(), values.getValue());
    }

    public static <K, V> void writeToMap(CodedOutputStream output, int order, Map<K, V> map, WireFormat.FieldType keyType, K defaultKey, WireFormat.FieldType valueType, V defalutValue) throws IOException {
        MapEntry<K, V> valuesDefaultEntry = MapEntry.newDefaultInstance(null, keyType, defaultKey, valueType, defalutValue);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            MapEntry<K, V> values = valuesDefaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            output.writeMessage(order, values);
        }
    }

    public static int computeSize(int order, Object o, FieldType type, boolean debug, File path) {
        return CodedConstant.computeSize(order, o, type, false, debug, path);
    }

    public static int computeObjectSizeNoTag(Object o) {
        int size = 0;
        if (o == null) {
            return size;
        }
        Class<?> cls = o.getClass();
        Codec<?> target = ProtobufProxy.create(cls);
        try {
            size = target.size(o);
            size += CodedOutputStream.computeRawVarint32Size((int)size);
            return size;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static int computeSize(int order, Object o, FieldType type, boolean list, boolean debug, File path) {
        int size = 0;
        if (o == null) {
            return size;
        }
        if (type == FieldType.OBJECT) {
            Class<?> cls = o.getClass();
            Codec<?> target = ProtobufProxy.create(cls, debug, path);
            try {
                size = target.size(o);
                size += CodedOutputStream.computeRawVarint32Size((int)size);
                return size + CodedOutputStream.computeTagSize((int)order);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (type == FieldType.STRING) {
            size = CodedOutputStream.computeStringSizeNoTag((String)String.valueOf(o));
        } else if (type == FieldType.BOOL) {
            size = CodedOutputStream.computeBoolSizeNoTag((boolean)Boolean.valueOf(String.valueOf(o)));
        } else if (type == FieldType.BYTES) {
            byte[] bb = (byte[])o;
            size = CodedOutputStream.computeBytesSizeNoTag((ByteString)ByteString.copyFrom((byte[])bb));
        } else if (type == FieldType.DOUBLE) {
            size = CodedOutputStream.computeDoubleSizeNoTag((double)Double.valueOf(o.toString()));
        } else if (type == FieldType.FIXED32 || type == FieldType.INT32 || type == FieldType.SFIXED32 || type == FieldType.SINT32 || type == FieldType.UINT32) {
            size = CodedOutputStream.computeInt32SizeNoTag((int)Integer.valueOf(o.toString()));
        } else if (type == FieldType.FIXED64 || type == FieldType.INT64 || type == FieldType.SFIXED64 || type == FieldType.SINT64 || type == FieldType.UINT64) {
            size = CodedOutputStream.computeInt64SizeNoTag((long)Long.valueOf(o.toString()));
        } else if (type == FieldType.FLOAT) {
            size = CodedOutputStream.computeFloatSizeNoTag((float)Float.valueOf(o.toString()).floatValue());
        } else if (type == FieldType.ENUM) {
            if (o instanceof EnumReadable) {
                size = CodedOutputStream.computeInt32SizeNoTag((int)((EnumReadable)o).value());
            } else if (o instanceof Enum) {
                size = CodedOutputStream.computeInt32SizeNoTag((int)((Enum)o).ordinal());
            }
        }
        return size;
    }

    public static String getMappedWriteCode(FieldInfo field, String prefix, int order, FieldType type, boolean isList, boolean isMap) {
        String fieldName = CodedConstant.getFieldName(order);
        StringBuilder ret = new StringBuilder();
        ret.append("if (").append(fieldName).append(" != null){").append("\n");
        if (isList) {
            String typeString = type.getType().toUpperCase();
            ret.append("CodedConstant.writeToList(").append(prefix).append(",");
            ret.append(order).append(",").append("FieldType.").append(typeString);
            ret.append(",").append(fieldName).append(",").append((Object)field.isPacked()).append(")").append(";\n").append("}").append("\n");
            return ret.toString();
        }
        if (isMap) {
            ret.append("CodedConstant.writeToMap(").append(prefix).append(",");
            ret.append(order).append(",").append(fieldName);
            String joinedSentence = CodedConstant.getMapFieldGenericParameterString(field);
            ret.append(",").append(joinedSentence);
            ret.append(")").append(";\n").append("}").append("\n");
            return ret.toString();
        }
        boolean enumSpecial = false;
        if (type == FieldType.ENUM && EnumReadable.class.isAssignableFrom(field.getField().getType())) {
            String clsName = ClassHelper.getInternalName(field.getField().getType().getName());
            fieldName = "((" + clsName + ") " + fieldName + ").value()";
            enumSpecial = true;
        }
        if (!enumSpecial) {
            fieldName = fieldName + type.getToPrimitiveType();
        }
        if (type == FieldType.OBJECT) {
            String typeString = type.getType().toUpperCase();
            ret.append("CodedConstant.writeObject(").append(prefix).append(",");
            ret.append(order).append(",").append("FieldType.").append(typeString);
            ret.append(",").append(fieldName).append(", false)").append(";\n").append("}").append("\n");
            return ret.toString();
        }
        if (type == FieldType.STRING || type == FieldType.BYTES) {
            ret.append(prefix).append(".writeBytes(").append(order);
            ret.append(", ").append(fieldName).append(")").append(";\n").append("}").append("\n");
            return ret.toString();
        }
        String t = type.getType();
        t = CodedConstant.capitalize(t);
        ret.append(prefix).append(".write").append(t).append("(").append(order);
        ret.append(", ").append(fieldName).append(")").append(";\n").append("}").append("\n");
        return ret.toString();
    }

    public static void writeToList(CodedOutputStream out, int order, FieldType type, List list) throws IOException {
        CodedConstant.writeToList(out, order, type, list, false);
    }

    public static void writeToList(CodedOutputStream out, int order, FieldType type, List list, boolean packed) throws IOException {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (packed) {
            out.writeUInt32NoTag(CodedConstant.makeTag(order, 2));
            out.writeUInt32NoTag(CodedConstant.computeListSize(order, list, type, false, null, packed, true));
        }
        for (Object object : list) {
            CodedConstant.writeObject(out, order, type, object, true, !packed);
        }
    }

    public static void writeObject(CodedOutputStream out, int order, FieldType type, Object o, boolean list) throws IOException {
        CodedConstant.writeObject(out, order, type, o, list, true);
    }

    public static void writeObject(CodedOutputStream out, int order, FieldType type, Object o, boolean list, boolean withTag) throws IOException {
        if (o == null) {
            return;
        }
        if (type == FieldType.OBJECT) {
            Class<?> cls = o.getClass();
            Codec<?> target = ProtobufProxy.create(cls);
            if (withTag) {
                out.writeRawVarint32(CodedConstant.makeTag(order, 2));
            }
            out.writeRawVarint32(target.size(o));
            target.writeTo(o, out);
            return;
        }
        if (type == FieldType.BOOL) {
            if (withTag) {
                out.writeBool(order, ((Boolean)o).booleanValue());
            } else {
                out.writeBoolNoTag(((Boolean)o).booleanValue());
            }
        } else if (type == FieldType.BYTES) {
            byte[] bb = (byte[])o;
            if (withTag) {
                out.writeBytes(order, ByteString.copyFrom((byte[])bb));
            } else {
                out.writeBytesNoTag(ByteString.copyFrom((byte[])bb));
            }
        } else if (type == FieldType.DOUBLE) {
            if (withTag) {
                out.writeDouble(order, ((Double)o).doubleValue());
            } else {
                out.writeDoubleNoTag(((Double)o).doubleValue());
            }
        } else if (type == FieldType.FIXED32) {
            if (withTag) {
                out.writeFixed32(order, ((Integer)o).intValue());
            } else {
                out.writeFixed32NoTag(((Integer)o).intValue());
            }
        } else if (type == FieldType.FIXED64) {
            if (withTag) {
                out.writeFixed64(order, ((Long)o).longValue());
            } else {
                out.writeFixed64NoTag(((Long)o).longValue());
            }
        } else if (type == FieldType.FLOAT) {
            if (withTag) {
                out.writeFloat(order, ((Float)o).floatValue());
            } else {
                out.writeFloatNoTag(((Float)o).floatValue());
            }
        } else if (type == FieldType.INT32) {
            if (withTag) {
                out.writeInt32(order, ((Integer)o).intValue());
            } else {
                out.writeInt32NoTag(((Integer)o).intValue());
            }
        } else if (type == FieldType.INT64) {
            if (withTag) {
                out.writeInt64(order, ((Long)o).longValue());
            } else {
                out.writeInt64NoTag(((Long)o).longValue());
            }
        } else if (type == FieldType.SFIXED32) {
            if (withTag) {
                out.writeSFixed32(order, ((Integer)o).intValue());
            } else {
                out.writeSFixed32NoTag(((Integer)o).intValue());
            }
        } else if (type == FieldType.SFIXED64) {
            if (withTag) {
                out.writeSFixed64(order, ((Long)o).longValue());
            } else {
                out.writeSFixed64NoTag(((Long)o).longValue());
            }
        } else if (type == FieldType.SINT32) {
            if (withTag) {
                out.writeSInt32(order, ((Integer)o).intValue());
            } else {
                out.writeSInt32NoTag(((Integer)o).intValue());
            }
        } else if (type == FieldType.SINT64) {
            if (withTag) {
                out.writeSInt64(order, ((Long)o).longValue());
            } else {
                out.writeSInt64NoTag(((Long)o).longValue());
            }
        } else if (type == FieldType.STRING) {
            if (withTag) {
                out.writeBytes(order, ByteString.copyFromUtf8((String)String.valueOf(o)));
            } else {
                out.writeBytesNoTag(ByteString.copyFromUtf8((String)String.valueOf(o)));
            }
        } else if (type == FieldType.UINT32) {
            if (withTag) {
                out.writeUInt32(order, ((Integer)o).intValue());
            } else {
                out.writeUInt32NoTag(((Integer)o).intValue());
            }
        } else if (type == FieldType.UINT64) {
            if (withTag) {
                out.writeUInt64(order, ((Long)o).longValue());
            } else {
                out.writeUInt64NoTag(((Long)o).longValue());
            }
        } else if (type == FieldType.ENUM) {
            int value = 0;
            if (o instanceof EnumReadable) {
                value = ((EnumReadable)o).value();
            } else if (o instanceof Enum) {
                value = ((Enum)o).ordinal();
            }
            if (withTag) {
                out.writeEnum(order, value);
            } else {
                out.writeEnumNoTag(value);
            }
        }
    }

    public static String getRequiredCheck(int order, Field field) {
        String fieldName = CodedConstant.getFieldName(order);
        String code = "if (" + fieldName + "== null) {\n";
        code = code + "throw new UninitializedMessageException(CodedConstant.asList(\"" + field.getName() + "\"));\n";
        code = code + "}\n";
        return code;
    }

    public static String getRetRequiredCheck(String express, Field field) {
        String code = "if (CodedConstant.isNull(" + express + ")) {\n";
        code = code + "throw new UninitializedMessageException(CodedConstant.asList(\"" + field.getName() + "\"));\n";
        code = code + "}\n";
        return code;
    }

    public static boolean isNull(Object o) {
        return o == null;
    }

    public static boolean isNull(double o) {
        return false;
    }

    public static boolean isNull(int o) {
        return false;
    }

    public static boolean isNull(byte o) {
        return false;
    }

    public static boolean isNull(short o) {
        return false;
    }

    public static boolean isNull(long o) {
        return false;
    }

    public static boolean isNull(float o) {
        return false;
    }

    public static boolean isNull(char o) {
        return false;
    }

    public static List asList(String value) {
        return Arrays.asList(value);
    }

    public static String capitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuilder(strLen).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static int makeTag(int fieldNumber, int wireType) {
        return fieldNumber << 3 | wireType;
    }

    public static String getEnumName(Enum[] e, int value) {
        if (e != null) {
            for (Enum en : e) {
                int toCompareValue = en instanceof EnumReadable ? ((EnumReadable)((Object)en)).value() : en.ordinal();
                if (value != toCompareValue) continue;
                return en.name();
            }
        }
        return "";
    }

    public static Object readPrimitiveField(CodedInputStream input, WireFormat.FieldType type, boolean checkUtf8) throws IOException {
        switch (type) {
            case DOUBLE: {
                return input.readDouble();
            }
            case FLOAT: {
                return Float.valueOf(input.readFloat());
            }
            case INT64: {
                return input.readInt64();
            }
            case UINT64: {
                return input.readUInt64();
            }
            case INT32: {
                return input.readInt32();
            }
            case FIXED64: {
                return input.readFixed64();
            }
            case FIXED32: {
                return input.readFixed32();
            }
            case BOOL: {
                return input.readBool();
            }
            case STRING: {
                if (checkUtf8) {
                    return input.readStringRequireUtf8();
                }
                return input.readString();
            }
            case BYTES: {
                return input.readBytes();
            }
            case UINT32: {
                return input.readUInt32();
            }
            case SFIXED32: {
                return input.readSFixed32();
            }
            case SFIXED64: {
                return input.readSFixed64();
            }
            case SINT32: {
                return input.readSInt32();
            }
            case SINT64: {
                return input.readSInt64();
            }
            case GROUP: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle nested groups.");
            }
            case MESSAGE: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle embedded messages.");
            }
            case ENUM: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle enums.");
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    public static void writeElement(CodedOutputStream output, WireFormat.FieldType type, int number, Object value) throws IOException {
        if (type == WireFormat.FieldType.GROUP) {
            output.writeGroup(number, (MessageLite)value);
        } else {
            output.writeTag(number, CodedConstant.getWireFormatForFieldType(type, false));
            CodedConstant.writeElementNoTag(output, type, value);
        }
    }

    static int getWireFormatForFieldType(WireFormat.FieldType type, boolean isPacked) {
        if (isPacked) {
            return 2;
        }
        return type.getWireType();
    }

    public static void writeElementNoTag(CodedOutputStream output, WireFormat.FieldType type, Object value) throws IOException {
        switch (type) {
            case DOUBLE: {
                output.writeDoubleNoTag(((Double)value).doubleValue());
                break;
            }
            case FLOAT: {
                output.writeFloatNoTag(((Float)value).floatValue());
                break;
            }
            case INT64: {
                output.writeInt64NoTag(((Long)value).longValue());
                break;
            }
            case UINT64: {
                output.writeUInt64NoTag(((Long)value).longValue());
                break;
            }
            case INT32: {
                output.writeInt32NoTag(((Integer)value).intValue());
                break;
            }
            case FIXED64: {
                output.writeFixed64NoTag(((Long)value).longValue());
                break;
            }
            case FIXED32: {
                output.writeFixed32NoTag(((Integer)value).intValue());
                break;
            }
            case BOOL: {
                output.writeBoolNoTag(((Boolean)value).booleanValue());
                break;
            }
            case STRING: {
                output.writeStringNoTag((String)value);
                break;
            }
            case MESSAGE: {
                CodedConstant.writeObject(output, 0, FieldType.OBJECT, value, false, false);
                break;
            }
            case BYTES: {
                if (value instanceof ByteString) {
                    output.writeBytesNoTag((ByteString)value);
                    break;
                }
                output.writeByteArrayNoTag((byte[])value);
                break;
            }
            case UINT32: {
                output.writeUInt32NoTag(((Integer)value).intValue());
                break;
            }
            case SFIXED32: {
                output.writeSFixed32NoTag(((Integer)value).intValue());
                break;
            }
            case SFIXED64: {
                output.writeSFixed64NoTag(((Long)value).longValue());
                break;
            }
            case SINT32: {
                output.writeSInt32NoTag(((Integer)value).intValue());
                break;
            }
            case SINT64: {
                output.writeSInt64NoTag(((Long)value).longValue());
                break;
            }
            case ENUM: {
                if (value instanceof Internal.EnumLite) {
                    output.writeEnumNoTag(((Internal.EnumLite)value).getNumber());
                    break;
                }
                if (value instanceof EnumReadable) {
                    output.writeEnumNoTag(((EnumReadable)value).value());
                    break;
                }
                if (value instanceof Enum) {
                    output.writeEnumNoTag(((Enum)value).ordinal());
                    break;
                }
                output.writeEnumNoTag(((Integer)value).intValue());
            }
        }
    }

    public static int computeLengthDelimitedFieldSize(int fieldLength) {
        return CodedOutputStream.computeUInt32SizeNoTag((int)fieldLength) + fieldLength;
    }

    public static int computeElementSizeNoTag(WireFormat.FieldType type, Object value) {
        switch (type) {
            case DOUBLE: {
                return CodedOutputStream.computeDoubleSizeNoTag((double)((Double)value));
            }
            case FLOAT: {
                return CodedOutputStream.computeFloatSizeNoTag((float)((Float)value).floatValue());
            }
            case INT64: {
                return CodedOutputStream.computeInt64SizeNoTag((long)((Long)value));
            }
            case UINT64: {
                return CodedOutputStream.computeUInt64SizeNoTag((long)((Long)value));
            }
            case INT32: {
                return CodedOutputStream.computeInt32SizeNoTag((int)((Integer)value));
            }
            case FIXED64: {
                return CodedOutputStream.computeFixed64SizeNoTag((long)((Long)value));
            }
            case FIXED32: {
                return CodedOutputStream.computeFixed32SizeNoTag((int)((Integer)value));
            }
            case BOOL: {
                return CodedOutputStream.computeBoolSizeNoTag((boolean)((Boolean)value));
            }
            case STRING: {
                return CodedOutputStream.computeStringSizeNoTag((String)((String)value));
            }
            case GROUP: {
                return CodedOutputStream.computeGroupSizeNoTag((MessageLite)((MessageLite)value));
            }
            case BYTES: {
                if (value instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)((ByteString)value));
                }
                return CodedOutputStream.computeByteArraySizeNoTag((byte[])((byte[])value));
            }
            case UINT32: {
                return CodedOutputStream.computeUInt32SizeNoTag((int)((Integer)value));
            }
            case SFIXED32: {
                return CodedOutputStream.computeSFixed32SizeNoTag((int)((Integer)value));
            }
            case SFIXED64: {
                return CodedOutputStream.computeSFixed64SizeNoTag((long)((Long)value));
            }
            case SINT32: {
                return CodedOutputStream.computeSInt32SizeNoTag((int)((Integer)value));
            }
            case SINT64: {
                return CodedOutputStream.computeSInt64SizeNoTag((long)((Long)value));
            }
            case MESSAGE: {
                if (value instanceof LazyField) {
                    return CodedOutputStream.computeLazyFieldSizeNoTag((LazyFieldLite)((LazyField)value));
                }
                return CodedConstant.computeObjectSizeNoTag(value);
            }
            case ENUM: {
                if (value instanceof Internal.EnumLite) {
                    return CodedOutputStream.computeEnumSizeNoTag((int)((Internal.EnumLite)value).getNumber());
                }
                if (value instanceof EnumReadable) {
                    return CodedOutputStream.computeEnumSizeNoTag((int)((EnumReadable)value).value());
                }
                if (value instanceof Enum) {
                    return CodedOutputStream.computeEnumSizeNoTag((int)((Enum)value).ordinal());
                }
                return CodedOutputStream.computeEnumSizeNoTag((int)((Integer)value));
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    public static Descriptors.Descriptor getDescriptor(Class<?> cls) throws IOException {
        Descriptors.FileDescriptor fileDescriptor;
        DescriptorProtos.FileDescriptorProto fileproto;
        String idl = ProtobufIDLGenerator.getIDL(cls);
        ProtoFile file = ProtoParser.parse((String)"jprotobuf_autogenerate", (String)idl);
        FileDescriptorProtoPOJO fileDescriptorProto = new FileDescriptorProtoPOJO();
        fileDescriptorProto.name = "jprotobuf_autogenerate";
        fileDescriptorProto.pkg = file.packageName();
        fileDescriptorProto.dependencies = file.dependencies();
        fileDescriptorProto.publicDependency = CodedConstant.convertList(file.publicDependencies());
        fileDescriptorProto.weakDependency = null;
        fileDescriptorProto.messageTypes = new ArrayList<DescriptorProtoPOJO>();
        fileDescriptorProto.enumTypes = new ArrayList<EnumDescriptorProtoPOJO>();
        fileDescriptorProto.services = new ArrayList<ServiceDescriptorProtoPOJO>();
        HashSet<String> messageSet = new HashSet<String>();
        HashSet<String> enumSet = new HashSet<String>();
        List typeElements = file.typeElements();
        if (typeElements != null) {
            for (TypeElement typeElement : typeElements) {
                if (typeElement instanceof MessageElement) {
                    messageSet.add(typeElement.name());
                    continue;
                }
                if (!(typeElement instanceof EnumElement)) continue;
                enumSet.add(typeElement.name());
            }
            for (TypeElement typeElement : typeElements) {
                if (typeElement instanceof MessageElement) {
                    fileDescriptorProto.messageTypes.add(CodedConstant.getDescritorProtoPOJO(fileDescriptorProto, (MessageElement)typeElement, messageSet, enumSet));
                    continue;
                }
                if (!(typeElement instanceof EnumElement)) continue;
                fileDescriptorProto.enumTypes.add(CodedConstant.getDescritorProtoPOJO(fileDescriptorProto, (EnumElement)typeElement, messageSet, enumSet));
            }
        }
        try {
            byte[] bs = descriptorCodec.encode(fileDescriptorProto);
            fileproto = DescriptorProtos.FileDescriptorProto.parseFrom((byte[])bs);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IOException("Failed to parse protocol buffer descriptor for generated code.", e);
        }
        try {
            fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileproto, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new IOException(e.getMessage(), e);
        }
        return (Descriptors.Descriptor)fileDescriptor.getMessageTypes().get(0);
    }

    private static EnumDescriptorProtoPOJO getDescritorProtoPOJO(FileDescriptorProtoPOJO fileDescriptorProto, EnumElement typeElement, Set<String> messageSet, Set<String> enumSet) {
        List options;
        EnumDescriptorProtoPOJO ret = new EnumDescriptorProtoPOJO();
        ret.name = typeElement.name();
        ret.values = new ArrayList<EnumValueDescriptorProtoPOJO>();
        ret.options = new ArrayList<EnumOptionsPOJO>();
        List values = typeElement.constants();
        if (values != null) {
            for (EnumConstantElement fieldElement : values) {
                EnumValueDescriptorProtoPOJO fieldDescriptorProto = new EnumValueDescriptorProtoPOJO();
                fieldDescriptorProto.name = fieldElement.name();
                fieldDescriptorProto.number = fieldElement.tag();
                ret.values.add(fieldDescriptorProto);
            }
        }
        if ((options = typeElement.options()) != null) {
            for (OptionElement option : options) {
                EnumOptionsPOJO fieldDescriptorProto = new EnumOptionsPOJO();
                ret.options.add(fieldDescriptorProto);
            }
        }
        return ret;
    }

    private static DescriptorProtoPOJO getDescritorProtoPOJO(FileDescriptorProtoPOJO fileDescriptorProto, MessageElement typeElement, Set<String> messageSet, Set<String> enumSet) {
        List nestedElements;
        DescriptorProtoPOJO ret = new DescriptorProtoPOJO();
        ret.name = typeElement.name();
        ret.fields = new ArrayList<FieldDescriptorProtoPOJO>();
        ret.nestedTypes = new ArrayList<DescriptorProtoPOJO>();
        ret.enumTypes = new ArrayList<EnumDescriptorProtoPOJO>();
        ret.extensionRanges = new ArrayList<ExtensionRangePOJO>();
        ret.extensions = new ArrayList<FieldDescriptorProtoPOJO>();
        ret.options = new ArrayList<MessageOptionsPOJO>();
        ret.oneofDecls = new ArrayList<OneofDescriptorProtoPOJO>();
        List fields = typeElement.fields();
        if (fields != null) {
            for (FieldElement fieldElement : fields) {
                FieldDescriptorProtoPOJO fieldDescriptorProto = new FieldDescriptorProtoPOJO();
                fieldDescriptorProto.name = fieldElement.name();
                fieldDescriptorProto.extendee = null;
                fieldDescriptorProto.number = fieldElement.tag();
                FieldElement.Label label = fieldElement.label();
                if (label == FieldElement.Label.OPTIONAL) {
                    fieldDescriptorProto.label = Label.LABEL_OPTIONAL;
                } else if (label == FieldElement.Label.REQUIRED) {
                    fieldDescriptorProto.label = Label.LABEL_REQUIRED;
                } else if (label == FieldElement.Label.REPEATED) {
                    fieldDescriptorProto.label = Label.LABEL_REPEATED;
                }
                DataType type = fieldElement.type();
                if (type.kind() == DataType.Kind.MAP) {
                    String messageName = StringUtils.capitalize(fieldDescriptorProto.name) + MAP_ENTRY_SUFFIX;
                    fieldDescriptorProto.type = Type.TYPE_MESSAGE;
                    fieldDescriptorProto.typeName = "." + fileDescriptorProto.pkg + "." + ret.name + "." + messageName;
                    fieldDescriptorProto.label = Label.LABEL_REPEATED;
                    DataType.MapType mapType = (DataType.MapType)type;
                    MessageElement messageElement = CodedConstant.getMapKVMessageElements(messageName, mapType);
                    ret.nestedTypes.add(CodedConstant.getDescritorProtoPOJO(fileDescriptorProto, messageElement, messageSet, enumSet));
                } else if (type.kind() == DataType.Kind.MAP || type.kind() == DataType.Kind.NAMED) {
                    fieldDescriptorProto.typeName = ((DataType.NamedType)type).name();
                    fieldDescriptorProto.type = messageSet.contains(fieldDescriptorProto.typeName) ? Type.TYPE_MESSAGE : Type.TYPE_ENUM;
                } else {
                    fieldDescriptorProto.type = Type.valueOf("TYPE_" + ((DataType.ScalarType)type).name());
                }
                ret.fields.add(fieldDescriptorProto);
            }
        }
        if ((nestedElements = typeElement.nestedElements()) != null) {
            for (TypeElement nestedTypeElement : nestedElements) {
                if (nestedTypeElement instanceof MessageElement) {
                    ret.nestedTypes.add(CodedConstant.getDescritorProtoPOJO(fileDescriptorProto, (MessageElement)nestedTypeElement, messageSet, enumSet));
                    continue;
                }
                if (!(nestedTypeElement instanceof EnumElement)) continue;
                ret.enumTypes.add(CodedConstant.getDescritorProtoPOJO(fileDescriptorProto, (EnumElement)nestedTypeElement, messageSet, enumSet));
            }
        }
        return ret;
    }

    private static MessageElement getMapKVMessageElements(String name, DataType.MapType mapType) {
        MessageElement.Builder ret = MessageElement.builder();
        ret.name(name);
        DataType keyType = mapType.keyType();
        FieldElement.Builder fieldBuilder = FieldElement.builder().name("key").tag(1);
        fieldBuilder.type(keyType).label(FieldElement.Label.OPTIONAL);
        ret.addField(fieldBuilder.build());
        DataType valueType = mapType.valueType();
        fieldBuilder = FieldElement.builder().name("value").tag(2);
        fieldBuilder.type(valueType).label(FieldElement.Label.OPTIONAL);
        ret.addField(fieldBuilder.build());
        return ret.build();
    }

    private static List<Integer> convertList(List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Integer> ret = new ArrayList<Integer>(list.size());
        for (String v : list) {
            ret.add(StringUtils.toInt(v));
        }
        return ret;
    }
}

