/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.annotations.NonNull;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Warning
implements Comparable<Warning> {
    public final Issue issue;
    public final String message;
    public final Severity severity;
    public final Object data;
    public final Project project;
    public AndroidProject gradleProject;
    public Location location;
    public File file;
    public String path;
    public int line = -1;
    public int offset = -1;
    public String errorLine;
    public String fileContents;
    public Set<Variant> variants;

    public Warning(Issue issue, String message, Severity severity, Project project, Object data) {
        this.issue = issue;
        this.message = message;
        this.severity = severity;
        this.project = project;
        this.data = data;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(@NonNull Warning other) {
        int categoryDelta = this.issue.getCategory().compareTo(other.issue.getCategory());
        if (categoryDelta != 0) {
            return categoryDelta;
        }
        int priorityDelta = other.issue.getPriority() - this.issue.getPriority();
        if (priorityDelta != 0) {
            return priorityDelta;
        }
        String id1 = this.issue.getId();
        String id2 = other.issue.getId();
        assert (id1 != null);
        assert (id2 != null);
        int idDelta = id1.compareTo(id2);
        if (idDelta != 0) {
            return idDelta;
        }
        if (this.file != null) {
            if (other.file == null) return -1;
            int fileDelta = this.file.getName().compareTo(other.file.getName());
            if (fileDelta != 0) {
                return fileDelta;
            }
        } else if (other.file != null) {
            return 1;
        }
        if (this.line == other.line) return this.message.compareTo(other.message);
        return this.line - other.line;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Warning warning = (Warning)o;
        if (this.line != warning.line) {
            return false;
        }
        if (this.file != null ? !this.file.equals(warning.file) : warning.file != null) {
            return false;
        }
        if (!this.issue.getCategory().equals(warning.issue.getCategory())) {
            return false;
        }
        if (this.issue.getPriority() != warning.issue.getPriority()) {
            return false;
        }
        if (!this.issue.getId().equals(warning.issue.getId())) {
            return false;
        }
        return this.message.equals(warning.message);
    }

    public int hashCode() {
        int result = this.message.hashCode();
        result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
        return result;
    }

    public boolean isVariantSpecific() {
        return this.variants != null && this.variants.size() < this.gradleProject.getVariants().size();
    }

    public boolean includesMoreThanExcludes() {
        int allVariantCount;
        assert (this.isVariantSpecific());
        int variantCount = this.variants.size();
        return variantCount <= (allVariantCount = this.gradleProject.getVariants().size()) - variantCount;
    }

    public List<String> getIncludedVariantNames() {
        assert (this.isVariantSpecific());
        ArrayList<String> names = new ArrayList<String>();
        if (this.variants != null) {
            for (Variant variant : this.variants) {
                names.add(variant.getName());
            }
        }
        Collections.sort(names);
        return names;
    }

    public List<String> getExcludedVariantNames() {
        assert (this.isVariantSpecific());
        Collection variants = this.gradleProject.getVariants();
        HashSet<String> allVariants = new HashSet<String>(variants.size());
        for (Variant variant : variants) {
            allVariants.add(variant.getName());
        }
        HashSet<String> included = new HashSet<String>(this.getIncludedVariantNames());
        Sets.SetView excluded = Sets.difference(allVariants, included);
        ArrayList sorted = Lists.newArrayList((Iterable)excluded);
        Collections.sort(sorted);
        return sorted;
    }
}

