/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.IJavaParser;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import java.io.File;
import java.util.List;
import lombok.ast.CompilationUnit;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.TypeReference;
import lombok.ast.grammar.Source;

public class LombokParser
implements IJavaParser {
    public Node parseJava(@NonNull JavaContext context) {
        try {
            Source source = new Source(context.getContents(), context.file.getName());
            List nodes = source.getNodes();
            List problems = source.getProblems();
            if (problems != null && !problems.isEmpty()) {
                context.getDriver().setHasParserErrors(true);
                return null;
            }
            for (Node node : nodes) {
                if (!(node instanceof CompilationUnit)) continue;
                return node;
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    @NonNull
    public Location getLocation(@NonNull JavaContext context, @NonNull Node node) {
        Position position = node.getPosition();
        return Location.create((File)context.file, (String)context.getContents(), (int)position.getStart(), (int)position.getEnd());
    }

    @NonNull
    public Location.Handle createLocationHandle(@NonNull JavaContext context, @NonNull Node node) {
        return new LocationHandle(context.file, node);
    }

    public void dispose(@NonNull JavaContext context, @NonNull Node compilationUnit) {
    }

    @Nullable
    public Node resolve(@NonNull JavaContext context, @NonNull Node node) {
        return null;
    }

    @Nullable
    public TypeReference getType(@NonNull JavaContext context, @NonNull Node node) {
        return null;
    }

    private static class LocationHandle
    implements Location.Handle {
        private final File mFile;
        private final Node mNode;
        private Object mClientData;

        public LocationHandle(File file, Node node) {
            this.mFile = file;
            this.mNode = node;
        }

        @NonNull
        public Location resolve() {
            Position pos = this.mNode.getPosition();
            return Location.create((File)this.mFile, null, (int)pos.getStart(), (int)pos.getEnd());
        }

        public void setClientData(@Nullable Object clientData) {
            this.mClientData = clientData;
        }

        @Nullable
        public Object getClientData() {
            return this.mClientData;
        }
    }
}

