/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.ServiceSignature;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.parser.RequestMarshallers;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.HttpUtil;
import com.aliyun.oss.internal.OSSCallbackErrorResponseHandler;
import com.aliyun.oss.internal.OSSOperation;
import com.aliyun.oss.internal.OSSRequestMessageBuilder;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.internal.ResponseParsers;
import com.aliyun.oss.internal.SignUtils;
import com.aliyun.oss.model.CreateLiveChannelRequest;
import com.aliyun.oss.model.CreateLiveChannelResult;
import com.aliyun.oss.model.GenerateRtmpUriRequest;
import com.aliyun.oss.model.GenerateVodPlaylistRequest;
import com.aliyun.oss.model.ListLiveChannelsRequest;
import com.aliyun.oss.model.LiveChannel;
import com.aliyun.oss.model.LiveChannelGenericRequest;
import com.aliyun.oss.model.LiveChannelInfo;
import com.aliyun.oss.model.LiveChannelListing;
import com.aliyun.oss.model.LiveChannelStat;
import com.aliyun.oss.model.LiveRecord;
import com.aliyun.oss.model.SetLiveChannelRequest;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LiveChannelOperation
extends OSSOperation {
    public LiveChannelOperation(ServiceClient client, CredentialsProvider credsProvider) {
        super(client, credsProvider);
    }

    public CreateLiveChannelResult createLiveChannel(CreateLiveChannelRequest createLiveChannelRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(createLiveChannelRequest, "createLiveChannelRequest");
        String bucketName = createLiveChannelRequest.getBucketName();
        String liveChannelName = createLiveChannelRequest.getLiveChannelName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(liveChannelName, "liveChannelName");
        OSSUtils.ensureLiveChannelNameValid(liveChannelName);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("live", null);
        byte[] rawContent = RequestMarshallers.createLiveChannelRequestMarshaller.marshall(createLiveChannelRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        LiveChannelOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setKey(liveChannelName).setParameters(parameters).setHeaders(headers).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(createLiveChannelRequest).build();
        ArrayList<OSSCallbackErrorResponseHandler> reponseHandlers = new ArrayList<OSSCallbackErrorResponseHandler>();
        reponseHandlers.add(new OSSCallbackErrorResponseHandler());
        return this.doOperation(request, ResponseParsers.createLiveChannelResponseParser, bucketName, liveChannelName, true);
    }

    public void setLiveChannelStatus(SetLiveChannelRequest setLiveChannelRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setLiveChannelRequest, "setLiveChannelRequest");
        String bucketName = setLiveChannelRequest.getBucketName();
        String liveChannelName = setLiveChannelRequest.getLiveChannelName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(liveChannelName, "liveChannelName");
        OSSUtils.ensureLiveChannelNameValid(liveChannelName);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("live", null);
        parameters.put("status", setLiveChannelRequest.getLiveChannelStatus().toString());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setKey(liveChannelName).setParameters(parameters).setOriginalRequest(setLiveChannelRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, liveChannelName);
    }

    public LiveChannelInfo getLiveChannelInfo(LiveChannelGenericRequest liveChannelGenericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(liveChannelGenericRequest, "liveChannelGenericRequest");
        String bucketName = liveChannelGenericRequest.getBucketName();
        String liveChannelName = liveChannelGenericRequest.getLiveChannelName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(liveChannelName, "liveChannelName");
        OSSUtils.ensureLiveChannelNameValid(liveChannelName);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("live", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setKey(liveChannelName).setParameters(parameters).setOriginalRequest(liveChannelGenericRequest).build();
        return this.doOperation(request, ResponseParsers.getLiveChannelInfoResponseParser, bucketName, liveChannelName, true);
    }

    public LiveChannelStat getLiveChannelStat(LiveChannelGenericRequest liveChannelGenericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(liveChannelGenericRequest, "liveChannelGenericRequest");
        String bucketName = liveChannelGenericRequest.getBucketName();
        String liveChannelName = liveChannelGenericRequest.getLiveChannelName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(liveChannelName, "liveChannelName");
        OSSUtils.ensureLiveChannelNameValid(liveChannelName);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("live", null);
        parameters.put("comp", "stat");
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setKey(liveChannelName).setParameters(parameters).setOriginalRequest(liveChannelGenericRequest).build();
        return this.doOperation(request, ResponseParsers.getLiveChannelStatResponseParser, bucketName, liveChannelName, true);
    }

    public void deleteLiveChannel(LiveChannelGenericRequest liveChannelGenericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(liveChannelGenericRequest, "liveChannelGenericRequest");
        String bucketName = liveChannelGenericRequest.getBucketName();
        String liveChannelName = liveChannelGenericRequest.getLiveChannelName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(liveChannelName, "liveChannelName");
        OSSUtils.ensureLiveChannelNameValid(liveChannelName);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("live", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setKey(liveChannelName).setParameters(parameters).setOriginalRequest(liveChannelGenericRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, liveChannelName);
    }

    public List<LiveChannel> listLiveChannels(String bucketName) throws OSSException, ClientException {
        LiveChannelListing liveChannelListing = this.listLiveChannels(new ListLiveChannelsRequest(bucketName));
        List<LiveChannel> liveChannels = liveChannelListing.getLiveChannels();
        while (liveChannelListing.isTruncated()) {
            liveChannelListing = this.listLiveChannels(new ListLiveChannelsRequest(bucketName, liveChannelListing.getNextMarker(), null));
            liveChannels.addAll(liveChannelListing.getLiveChannels());
        }
        return liveChannels;
    }

    public LiveChannelListing listLiveChannels(ListLiveChannelsRequest listLiveChannelRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(listLiveChannelRequest, "listObjectsRequest");
        String bucketName = listLiveChannelRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("live", null);
        LiveChannelOperation.populateListLiveChannelsRequestParameters(listLiveChannelRequest, parameters);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(parameters).setOriginalRequest(listLiveChannelRequest).build();
        return this.doOperation(request, ResponseParsers.listLiveChannelsReponseParser, bucketName, null, true);
    }

    public List<LiveRecord> getLiveChannelHistory(LiveChannelGenericRequest liveChannelGenericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(liveChannelGenericRequest, "liveChannelGenericRequest");
        String bucketName = liveChannelGenericRequest.getBucketName();
        String liveChannelName = liveChannelGenericRequest.getLiveChannelName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(liveChannelName, "liveChannelName");
        OSSUtils.ensureLiveChannelNameValid(liveChannelName);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("live", null);
        parameters.put("comp", "history");
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setKey(liveChannelName).setParameters(parameters).setOriginalRequest(liveChannelGenericRequest).build();
        return this.doOperation(request, ResponseParsers.getLiveChannelHistoryResponseParser, bucketName, liveChannelName, true);
    }

    public void generateVodPlaylist(GenerateVodPlaylistRequest generateVodPlaylistRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(generateVodPlaylistRequest, "generateVodPlaylistRequest");
        String bucketName = generateVodPlaylistRequest.getBucketName();
        String liveChannelName = generateVodPlaylistRequest.getLiveChannelName();
        String playlistName = generateVodPlaylistRequest.getPlaylistName();
        Long startTime = generateVodPlaylistRequest.getStratTime();
        Long endTime = generateVodPlaylistRequest.getEndTime();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(liveChannelName, "liveChannelName");
        OSSUtils.ensureLiveChannelNameValid(liveChannelName);
        CodingUtils.assertParameterNotNull(playlistName, "playlistName");
        CodingUtils.assertParameterNotNull(startTime, "stratTime");
        CodingUtils.assertParameterNotNull(endTime, "endTime");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("vod", null);
        parameters.put("startTime", startTime.toString());
        parameters.put("endTime", endTime.toString());
        String key = liveChannelName + "/" + playlistName;
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.POST).setBucket(bucketName).setKey(key).setParameters(parameters).setInputStream(new ByteArrayInputStream(new byte[0])).setInputSize(0L).setOriginalRequest(generateVodPlaylistRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, key);
    }

    public String generateRtmpUri(GenerateRtmpUriRequest request) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(request, "request");
        String bucketName = request.getBucketName();
        String liveChannelName = request.getLiveChannelName();
        String playlistName = request.getPlaylistName();
        Long expires = request.getExpires();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(liveChannelName, "liveChannelName");
        OSSUtils.ensureLiveChannelNameValid(liveChannelName);
        CodingUtils.assertParameterNotNull(playlistName, "playlistName");
        CodingUtils.assertParameterNotNull(expires, "expires");
        Credentials currentCreds = this.credsProvider.getCredentials();
        String accessId = currentCreds.getAccessKeyId();
        String accessKey = currentCreds.getSecretAccessKey();
        boolean useSecurityToken = currentCreds.useSecurityToken();
        RequestMessage requestMessage = new RequestMessage(bucketName, liveChannelName);
        ClientConfiguration config = this.client.getClientConfiguration();
        requestMessage.setEndpoint(OSSUtils.determineFinalEndpoint(this.endpoint, bucketName, config));
        requestMessage.addHeader("Date", expires.toString());
        requestMessage.addParameter("playlistName", playlistName);
        if (useSecurityToken) {
            requestMessage.addParameter("security-token", currentCreds.getSecurityToken());
        }
        String canonicalResource = "/" + bucketName + "/" + liveChannelName;
        String canonicalString = SignUtils.buildRtmpCanonicalString(canonicalResource, requestMessage, expires.toString());
        String signature = ServiceSignature.create().computeSignature(accessKey, canonicalString);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("Expires", expires.toString());
        params.put("OSSAccessKeyId", accessId);
        params.put("Signature", signature);
        params.putAll(requestMessage.getParameters());
        String queryString = HttpUtil.paramToQueryString(params, "utf-8");
        String uri = requestMessage.getEndpoint().toString();
        String livChan = "live/" + liveChannelName;
        if (uri.startsWith("http://")) {
            uri = uri.replaceFirst("http://", "rtmp://");
        } else if (uri.startsWith("https://")) {
            uri = uri.replaceFirst("https://", "rtmp://");
        } else if (!uri.startsWith("rtmp://")) {
            uri = "rtmp://" + uri;
        }
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        uri = uri + livChan + "?" + queryString;
        return uri;
    }

    private static void populateListLiveChannelsRequestParameters(ListLiveChannelsRequest listLiveChannelRequest, Map<String, String> params) {
        if (listLiveChannelRequest.getPrefix() != null) {
            params.put("prefix", listLiveChannelRequest.getPrefix());
        }
        if (listLiveChannelRequest.getMarker() != null) {
            params.put("marker", listLiveChannelRequest.getMarker());
        }
        if (listLiveChannelRequest.getMaxKeys() != null) {
            params.put("max-keys", Integer.toString(listLiveChannelRequest.getMaxKeys()));
        }
    }

    private static void addRequestRequiredHeaders(Map<String, String> headers, byte[] rawContent) {
        headers.put("Content-Length", String.valueOf(rawContent.length));
        byte[] md5 = BinaryUtil.calculateMd5(rawContent);
        String md5Base64 = BinaryUtil.toBase64String(md5);
        headers.put("Content-MD5", md5Base64);
    }
}

