/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.common.comm.ExecutionContext;
import com.aliyun.oss.common.comm.RepeatableInputStreamEntity;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.comm.io.ChunkedInputStreamEntity;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;

class HttpRequestFactory {
    HttpRequestFactory() {
    }

    public HttpRequestBase createHttpRequest(ServiceClient.Request request, ExecutionContext context) {
        HttpPost httpRequest;
        String uri = request.getUri();
        HttpMethod method = request.getMethod();
        if (method == HttpMethod.POST) {
            HttpPost postMethod = new HttpPost(uri);
            if (request.getContent() != null) {
                postMethod.setEntity((HttpEntity)new RepeatableInputStreamEntity(request));
            }
            httpRequest = postMethod;
        } else if (method == HttpMethod.PUT) {
            HttpPut putMethod = new HttpPut(uri);
            if (request.getContent() != null) {
                if (request.isUseChunkEncoding()) {
                    putMethod.setEntity(this.buildChunkedInputStreamEntity(request));
                } else {
                    putMethod.setEntity((HttpEntity)new RepeatableInputStreamEntity(request));
                }
            }
            httpRequest = putMethod;
        } else if (method == HttpMethod.GET) {
            httpRequest = new HttpGet(uri);
        } else if (method == HttpMethod.DELETE) {
            httpRequest = new HttpDelete(uri);
        } else if (method == HttpMethod.HEAD) {
            httpRequest = new HttpHead(uri);
        } else if (method == HttpMethod.OPTIONS) {
            httpRequest = new HttpOptions(uri);
        } else {
            throw new ClientException("Unknown HTTP method name: " + method.toString());
        }
        this.configureRequestHeaders(request, context, (HttpRequestBase)httpRequest);
        return httpRequest;
    }

    private HttpEntity buildChunkedInputStreamEntity(ServiceClient.Request request) {
        return new ChunkedInputStreamEntity(request);
    }

    private void configureRequestHeaders(ServiceClient.Request request, ExecutionContext context, HttpRequestBase httpRequest) {
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length") || entry.getKey().equalsIgnoreCase("Host")) continue;
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
    }
}

