/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.odps.Column;
import com.aliyun.odps.Instance;
import com.aliyun.odps.LogView;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.Table;
import com.aliyun.odps.jdbc.OdpsConnection;
import com.aliyun.odps.jdbc.OdpsForwardResultSet;
import com.aliyun.odps.jdbc.OdpsResultSetMetaData;
import com.aliyun.odps.jdbc.OdpsScollResultSet;
import com.aliyun.odps.jdbc.WrapperAdapter;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Logger;

public class OdpsStatement
extends WrapperAdapter
implements Statement {
    private OdpsConnection connHanlde;
    private Instance executeInstance = null;
    private ResultSet resultSet = null;
    private String tempTable = null;
    private int updateCount = -1;
    boolean updateCountFeteched = false;
    private boolean isClosed = false;
    private boolean isCancelled = false;
    private static final int POOLING_INTERVAL = 1000;
    protected boolean isResultSetScrollable = false;
    protected FetchDirection resultSetFetchDirection = FetchDirection.UNKNOWN;
    protected int resultSetMaxRows = 0;
    protected int resultSetFetchSize = 10000;
    private SQLWarning warningChain = null;

    OdpsStatement(OdpsConnection conn) {
        this(conn, false);
    }

    OdpsStatement(OdpsConnection conn, boolean isResultSetScrollable) {
        this.connHanlde = conn;
        this.isResultSetScrollable = isResultSetScrollable;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClosed();
        if (this.isCancelled || this.executeInstance == null) {
            return;
        }
        try {
            this.executeInstance.stop();
            this.connHanlde.log.fine("submit cancel to instance id=" + this.executeInstance.getId());
        }
        catch (OdpsException e) {
            throw new SQLException(e);
        }
        this.isCancelled = true;
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        if (this.tempTable != null) {
            this.runSilentSQL("drop table " + this.tempTable + ";");
            this.connHanlde.log.fine("silently drop temp table: " + this.tempTable);
            this.tempTable = null;
        }
        this.connHanlde.log.fine("the statement has been closed");
        this.connHanlde = null;
        this.executeInstance = null;
        this.isClosed = true;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        TableTunnel.DownloadSession session;
        this.checkClosed();
        this.beforeExecute();
        long begin = System.currentTimeMillis();
        String tempTempTable = "jdbc_temp_tbl_" + UUID.randomUUID().toString().replaceAll("-", "_");
        try {
            this.executeInstance = this.runClientSQL("create table " + tempTempTable + " lifecycle " + this.connHanlde.lifecycle + " as " + sql);
            boolean complete = false;
            while (!complete) {
                Instance.TaskStatus.Status status;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                try {
                    status = ((Instance.TaskStatus)this.executeInstance.getTaskStatus().get("SQL")).getStatus();
                }
                catch (NullPointerException e) {
                    continue;
                }
                switch (status) {
                    case SUCCESS: {
                        complete = true;
                        break;
                    }
                    case FAILED: {
                        String reason = (String)this.executeInstance.getTaskResults().get("SQL");
                        this.connHanlde.log.fine("create temp table failed: " + reason);
                        throw new SQLException("create temp table failed: " + reason, "FAILED");
                    }
                    case CANCELLED: {
                        this.connHanlde.log.info("create temp table cancelled");
                        throw new SQLException("create temp table cancelled", "CANCELLED");
                    }
                }
            }
        }
        catch (OdpsException e) {
            this.connHanlde.log.fine("create temp table failed: " + e.getMessage());
            throw new SQLException(e);
        }
        this.tempTable = tempTempTable;
        long end = System.currentTimeMillis();
        this.connHanlde.log.fine("It took me " + (end - begin) + " ms to create " + this.tempTable);
        begin = System.currentTimeMillis();
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<OdpsType> columnSqlTypes = new ArrayList<OdpsType>();
        try {
            Table table = this.connHanlde.getOdps().tables().get(this.tempTable);
            table.reload();
            for (Column col : table.getSchema().getColumns()) {
                columnNames.add(col.getName());
                columnSqlTypes.add(col.getType());
            }
        }
        catch (OdpsException e) {
            throw new SQLException(e);
        }
        OdpsResultSetMetaData meta = new OdpsResultSetMetaData(columnNames, columnSqlTypes);
        end = System.currentTimeMillis();
        this.connHanlde.log.fine("It took me " + (end - begin) + " ms to read the table schema");
        try {
            TableTunnel tunnel = new TableTunnel(this.connHanlde.getOdps());
            String project_name = this.connHanlde.getOdps().getDefaultProject();
            session = tunnel.createDownloadSession(project_name, this.tempTable);
            this.connHanlde.log.info("create download session id=" + session.getId());
        }
        catch (TunnelException e) {
            throw new SQLException(e);
        }
        this.resultSet = this.isResultSetScrollable ? new OdpsScollResultSet(this, meta, session) : new OdpsForwardResultSet(this, meta, session);
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkClosed();
        this.beforeExecute();
        long begin = System.currentTimeMillis();
        try {
            JSONObject jsonSummary;
            JSONObject outputs;
            this.executeInstance = this.runClientSQL(sql);
            boolean complete = false;
            while (!complete) {
                Instance.TaskStatus.Status status;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                try {
                    status = ((Instance.TaskStatus)this.executeInstance.getTaskStatus().get("SQL")).getStatus();
                }
                catch (NullPointerException e) {
                    continue;
                }
                switch (status) {
                    case SUCCESS: {
                        complete = true;
                        break;
                    }
                    case FAILED: {
                        this.connHanlde.log.fine("update failed");
                        throw new SQLException((String)this.executeInstance.getTaskResults().get("SQL"), "FAILED");
                    }
                    case CANCELLED: {
                        this.connHanlde.log.info("update cancelled");
                        throw new SQLException("update cancelled", "CANCELLED");
                    }
                }
            }
            long end = System.currentTimeMillis();
            this.connHanlde.log.fine("It took me " + (end - begin) + " ms to execute update");
            Instance.TaskSummary taskSummary = this.executeInstance.getTaskSummary("SQL");
            if (taskSummary != null && (outputs = (jsonSummary = JSON.parseObject((String)taskSummary.getJsonSummary())).getJSONObject("Outputs")).size() > 0) {
                this.updateCount = 0;
                for (Object item : outputs.values()) {
                    JSONArray array = (JSONArray)item;
                    this.updateCount += array.getInteger(0).intValue();
                }
            }
        }
        catch (OdpsException e) {
            throw new SQLException(e);
        }
        this.connHanlde.log.fine("successfully updated " + this.updateCount + " records");
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        if (OdpsStatement.isQuery(sql)) {
            this.executeQuery(sql);
            return true;
        }
        this.executeUpdate(sql);
        return false;
    }

    public static boolean isQuery(String sql) throws SQLException {
        BufferedReader reader = new BufferedReader(new StringReader(sql));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.matches("^\\s*(--|#).*") || line.matches("^\\s*$")) continue;
                if (!line.matches("(?i)^(\\s*)(SELECT).*$")) break;
                return true;
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public OdpsConnection getConnection() throws SQLException {
        return this.connHanlde;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        int direction;
        this.checkClosed();
        switch (this.resultSetFetchDirection) {
            case FORWARD: {
                direction = 1000;
                break;
            }
            case REVERSE: {
                direction = 1001;
                break;
            }
            default: {
                direction = 1002;
            }
        }
        return direction;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.resultSetFetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        this.resultSetFetchSize = rows;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.resultSetMaxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("max must be >= 0");
        }
        this.resultSetMaxRows = max;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.updateCountFeteched) {
            return -1;
        }
        this.updateCountFeteched = true;
        return this.updateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: {
                this.resultSetFetchDirection = FetchDirection.FORWARD;
                break;
            }
            case 1001: {
                this.resultSetFetchDirection = FetchDirection.REVERSE;
                break;
            }
            case 1002: {
                this.resultSetFetchDirection = FetchDirection.UNKNOWN;
                break;
            }
            default: {
                throw new SQLException("invalid argument for setFetchDirection()");
            }
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private void beforeExecute() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        if (this.tempTable != null) {
            this.runSilentSQL("drop table if exists " + this.tempTable + ";");
            this.connHanlde.log.fine("silently drop temp table: " + this.tempTable);
            this.tempTable = null;
        }
        this.executeInstance = null;
        this.isClosed = false;
        this.isCancelled = false;
        this.updateCount = -1;
    }

    protected Logger getParentLogger() {
        return this.connHanlde.log;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("The statement has been closed");
        }
    }

    private Instance runClientSQL(String sql) throws SQLException {
        Instance instance;
        try {
            HashMap hints = new HashMap();
            HashMap aliases = new HashMap();
            if (!sql.contains(";")) {
                sql = sql + ";";
            }
            Odps odps = this.connHanlde.getOdps();
            instance = SQLTask.run((Odps)odps, (String)odps.getDefaultProject(), (String)sql, (String)"SQL", hints, aliases);
            LogView logView = new LogView(odps);
            if (this.connHanlde.getLogviewHost() != null) {
                logView.setLogViewHost(this.connHanlde.getLogviewHost());
            }
            String logViewUrl = logView.generateLogView(instance, 168L);
            this.connHanlde.log.fine("Run SQL: " + sql);
            this.connHanlde.log.info(logViewUrl);
            this.warningChain = new SQLWarning(logViewUrl);
        }
        catch (OdpsException e) {
            this.connHanlde.log.severe("fail to run sql: " + sql);
            throw new SQLException(e);
        }
        return instance;
    }

    private void runSilentSQL(String sql) throws SQLException {
        try {
            long begin = System.currentTimeMillis();
            Odps odps = this.connHanlde.getOdps();
            SQLTask.run((Odps)odps, (String)sql).waitForSuccess();
            long end = System.currentTimeMillis();
            this.connHanlde.log.fine("It took me " + (end - begin) + " ms to run SQL: " + sql);
        }
        catch (OdpsException e) {
            throw new SQLException(e);
        }
    }

    static enum FetchDirection {
        FORWARD,
        REVERSE,
        UNKNOWN;

    }
}

