/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.common.http;

import com.aliyun.mns.common.http.ClientConfiguration;
import com.aliyun.mns.common.http.DefaultServiceClient;
import com.aliyun.mns.common.http.ServiceClient;
import java.util.HashMap;
import java.util.Map;

public class ServiceClientFactory {
    private static final Object lock = new Object();
    private static final Map<ClientConfiguration, ServiceClient> serviceClientMap = new HashMap<ClientConfiguration, ServiceClient>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceClient createServiceClient(ClientConfiguration config) {
        Map<ClientConfiguration, ServiceClient> map = serviceClientMap;
        synchronized (map) {
            ServiceClient serviceClient = serviceClientMap.get(config);
            if (serviceClient == null) {
                serviceClient = new DefaultServiceClient(config);
                serviceClientMap.put(config, serviceClient);
            } else {
                serviceClient.ref();
            }
            return serviceClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeServiceClient(ServiceClient serviceClient) {
        Map<ClientConfiguration, ServiceClient> map = serviceClientMap;
        synchronized (map) {
            int count = serviceClient.unRef();
            if (count == 0) {
                serviceClientMap.remove(serviceClient.getClientConfigurationNoClone());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getServiceClientCount() {
        Map<ClientConfiguration, ServiceClient> map = serviceClientMap;
        synchronized (map) {
            return serviceClientMap.size();
        }
    }
}

