/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.common.http;

import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.common.HttpMethod;
import com.aliyun.mns.common.ServiceException;
import com.aliyun.mns.common.comm.ExecutionContext;
import com.aliyun.mns.common.comm.RequestHandler;
import com.aliyun.mns.common.comm.ResponseHandler;
import com.aliyun.mns.common.comm.RetryStrategy;
import com.aliyun.mns.common.http.ClientConfiguration;
import com.aliyun.mns.common.http.HttpCallback;
import com.aliyun.mns.common.http.HttpMesssage;
import com.aliyun.mns.common.http.RequestMessage;
import com.aliyun.mns.common.http.ResponseMessage;
import com.aliyun.mns.common.utils.HttpUtil;
import com.aliyun.mns.common.utils.ResourceManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;

public abstract class ServiceClient {
    private static final int DEFAULT_MARK_LIMIT = 4096;
    private static final Log log = LogFactory.getLog(ServiceClient.class);
    private static ResourceManager rm = ResourceManager.getInstance("common");
    private ClientConfiguration config;

    protected ServiceClient(ClientConfiguration config) {
        this.config = config;
    }

    public ClientConfiguration getClientConfiguration() {
        try {
            return (ClientConfiguration)this.config.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    ClientConfiguration getClientConfigurationNoClone() {
        return this.config;
    }

    public <T> Future<HttpResponse> sendRequest(RequestMessage request, ExecutionContext context, HttpCallback<T> callback) {
        if (!this.isOpen()) {
            throw new ClientException("Client is already closed!", callback.getUserRequestId());
        }
        return this.sendRequestImpl(request, context, callback);
    }

    private <T> Future<HttpResponse> sendRequestImpl(RequestMessage request, ExecutionContext context, HttpCallback<T> callback) throws ClientException, ServiceException {
        RetryStrategy retryStrategy;
        RetryStrategy retryStrategy2 = retryStrategy = context.getRetryStrategy() != null ? context.getRetryStrategy() : this.getDefaultRetryStrategy();
        if (context.getSigner() != null) {
            context.getSigner().sign(request);
        }
        int retries = 0;
        ResponseMessage response = null;
        InputStream content = request.getContent();
        if (content != null && content.markSupported()) {
            content.mark(4096);
        }
        while (true) {
            try {
                if (retries > 0) {
                    this.pause(retries, retryStrategy, callback.getUserRequestId());
                    if (content != null && content.markSupported()) {
                        content.reset();
                    }
                }
                Request httpRequest = this.buildRequest(request, context);
                this.handleRequest(httpRequest, context.getResquestHandlers());
                Future<HttpResponse> future = this.sendRequestCore(httpRequest, context, callback);
                return future;
            }
            catch (ServiceException ex) {
                this.closeResponseSilently(response);
                if (this.shouldRetry(ex, request, response, retries, retryStrategy)) continue;
                throw ex;
            }
            catch (ClientException ex) {
                this.closeResponseSilently(response);
                if (this.shouldRetry(ex, request, response, retries, retryStrategy)) continue;
                throw ex;
            }
            catch (Exception ex) {
                this.closeResponseSilently(response);
                throw new ClientException(rm.getFormattedString("ConnectionError", ex.getMessage()), callback.getUserRequestId(), ex);
            }
            finally {
                ++retries;
                continue;
            }
            break;
        }
    }

    protected abstract <T> Future<HttpResponse> sendRequestCore(Request var1, ExecutionContext var2, HttpCallback<T> var3) throws Exception;

    private Request buildRequest(RequestMessage requestMessage, ExecutionContext context) throws ClientException {
        boolean putParamsInUri;
        String paramString;
        Request request = new Request();
        request.setMethod(requestMessage.getMethod());
        request.setHeaders(requestMessage.getHeaders());
        if (request.getHeaders() != null) {
            HttpUtil.convertHeaderCharsetToIso88591(request.getHeaders());
        }
        String delimiter = "/";
        String uri = requestMessage.getEndpoint().toString();
        if (!(uri.endsWith("/") || requestMessage.getResourcePath() != null && requestMessage.getResourcePath().startsWith("/"))) {
            uri = uri + "/";
        }
        if (requestMessage.getResourcePath() != null) {
            uri = uri + requestMessage.getResourcePath();
        }
        try {
            paramString = HttpUtil.paramToQueryString(requestMessage.getParameters(), context.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)rm.getFormattedString("EncodingFailed", e.getMessage()));
        }
        boolean requestHasNoPayload = requestMessage.getContent() != null;
        boolean requestIsPost = requestMessage.getMethod() == HttpMethod.POST;
        boolean bl = putParamsInUri = !requestIsPost || requestHasNoPayload;
        if (paramString != null && putParamsInUri) {
            uri = uri + "?" + paramString;
        }
        request.setUrl(uri);
        if (requestIsPost && requestMessage.getContent() == null && paramString != null) {
            try {
                byte[] buf = paramString.getBytes(context.getCharset());
                ByteArrayInputStream content = new ByteArrayInputStream(buf);
                request.setContent(content);
                request.setContentLength(buf.length);
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)rm.getFormattedString("EncodingFailed", e.getMessage()));
            }
        } else {
            request.setContent(requestMessage.getContent());
            request.setContentLength(requestMessage.getContentLength());
        }
        return request;
    }

    private void handleResponse(ResponseMessage response, List<ResponseHandler> responseHandlers) throws ServiceException, ClientException {
        for (ResponseHandler h : responseHandlers) {
            h.handle(response);
        }
    }

    private void handleRequest(Request message, List<RequestHandler> resquestHandlers) throws ServiceException, ClientException {
        for (RequestHandler h : resquestHandlers) {
            h.handle(message);
        }
    }

    private void pause(int retries, RetryStrategy retryStrategy, String userRequestId) throws ClientException {
        long delay = retryStrategy.getPauseDelay(retries);
        log.debug((Object)("Retriable error detected, will retry in " + delay + "ms, attempt number: " + retries));
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            throw new ClientException(e.getMessage(), userRequestId, e);
        }
    }

    private boolean shouldRetry(Exception exception, RequestMessage request, ResponseMessage response, int retries, RetryStrategy retryStrategy) {
        if (retries >= this.config.getMaxErrorRetry()) {
            return false;
        }
        if (!request.isRepeatable()) {
            return false;
        }
        if (retryStrategy.shouldRetry(exception, request, response, retries)) {
            log.debug((Object)("Retrying on " + exception.getClass().getName() + ": " + exception.getMessage()));
            return true;
        }
        return false;
    }

    private void closeResponseSilently(ResponseMessage response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    abstract int ref();

    abstract int unRef();

    protected abstract void close();

    public abstract boolean isOpen();

    protected abstract RetryStrategy getDefaultRetryStrategy();

    public static class Request
    extends HttpMesssage {
        private String uri;
        private HttpMethod method;

        public String getUri() {
            return this.uri;
        }

        public void setUrl(String uri) {
            this.uri = uri;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public void setMethod(HttpMethod method) {
            this.method = method;
        }
    }
}

