/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.tracer.sofatracer;

import com.alipay.common.tracer.core.SofaTracer;
import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.context.trace.SofaTraceContext;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.reporter.facade.Reporter;
import com.alipay.common.tracer.core.reporter.stat.SofaTracerStatisticReporter;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.utils.ExceptionUtils;
import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.tracer.Tracer;
import com.alipay.sofa.rpc.tracer.sofatracer.factory.ReporterFactory;
import com.alipay.sofa.rpc.tracer.sofatracer.log.digest.RpcClientDigestSpanJsonEncoder;
import com.alipay.sofa.rpc.tracer.sofatracer.log.digest.RpcServerDigestSpanJsonEncoder;
import com.alipay.sofa.rpc.tracer.sofatracer.log.stat.RpcClientStatJsonReporter;
import com.alipay.sofa.rpc.tracer.sofatracer.log.stat.RpcServerStatJsonReporter;
import com.alipay.sofa.rpc.tracer.sofatracer.log.type.RpcTracerLogEnum;
import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;

@Extension(value="sofaTracer")
public class RpcSofaTracer
extends Tracer {
    public static final String RPC_TRACER_TYPE = "RPC_TRACER";
    public static final String ERROR_SOURCE = "rpc";
    private SofaTracer sofaTracer;

    public RpcSofaTracer() {
        SpanEncoder<SofaTracerSpan> clientEncoder = this.getClientSpanEncoder();
        SofaTracerStatisticReporter clientStats = this.generateClientStatReporter(RpcTracerLogEnum.RPC_CLIENT_STAT);
        Reporter clientReporter = this.generateReporter(clientStats, RpcTracerLogEnum.RPC_CLIENT_DIGEST, clientEncoder);
        SpanEncoder<SofaTracerSpan> serverEncoder = this.getServerSpanEncoder();
        SofaTracerStatisticReporter serverStats = this.generateServerStatReporter(RpcTracerLogEnum.RPC_SERVER_STAT);
        Reporter serverReporter = this.generateReporter(serverStats, RpcTracerLogEnum.RPC_SERVER_DIGEST, serverEncoder);
        this.sofaTracer = new SofaTracer.Builder(RPC_TRACER_TYPE).withClientReporter(clientReporter).withServerReporter(serverReporter).build();
    }

    protected SpanEncoder<SofaTracerSpan> getClientSpanEncoder() {
        return new RpcClientDigestSpanJsonEncoder();
    }

    protected SpanEncoder<SofaTracerSpan> getServerSpanEncoder() {
        return new RpcServerDigestSpanJsonEncoder();
    }

    protected SofaTracerStatisticReporter generateClientStatReporter(RpcTracerLogEnum statRpcTracerLogEnum) {
        String statLog = statRpcTracerLogEnum.getDefaultLogName();
        String statRollingPolicy = SofaTracerConfiguration.getRollingPolicy((String)statRpcTracerLogEnum.getRollingKey());
        String statLogReserveConfig = SofaTracerConfiguration.getLogReserveConfig((String)statRpcTracerLogEnum.getLogReverseKey());
        return new RpcClientStatJsonReporter(statLog, statRollingPolicy, statLogReserveConfig);
    }

    protected SofaTracerStatisticReporter generateServerStatReporter(RpcTracerLogEnum statRpcTracerLogEnum) {
        String statLog = statRpcTracerLogEnum.getDefaultLogName();
        String statRollingPolicy = SofaTracerConfiguration.getRollingPolicy((String)statRpcTracerLogEnum.getRollingKey());
        String statLogReserveConfig = SofaTracerConfiguration.getLogReserveConfig((String)statRpcTracerLogEnum.getLogReverseKey());
        return new RpcServerStatJsonReporter(statLog, statRollingPolicy, statLogReserveConfig);
    }

    protected Reporter generateReporter(SofaTracerStatisticReporter statReporter, RpcTracerLogEnum digestRpcTracerLogEnum, SpanEncoder<SofaTracerSpan> spanEncoder) {
        String digestLog = digestRpcTracerLogEnum.getDefaultLogName();
        String digestRollingPolicy = SofaTracerConfiguration.getRollingPolicy((String)digestRpcTracerLogEnum.getRollingKey());
        String digestLogReserveConfig = SofaTracerConfiguration.getLogReserveConfig((String)digestRpcTracerLogEnum.getLogReverseKey());
        Reporter reporter = ReporterFactory.build(digestLog, digestRollingPolicy, digestLogReserveConfig, spanEncoder, statReporter);
        return reporter;
    }

    @Override
    public void startRpc(SofaRequest request) {
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        SofaTracerSpan serverSpan = sofaTraceContext.pop();
        SofaTracerSpan clientSpan = (SofaTracerSpan)this.sofaTracer.buildSpan(request.getInterfaceName()).asChildOf((Span)serverSpan).withTag(Tags.SPAN_KIND.getKey(), "client").start();
        if (RpcInternalContext.isAttachmentEnable()) {
            RpcInternalContext context = RpcInternalContext.getContext();
            clientSpan.setTag("local.app", (String)context.getAttachment("_app_name"));
            clientSpan.setTag("protocol", (String)context.getAttachment("_protocol_name"));
            SofaTracerSpanContext spanContext = clientSpan.getSofaTracerSpanContext();
            if (spanContext != null) {
                context.setAttachment("_trace_id", spanContext.getTraceId());
                context.setAttachment("_span_id", spanContext.getSpanId());
            }
        }
        clientSpan.setTag("service", request.getTargetServiceUniqueName());
        clientSpan.setTag("method", request.getMethodName());
        clientSpan.setTag("current.thread.name", Thread.currentThread().getName());
        clientSpan.setParentSofaTracerSpan(serverSpan);
        sofaTraceContext.push(clientSpan);
    }

    @Override
    public void clientBeforeSend(SofaRequest request) {
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        SofaTracerSpan clientSpan = sofaTraceContext.getCurrentSpan();
        if (clientSpan == null) {
            SelfLog.warn((String)("ClientSpan is null.Before call interface=" + request.getInterfaceName() + ",method=" + request.getMethodName()));
            return;
        }
        SofaTracerSpanContext sofaTracerSpanContext = clientSpan.getSofaTracerSpanContext();
        RpcInternalContext rpcInternalContext = RpcInternalContext.getContext();
        ProviderInfo providerInfo = rpcInternalContext.getProviderInfo();
        if (providerInfo != null && providerInfo.getRpcVersion() >= 50100) {
            String serializedSpanContext = sofaTracerSpanContext.serializeSpanContext();
            request.addRequestProp("new_rpc_trace_context", serializedSpanContext);
        } else {
            HashMap<String, String> oldTracerContext = new HashMap<String, String>();
            oldTracerContext.put("sofaTraceId", sofaTracerSpanContext.getTraceId());
            oldTracerContext.put("sofaRpcId", sofaTracerSpanContext.getSpanId());
            oldTracerContext.put("sofaPenAttrs", sofaTracerSpanContext.getBizSerializedBaggage());
            oldTracerContext.put("sysPenAttrs", sofaTracerSpanContext.getSysSerializedBaggage());
            Map<String, Object> attachments = rpcInternalContext.getAttachments();
            oldTracerContext.put("sofaCallerApp", this.getEmptyStringIfNull(attachments, "remote.app"));
            oldTracerContext.put("sofaCallerZone", this.getEmptyStringIfNull(attachments, "remote.zone"));
            oldTracerContext.put("sofaCallerIdc", this.getEmptyStringIfNull(attachments, "remote.idc"));
            oldTracerContext.put("sofaCallerIp", this.getEmptyStringIfNull(attachments, "remote.ip"));
            request.addRequestProp("rpc_trace_context", oldTracerContext);
        }
        if (request.isAsync()) {
            clientSpan = sofaTraceContext.pop();
            if (clientSpan != null) {
                clientSpan.log("cs");
            }
            rpcInternalContext.setAttachment("_tracer_span", clientSpan);
            if (clientSpan != null && clientSpan.getParentSofaTracerSpan() != null) {
                sofaTraceContext.push(clientSpan.getParentSofaTracerSpan());
            }
        } else {
            clientSpan.log("cs");
        }
    }

    private String getEmptyStringIfNull(Map map, String key) {
        if (map == null || map.size() <= 0) {
            return "";
        }
        Object valueObject = map.get(key);
        String valueStr = null;
        try {
            valueStr = (String)valueObject;
        }
        catch (Throwable throwable) {
            return "";
        }
        return com.alipay.sofa.rpc.common.utils.StringUtils.isBlank(valueStr) ? "" : valueStr;
    }

    @Override
    public void clientReceived(SofaRequest request, SofaResponse response, Throwable exceptionThrow) {
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        SofaTracerSpan clientSpan = sofaTraceContext.pop();
        if (clientSpan == null) {
            return;
        }
        clientSpan.log("cr");
        RpcInternalContext context = null;
        if (RpcInternalContext.isAttachmentEnable()) {
            InetSocketAddress address;
            context = RpcInternalContext.getContext();
            if (!clientSpan.getTagsWithStr().containsKey("router.record")) {
                clientSpan.setTag("router.record", (String)context.getAttachment("_router_record"));
            }
            clientSpan.setTag("req.serialize.time", (Number)context.getAttachment("_req_ser_time"));
            clientSpan.setTag("resp.deserialize.time", (Number)context.getAttachment("_resp_des_time"));
            clientSpan.setTag("resp.size", (Number)context.getAttachment("_resp_size"));
            clientSpan.setTag("req.size", (Number)context.getAttachment("_req_size"));
            clientSpan.setTag("client.conn.time", (Number)context.getAttachment("_conn_create_time"));
            Long ce = (Long)context.getAttachment("_client_elapse");
            if (ce != null) {
                clientSpan.setTag("client.elapse.time", (Number)ce);
            }
            if ((address = context.getLocalAddress()) != null) {
                clientSpan.setTag("local.client.ip", NetUtils.toIpString(address));
                clientSpan.setTag("local.client.port", (Number)address.getPort());
            }
        }
        Throwable throwableShow = exceptionThrow;
        String resultCode = "";
        String errorSourceApp = "";
        String tracerErrorCode = "";
        if (throwableShow != null) {
            if (throwableShow instanceof SofaRpcException) {
                SofaRpcException exception = (SofaRpcException)throwableShow;
                int errorType = exception.getErrorType();
                switch (errorType) {
                    case 200: {
                        resultCode = "03";
                        errorSourceApp = (String)clientSpan.getTagsWithStr().get("local.app");
                        tracerErrorCode = "timeout_error";
                        break;
                    }
                    case 210: {
                        resultCode = "04";
                        errorSourceApp = (String)clientSpan.getTagsWithStr().get("local.app");
                        tracerErrorCode = "address_route_error";
                        break;
                    }
                    case 220: 
                    case 230: {
                        resultCode = "02";
                        errorSourceApp = (String)clientSpan.getTagsWithStr().get("local.app");
                        tracerErrorCode = "serialize_error";
                        break;
                    }
                    default: {
                        resultCode = "02";
                        errorSourceApp = ExceptionUtils.isServerException(exception) ? (String)clientSpan.getTagsWithStr().get("remote.app") : (String)clientSpan.getTagsWithStr().get("local.app");
                        tracerErrorCode = "unknown_error";
                        break;
                    }
                }
            } else {
                resultCode = "02";
                errorSourceApp = (String)clientSpan.getTagsWithStr().get("local.app");
                tracerErrorCode = "unknown_error";
            }
        } else if (response != null) {
            if (response.isError()) {
                errorSourceApp = (String)clientSpan.getTagsWithStr().get("remote.app");
                tracerErrorCode = "unknown_error";
                resultCode = "02";
                throwableShow = new SofaRpcException(199, response.getErrorMsg());
            } else {
                Object ret = response.getAppResponse();
                if (ret instanceof Throwable) {
                    throwableShow = (Throwable)ret;
                    errorSourceApp = (String)clientSpan.getTagsWithStr().get("remote.app");
                    resultCode = "01";
                    tracerErrorCode = "biz_error";
                } else {
                    resultCode = "00";
                }
            }
        }
        if (throwableShow != null) {
            HashMap<String, String> contextMap = new HashMap<String, String>();
            this.generateClientErrorContext(contextMap, request, clientSpan);
            clientSpan.reportError(tracerErrorCode, contextMap, throwableShow, errorSourceApp, new String[]{ERROR_SOURCE});
        }
        clientSpan.setTag("result.code", resultCode);
        clientSpan.finish();
        if (context != null) {
            context.setAttachment("_result_code", resultCode);
        }
        if (clientSpan.getParentSofaTracerSpan() != null) {
            sofaTraceContext.push(clientSpan.getParentSofaTracerSpan());
        }
    }

    private void generateClientErrorContext(Map<String, String> context, SofaRequest request, SofaTracerSpan clientSpan) {
        Map tagsWithStr = clientSpan.getTagsWithStr();
        context.put("serviceName", (String)tagsWithStr.get("service"));
        context.put("methodName", (String)tagsWithStr.get("method"));
        context.put("protocol", (String)tagsWithStr.get("protocol"));
        context.put("invokeType", (String)tagsWithStr.get("invoke.type"));
        context.put("targetUrl", (String)tagsWithStr.get("remote.ip"));
        context.put("targetApp", (String)tagsWithStr.get("remote.app"));
        context.put("targetZone", (String)tagsWithStr.get("remote.zone"));
        context.put("targetIdc", (String)tagsWithStr.get("remote.idc"));
        context.put("paramTypes", StringUtils.arrayToString((Object[])request.getMethodArgSigs(), (char)'|', (String)"", (String)""));
        context.put("targetCity", (String)tagsWithStr.get("remote.city"));
        context.put("uid", (String)tagsWithStr.get("user.id"));
    }

    @Override
    public void serverReceived(SofaRequest request) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(Tags.SPAN_KIND.getKey(), "server");
        String spanStrs = (String)request.getRequestProp("new_rpc_trace_context");
        SofaTracerSpanContext spanContext = null;
        if (com.alipay.sofa.rpc.common.utils.StringUtils.isBlank(spanStrs)) {
            Object oldInstanceMap = request.getRequestProp("rpc_trace_context");
            spanContext = this.saveSpanContextAndTags(tags, oldInstanceMap);
        } else {
            spanContext = SofaTracerSpanContext.deserializeFromString((String)spanStrs);
        }
        if (spanContext == null) {
            SelfLog.error((String)"SpanContext created error when server received and root SpanContext created.");
            spanContext = SofaTracerSpanContext.rootStart();
        }
        SofaTracerSpan serverSpan = new SofaTracerSpan(this.sofaTracer, System.currentTimeMillis(), request.getInterfaceName(), spanContext, tags);
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        serverSpan.log("sr");
        sofaTraceContext.push(serverSpan);
        if (RpcInternalContext.isAttachmentEnable()) {
            RpcInternalContext context = RpcInternalContext.getContext();
            context.setAttachment("_trace_id", spanContext.getTraceId());
            context.setAttachment("_span_id", spanContext.getSpanId());
        }
    }

    private SofaTracerSpanContext saveSpanContextAndTags(Map<String, String> tags, Object oldInstanceMap) {
        if (oldInstanceMap instanceof Map) {
            try {
                Map contextMap = (Map)oldInstanceMap;
                String traceId = this.getEmptyStringIfNull(contextMap, "sofaTraceId");
                String rpcId = this.getEmptyStringIfNull(contextMap, "sofaRpcId");
                String bizBaggage = this.getEmptyStringIfNull(contextMap, "sofaPenAttrs");
                String sysBaggage = this.getEmptyStringIfNull(contextMap, "sysPenAttrs");
                String callerApp = this.getEmptyStringIfNull(contextMap, "sofaCallerApp");
                String callerZone = this.getEmptyStringIfNull(contextMap, "sofaCallerZone");
                String callerIdc = this.getEmptyStringIfNull(contextMap, "sofaCallerIdc");
                String callerIp = this.getEmptyStringIfNull(contextMap, "sofaCallerIp");
                SofaTracerSpanContext spanContext = new SofaTracerSpanContext(traceId, rpcId);
                spanContext.deserializeBizBaggage(bizBaggage);
                spanContext.deserializeSysBaggage(sysBaggage);
                spanContext.setSampled("true".equalsIgnoreCase((String)spanContext.getSysBaggage().get("samp")));
                tags.put("remote.app", callerApp);
                tags.put("remote.zone", callerZone);
                tags.put("remote.idc", callerIdc);
                tags.put("remote.ip", callerIp);
                return spanContext;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return null;
    }

    @Override
    public void serverSend(SofaRequest request, SofaResponse response, Throwable exception) {
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        SofaTracerSpan serverSpan = sofaTraceContext.pop();
        if (serverSpan == null) {
            return;
        }
        serverSpan.log("ss");
        RpcInternalContext context = RpcInternalContext.getContext();
        serverSpan.setTag("resp.serialize.time", (Number)context.getAttachment("_resp_ser_time"));
        serverSpan.setTag("req.deserialize.time", (Number)context.getAttachment("_req_des_time"));
        serverSpan.setTag("resp.size", (Number)context.getAttachment("_resp_size"));
        serverSpan.setTag("req.size", (Number)context.getAttachment("_req_size"));
        serverSpan.setTag("current.thread.name", Thread.currentThread().getName());
        Throwable throwableShow = exception;
        String tracerErrorCode = "";
        String errorSourceApp = "";
        String resultCode = "";
        if (throwableShow != null) {
            errorSourceApp = (String)serverSpan.getTagsWithStr().get("local.app");
            resultCode = "02";
            tracerErrorCode = "unknown_error";
        } else if (response != null) {
            if (response.isError()) {
                errorSourceApp = (String)serverSpan.getTagsWithStr().get("local.app");
                resultCode = "02";
                tracerErrorCode = "unknown_error";
                throwableShow = new SofaRpcException(199, response.getErrorMsg());
            } else {
                Object ret = response.getAppResponse();
                if (ret instanceof Throwable) {
                    throwableShow = (Throwable)ret;
                    errorSourceApp = (String)serverSpan.getTagsWithStr().get("local.app");
                    resultCode = "01";
                    tracerErrorCode = "01";
                } else {
                    resultCode = "00";
                }
            }
        }
        if (throwableShow != null) {
            HashMap<String, String> errorContext = new HashMap<String, String>();
            this.generateServerErrorContext(errorContext, request, serverSpan);
            serverSpan.reportError(tracerErrorCode, errorContext, throwableShow, errorSourceApp, new String[]{ERROR_SOURCE});
        }
        serverSpan.setTag("result.code", resultCode);
        serverSpan.finish();
    }

    private void generateServerErrorContext(Map<String, String> context, SofaRequest request, SofaTracerSpan serverSpan) {
        Map tagsWithStr = serverSpan.getTagsWithStr();
        context.put("serviceName", (String)tagsWithStr.get("service"));
        context.put("methodName", (String)tagsWithStr.get("method"));
        context.put("protocol", (String)tagsWithStr.get("protocol"));
        context.put("invokeType", (String)tagsWithStr.get("invoke.type"));
        context.put("callerUrl", (String)tagsWithStr.get("remote.ip"));
        context.put("callerApp", (String)tagsWithStr.get("remote.app"));
        context.put("callerZone", (String)tagsWithStr.get("remote.zone"));
        context.put("callerIdc", (String)tagsWithStr.get("remote.idc"));
        if (request != null) {
            context.put("paramTypes", StringUtils.arrayToString((Object[])request.getMethodArgSigs(), (char)'|', (String)"", (String)""));
        }
    }

    @Override
    public void clientAsyncAfterSend(SofaRequest request) {
    }

    @Override
    public void clientAsyncReceivedPrepare() {
        RpcInternalContext rpcInternalContext = RpcInternalContext.getContext();
        SofaTracerSpan clientSpan = (SofaTracerSpan)rpcInternalContext.getAttachment("_tracer_span");
        if (clientSpan == null) {
            return;
        }
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        sofaTraceContext.push(clientSpan);
    }

    @Override
    public void checkState() {
        RpcInternalContext rpcInternalContext = RpcInternalContext.getContext();
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        if (rpcInternalContext.isConsumerSide()) {
            if (sofaTraceContext.getThreadLocalSpanSize() > 1) {
                SelfLog.error((String)"Pay attention,stack size error.Tracer consumer stack size more than one.");
                SelfLog.flush();
            }
        } else if (rpcInternalContext.isProviderSide() && sofaTraceContext.getThreadLocalSpanSize() > 0) {
            SelfLog.error((String)"Pay attention,stack size error.Tracer provider stack size more than zero.");
            SelfLog.flush();
        }
    }

    @Override
    public void profile(String profileApp, String code, String message) {
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        SofaTracerSpan sofaTracerSpan = sofaTraceContext.getCurrentSpan();
        if (sofaTracerSpan != null) {
            sofaTracerSpan.profile(profileApp, code, message);
        }
    }

    public SofaTracer getSofaTracer() {
        return this.sofaTracer;
    }
}

