/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.consul.model;

import com.alipay.sofa.rpc.registry.consul.model.AbstractBuilder;
import com.ecwid.consul.v1.agent.model.NewService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public final class ConsulService {
    private final String name;
    private final String id;
    private final String address;
    private final Integer port;
    private final Set<String> tags;
    private final String interval;

    private ConsulService(Builder builder) {
        this.name = builder.name;
        this.id = builder.id != null ? builder.id : this.name + ":" + UUID.randomUUID().toString();
        this.address = builder.address;
        this.port = builder.port;
        this.tags = Collections.unmodifiableSet(new HashSet(builder.tags));
        this.interval = builder.interval;
    }

    public NewService getNewService() {
        NewService consulService = new NewService();
        consulService.setName(this.name);
        consulService.setId(this.id);
        consulService.setAddress(this.address);
        consulService.setPort(this.port);
        consulService.setTags(Collections.unmodifiableList(new ArrayList<String>(this.tags)));
        NewService.Check check = new NewService.Check();
        check.setTtl(this.interval + "s");
        check.setDeregisterCriticalServiceAfter("3m");
        consulService.setCheck(check);
        return consulService;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getAddress() {
        return this.address;
    }

    public Integer getPort() {
        return this.port;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public String getInterval() {
        return this.interval;
    }

    public static Builder newService() {
        return new Builder();
    }

    public String toString() {
        return "Service{name=" + this.name + ", id=" + this.id + ", address=" + this.address + ", port=" + this.port + ", interval=" + this.interval + ", tags=" + this.tags + '}';
    }

    String toConsulRegistrationJson() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        this.append(builder, "ID", this.id);
        builder.append(",");
        this.append(builder, "Name", this.name);
        builder.append(",");
        if (!this.tags.isEmpty()) {
            builder.append("\"Tags\":[");
            StringBuilder sb = new StringBuilder(",");
            for (String tag : this.tags) {
                sb.append("\"").append(tag).append("\"");
            }
            builder.append(sb.toString());
            builder.append("],");
        }
        if (this.address != null) {
            this.append(builder, "Address", this.address);
            builder.append(",");
        }
        this.append(builder, "Port", this.port);
        builder.append(",");
        builder.append("\"Check\":{");
        this.append(builder, "Interval", this.interval);
        builder.append("}");
        builder.append("}");
        return builder.toString();
    }

    private void append(StringBuilder builder, String key, String value) {
        builder.append("\"");
        builder.append(key);
        builder.append("\":\"");
        builder.append(value);
        builder.append("\"");
    }

    private void append(StringBuilder builder, String key, Integer value) {
        builder.append("\"");
        builder.append(key);
        builder.append("\":");
        builder.append(value);
        builder.append("");
    }

    public static class Builder
    extends AbstractBuilder {
        private String name;
        private String id;
        private String address;
        private Integer port;
        private Set<String> tags = new HashSet<String>();
        private String interval;

        public Builder withName(String name) {
            this.name = this.substituteEnvironmentVariables(name);
            return this;
        }

        public Builder withId(String id) {
            this.id = this.substituteEnvironmentVariables(id);
            return this;
        }

        public Builder withAddress(String address) {
            this.address = this.substituteEnvironmentVariables(address);
            return this;
        }

        public Builder withPort(String port) {
            this.port = Integer.parseInt(this.substituteEnvironmentVariables(port));
            return this;
        }

        public Builder withCheckInterval(String interval) {
            String value;
            this.interval = value = this.substituteEnvironmentVariables(interval);
            return this;
        }

        public Builder withTag(String tag) {
            this.tags.add(this.substituteEnvironmentVariables(tag));
            return this;
        }

        public Builder withTags(List<String> tags) {
            for (String tag : tags) {
                this.tags.add(this.substituteEnvironmentVariables(tag));
            }
            return this;
        }

        public ConsulService build() {
            if (this.name == null) {
                throw new IllegalArgumentException("Required service name is missing");
            }
            if (this.port == null) {
                throw new IllegalArgumentException("Required port is missing for service " + this.name);
            }
            return new ConsulService(this);
        }
    }
}

