/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.consul;

import com.alipay.sofa.rpc.base.Destroyable;
import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.struct.NamedThreadFactory;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.context.RpcRunningState;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.event.ConsumerSubEvent;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.event.ProviderPubEvent;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.rpc.registry.consul.ConsulRegistryHelper;
import com.alipay.sofa.rpc.registry.consul.common.ConsulConstants;
import com.alipay.sofa.rpc.registry.consul.common.ConsulURL;
import com.alipay.sofa.rpc.registry.consul.common.ConsulURLUtils;
import com.alipay.sofa.rpc.registry.consul.internal.ConsulManager;
import com.alipay.sofa.rpc.registry.consul.model.ConsulEphemeralNode;
import com.alipay.sofa.rpc.registry.consul.model.ConsulService;
import com.alipay.sofa.rpc.registry.consul.model.ConsulServiceResp;
import com.alipay.sofa.rpc.registry.consul.model.NotifyConsumerListener;
import com.alipay.sofa.rpc.registry.consul.model.NotifyListener;
import com.alipay.sofa.rpc.registry.consul.model.ThrallRoleType;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@Extension(value="consul")
public class ConsulRegistry
extends Registry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulRegistry.class);
    private ConsulManager consulManager;
    private String rootPath;
    private ConcurrentMap<ProviderConfig, List<String>> providerUrls = new ConcurrentHashMap<ProviderConfig, List<String>>();
    private ConcurrentMap<ConsumerConfig, String> consumerUrls = new ConcurrentHashMap<ConsumerConfig, String>();
    private Cache<String, Map<String, List<ConsulURL>>> serviceCache;
    private final ConcurrentMap<String, Long> lookupGroupServices = Maps.newConcurrentMap();
    private final ConcurrentMap<String, Pair<ConsulURL, Set<NotifyListener>>> notifyServiceListeners = Maps.newConcurrentMap();
    private final Set<String> serviceGroupLookUped = Sets.newConcurrentHashSet();
    private ExecutorService notifyExecutor;

    protected ConsulRegistry(RegistryConfig registryConfig) {
        super(registryConfig);
    }

    public String[] validateIp(RegistryConfig registryConfig) {
        String address;
        String addressInput = registryConfig.getAddress();
        if (StringUtils.isEmpty(addressInput)) {
            throw new SofaRpcRuntimeException("Address of consul registry is empty.");
        }
        int idx = addressInput.indexOf("/");
        if (idx > 0) {
            address = addressInput.substring(0, idx);
            this.rootPath = addressInput.substring(idx);
        } else {
            address = addressInput;
            this.rootPath = "/";
        }
        if (!ConsulURLUtils.isValidAddress(address)) {
            throw new SofaRpcRuntimeException("Address format of consul registry is wrong.");
        }
        if (!this.rootPath.endsWith("/")) {
            this.rootPath = this.rootPath + "/";
        }
        String[] ipAndHost = StringUtils.split(address, ":");
        return ipAndHost;
    }

    private ConsulService buildConsulHealthService(ConsulURL url) {
        return ConsulService.newService().withAddress(url.getHost()).withPort(Integer.toString(url.getPort())).withName(ConsulURLUtils.toServiceName(url.getGroup())).withTag(ConsulURLUtils.healthServicePath(url, ThrallRoleType.PROVIDER)).withId(url.getHost() + ":" + url.getPort() + "-" + url.getPath() + "-" + url.getVersion()).withCheckInterval(Integer.toString(ConsulConstants.TTL)).build();
    }

    private ConsulEphemeralNode buildEphemralNode(ConsulURL url, ThrallRoleType roleType) {
        return ConsulEphemeralNode.newEphemralNode().withUrl(url).withEphemralType(roleType).withCheckInterval(Integer.toString(ConsulConstants.TTL * 6)).build();
    }

    @Override
    public void init() {
        if (this.consulManager != null) {
            return;
        }
        String[] address = this.validateIp(this.registryConfig);
        this.consulManager = new ConsulManager(address[0], Integer.parseInt(address[1]));
        this.serviceCache = CacheBuilder.newBuilder().maximumSize(1000L).build();
        this.notifyExecutor = Executors.newCachedThreadPool(new NamedThreadFactory("NotifyConsumerListener", true));
    }

    @Override
    public void destroy() {
        this.providerUrls.clear();
        this.consumerUrls.clear();
    }

    @Override
    public void destroy(Destroyable.DestroyHook hook) {
        hook.postDestroy();
        this.destroy();
        hook.postDestroy();
    }

    @Override
    public boolean start() {
        return true;
    }

    @Override
    public void register(ProviderConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isRegister()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("00208"));
            }
            return;
        }
        if (config.isRegister()) {
            try {
                List<String> urls = ConsulRegistryHelper.convertProviderToUrls(config);
                if (CommonUtils.isNotEmpty(urls)) {
                    String providerPath = ConsulRegistryHelper.buildProviderPath(this.rootPath, config);
                    if (LOGGER.isInfoEnabled(appName)) {
                        LOGGER.infoWithApp(appName, LogCodes.getLog("00205", providerPath));
                    }
                    for (String url : urls) {
                        String providerUrl = providerPath + "/" + url;
                        ConsulURL providerConfigUrl = ConsulURL.valueOf(url);
                        ConsulService service = this.buildConsulHealthService(providerConfigUrl);
                        this.consulManager.registerService(service);
                        ConsulEphemeralNode ephemralNode = this.buildEphemralNode(providerConfigUrl, ThrallRoleType.PROVIDER);
                        this.consulManager.registerEphemralNode(ephemralNode);
                        if (!LOGGER.isInfoEnabled(appName)) continue;
                        LOGGER.infoWithApp(appName, LogCodes.getLog("00201", providerUrl));
                    }
                    this.providerUrls.put(config, urls);
                    if (LOGGER.isInfoEnabled(appName)) {
                        LOGGER.infoWithApp(appName, LogCodes.getLog("00206", providerPath));
                    }
                }
            }
            catch (Exception e) {
                throw new SofaRpcRuntimeException("Failed to register provider to consulRegistry!", e);
            }
            if (EventBus.isEnable(ProviderPubEvent.class)) {
                ProviderPubEvent event = new ProviderPubEvent(config);
                EventBus.post(event);
            }
        }
    }

    @Override
    public void unRegister(ProviderConfig config) {
        block8: {
            String appName = config.getAppName();
            if (!this.registryConfig.isRegister()) {
                if (LOGGER.isInfoEnabled(appName)) {
                    LOGGER.infoWithApp(appName, LogCodes.getLog("00208"));
                }
                return;
            }
            if (config.isRegister()) {
                try {
                    List urls = (List)this.providerUrls.remove(config);
                    if (CommonUtils.isNotEmpty(urls)) {
                        String providerPath = ConsulRegistryHelper.buildProviderPath(this.rootPath, config);
                        for (String url : urls) {
                            ConsulURL providerConfigUrl = ConsulURL.valueOf(url);
                            ConsulService service = this.buildConsulHealthService(providerConfigUrl);
                            this.consulManager.unregisterService(service);
                        }
                        if (LOGGER.isInfoEnabled(appName)) {
                            LOGGER.infoWithApp(appName, LogCodes.getLog("00203", providerPath, "1"));
                        }
                    }
                }
                catch (Exception e) {
                    if (RpcRunningState.isShuttingDown()) break block8;
                    throw new SofaRpcRuntimeException("Failed to unregister provider to consulRegistry!", e);
                }
            }
        }
    }

    @Override
    public void batchUnRegister(List<ProviderConfig> configs) {
        for (ProviderConfig providerConfig : configs) {
            this.unRegister(providerConfig);
        }
    }

    @Override
    public List<ProviderGroup> subscribe(ConsumerConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isSubscribe()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("00208"));
            }
            return null;
        }
        if (config.isRegister()) {
            try {
                String url = ConsulRegistryHelper.convertConsumerToUrl(config);
                ConsulURL consulURL = ConsulURL.valueOf(url);
                Iterator it = this.serviceCache.asMap().entrySet().iterator();
                HashSet<ProviderInfo> result = new HashSet<ProviderInfo>();
                ArrayList<ConsulURL> matchConsulUrls = new ArrayList<ConsulURL>();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Collection consulURLList = ((Map)entry.getValue()).values();
                    ArrayList<ProviderInfo> matchProviders = new ArrayList<ProviderInfo>();
                    for (List next : consulURLList) {
                        matchConsulUrls.addAll(next);
                        matchProviders.addAll(ConsulRegistryHelper.convertUrl2ProviderInfos(next));
                    }
                    result.addAll(ConsulRegistryHelper.matchProviderInfos(config, matchProviders));
                }
                NotifyConsumerListener listener = new NotifyConsumerListener(consulURL, matchConsulUrls);
                this.consumerUrls.put(config, url);
                Pair listenersPair = (Pair)this.notifyServiceListeners.get(consulURL.getServiceKey());
                if (listenersPair == null) {
                    Set listeners = Sets.newConcurrentHashSet();
                    listeners.add(listener);
                    listenersPair = new ImmutablePair((Object)consulURL, (Object)listeners);
                } else {
                    ((Set)listenersPair.getValue()).add(listener);
                }
                if (this.notifyServiceListeners.get(consulURL.getServiceKey()) == null) {
                    this.notifyServiceListeners.put(consulURL.getServiceKey(), (Pair<ConsulURL, Set<NotifyListener>>)listenersPair);
                }
                if (!this.serviceGroupLookUped.contains(consulURL.getGroup())) {
                    this.serviceGroupLookUped.add(consulURL.getGroup());
                    ServiceLookUper serviceLookUper = new ServiceLookUper(consulURL.getGroup());
                    serviceLookUper.setDaemon(true);
                    serviceLookUper.start();
                    ConsulEphemeralNode ephemralNode = this.buildEphemralNode(consulURL, ThrallRoleType.CONSUMER);
                    this.consulManager.registerEphemralNode(ephemralNode);
                } else {
                    this.notifyListener(consulURL, listener);
                }
                if (EventBus.isEnable(ConsumerSubEvent.class)) {
                    ConsumerSubEvent event = new ConsumerSubEvent(config);
                    EventBus.post(event);
                }
                return Collections.singletonList(new ProviderGroup().addAll(result));
            }
            catch (Exception e) {
                throw new SofaRpcRuntimeException("Failed to register consumer to consulRegistry!", e);
            }
        }
        return null;
    }

    @Override
    public void unSubscribe(ConsumerConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isSubscribe() && LOGGER.isInfoEnabled(appName)) {
            LOGGER.infoWithApp(appName, LogCodes.getLog("00208"));
        }
        if (config.isRegister()) {
            String url = ConsulRegistryHelper.convertConsumerToUrl(config);
            ConsulURL consulURL = ConsulURL.valueOf(url);
            this.consumerUrls.remove(config);
            this.notifyServiceListeners.remove(consulURL.getServiceKey());
        }
    }

    @Override
    public void batchUnSubscribe(List<ConsumerConfig> configs) {
        for (ConsumerConfig consumerConfig : configs) {
            this.unSubscribe(consumerConfig);
        }
    }

    private void notifyListener(ConsulURL url, NotifyListener listener) {
        Map groupCacheUrls = (Map)this.serviceCache.getIfPresent((Object)url.getGroup());
        if (groupCacheUrls != null) {
            for (Map.Entry entry : groupCacheUrls.entrySet()) {
                String cacheServiceKey = (String)entry.getKey();
                if (!url.getServiceKey().equals(cacheServiceKey)) continue;
                List newUrls = (List)entry.getValue();
                this.notify(url, listener, newUrls);
            }
        }
    }

    protected void notify(final ConsulURL url, final NotifyListener listener, final List<ConsulURL> urls) {
        if (url == null) {
            throw new IllegalArgumentException("notify url == null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("notify listener == null");
        }
        try {
            this.notifyExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    listener.notify(url, urls);
                }
            });
        }
        catch (Exception t) {
            LOGGER.error("Failed to notify for subscribe " + url + ", waiting for retry, cause: " + t.getMessage(), t);
        }
    }

    private Map<String, List<ConsulURL>> lookupServiceUpdate(String group) {
        Long lastConsulIndexId = this.lookupGroupServices.get(group) == null ? Long.valueOf(0L) : (Long)this.lookupGroupServices.get(group);
        String serviceName = ConsulURLUtils.toServiceName(group);
        ConsulServiceResp consulResp = this.consulManager.lookupHealthService(serviceName, lastConsulIndexId);
        if (consulResp != null) {
            boolean updated;
            List<ConsulService> consulServcies = consulResp.getConsulServices();
            boolean bl = updated = consulServcies != null && !consulServcies.isEmpty() && consulResp.getConsulIndex() > lastConsulIndexId;
            if (updated) {
                ConcurrentMap groupProviderUrls = Maps.newConcurrentMap();
                for (ConsulService service : consulServcies) {
                    ConsulURL providerUrl = this.buildURL(service);
                    String serviceKey = providerUrl.getServiceKey();
                    List urlList = (List)groupProviderUrls.get(serviceKey);
                    if (urlList == null) {
                        urlList = Lists.newArrayList();
                        groupProviderUrls.put(serviceKey, urlList);
                    }
                    urlList.add(providerUrl);
                }
                this.lookupGroupServices.put(group, consulResp.getConsulIndex());
                return groupProviderUrls;
            }
        }
        return null;
    }

    private ConsulURL buildURL(ConsulService service) {
        try {
            for (String tag : service.getTags()) {
                if (org.apache.commons.lang3.StringUtils.indexOf((CharSequence)tag, (CharSequence)"providers") == -1) continue;
                String toUrlPath = org.apache.commons.lang3.StringUtils.substringAfter((String)tag, (String)"providers");
                ConsulURL consulUrl = ConsulURL.valueOf(ConsulURL.decode(toUrlPath));
                return consulUrl;
            }
        }
        catch (Exception e) {
            LOGGER.error("convert consul service to url fail! service:" + service, e);
        }
        return null;
    }

    private class ServiceLookUper
    extends Thread {
        private final String group;

        public ServiceLookUper(String group) {
            this.group = group;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Map groupNewUrls;
                        if ((groupNewUrls = ConsulRegistry.this.lookupServiceUpdate(this.group)) != null && !groupNewUrls.isEmpty()) {
                            Map groupCacheUrls = (Map)ConsulRegistry.this.serviceCache.getIfPresent((Object)this.group);
                            if (groupCacheUrls == null) {
                                groupCacheUrls = Maps.newConcurrentMap();
                                ConsulRegistry.this.serviceCache.put((Object)this.group, (Object)groupCacheUrls);
                            }
                            for (Map.Entry entry : groupNewUrls.entrySet()) {
                                List oldUrls = (List)groupCacheUrls.get(entry.getKey());
                                List newUrls = (List)entry.getValue();
                                boolean isSame = CommonUtils.listEquals(newUrls, oldUrls);
                                if (isSame) continue;
                                groupCacheUrls.put(entry.getKey(), newUrls);
                                Pair listenerPair = (Pair)ConsulRegistry.this.notifyServiceListeners.get(entry.getKey());
                                if (listenerPair == null) continue;
                                ConsulURL subscribeUrl = (ConsulURL)listenerPair.getKey();
                                Set listeners = (Set)listenerPair.getValue();
                                for (NotifyListener listener : listeners) {
                                    ConsulRegistry.this.notify(subscribeUrl, listener, newUrls);
                                }
                            }
                        }
                        ServiceLookUper.sleep(ConsulConstants.DEFAULT_LOOKUP_INTERVAL);
                    }
                }
                catch (Throwable e) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    continue;
                }
                break;
            }
        }
    }
}

