/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.bootstrap.dubbo;

import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.ServiceConfig;
import com.alipay.sofa.rpc.bootstrap.ProviderBootstrap;
import com.alipay.sofa.rpc.bootstrap.dubbo.DubboConvertor;
import com.alipay.sofa.rpc.bootstrap.dubbo.DubboSingleton;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.ApplicationConfig;
import com.alipay.sofa.rpc.config.MethodConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.ext.Extension;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Extension(value="dubbo")
public class DubboProviderBootstrap<T>
extends ProviderBootstrap<T> {
    protected volatile transient boolean exported;
    private ServiceConfig<T> serviceConfig;

    protected DubboProviderBootstrap(ProviderConfig<T> providerConfig) {
        super(providerConfig);
    }

    @Override
    public void export() {
        if (this.exported) {
            return;
        }
        this.serviceConfig = new ServiceConfig();
        this.covert(this.providerConfig, this.serviceConfig);
        this.serviceConfig.export();
        this.exported = true;
    }

    private void covert(ProviderConfig<T> providerConfig, ServiceConfig<T> serviceConfig) {
        this.copyApplication(providerConfig, serviceConfig);
        DubboConvertor.copyRegistries(providerConfig, serviceConfig);
        this.copyServers(providerConfig, serviceConfig);
        this.copyProvider(providerConfig, serviceConfig);
        this.copyMethods(providerConfig, serviceConfig);
    }

    private void copyApplication(ProviderConfig<T> providerConfig, ServiceConfig<T> serviceConfig) {
        ApplicationConfig applicationConfig = providerConfig.getApplication();
        com.alibaba.dubbo.config.ApplicationConfig dubboConfig = new com.alibaba.dubbo.config.ApplicationConfig();
        dubboConfig.setName(applicationConfig.getAppName());
        serviceConfig.setApplication(dubboConfig);
    }

    private void copyServers(ProviderConfig<T> providerConfig, ServiceConfig serviceConfig) {
        List<ServerConfig> serverConfigs = providerConfig.getServer();
        if (CommonUtils.isNotEmpty(serverConfigs)) {
            ArrayList<ProtocolConfig> dubboProtocolConfigs = new ArrayList<ProtocolConfig>();
            for (ServerConfig serverConfig : serverConfigs) {
                ProtocolConfig protocolConfig = (ProtocolConfig)DubboSingleton.SERVER_MAP.get(serverConfig);
                if (protocolConfig == null) {
                    protocolConfig = new ProtocolConfig();
                    this.copyServerFields(serverConfig, protocolConfig);
                    ProtocolConfig old = DubboSingleton.SERVER_MAP.putIfAbsent(serverConfig, protocolConfig);
                    if (old != null) {
                        protocolConfig = old;
                    }
                }
                dubboProtocolConfigs.add(protocolConfig);
            }
            serviceConfig.setProtocols(dubboProtocolConfigs);
        }
    }

    private void copyServerFields(ServerConfig serverConfig, ProtocolConfig protocolConfig) {
        protocolConfig.setId(serverConfig.getId());
        protocolConfig.setName(serverConfig.getProtocol());
        protocolConfig.setHost(serverConfig.getHost());
        protocolConfig.setPort(Integer.valueOf(serverConfig.getPort()));
        protocolConfig.setAccepts(Integer.valueOf(serverConfig.getAccepts()));
        protocolConfig.setSerialization(serverConfig.getSerialization());
        if (!"/".equals(serverConfig.getContextPath())) {
            protocolConfig.setContextpath(serverConfig.getContextPath());
        }
        protocolConfig.setIothreads(Integer.valueOf(serverConfig.getIoThreads()));
        protocolConfig.setThreadpool(serverConfig.getThreadPoolType());
        protocolConfig.setThreads(Integer.valueOf(serverConfig.getMaxThreads()));
        protocolConfig.setPayload(Integer.valueOf(serverConfig.getPayload()));
        protocolConfig.setQueues(Integer.valueOf(serverConfig.getQueues()));
        protocolConfig.setParameters(serverConfig.getParameters());
    }

    private void copyProvider(ProviderConfig<T> providerConfig, ServiceConfig<T> serviceConfig) {
        serviceConfig.setId(providerConfig.getId());
        serviceConfig.setInterface(providerConfig.getInterfaceId());
        serviceConfig.setRef(providerConfig.getRef());
        serviceConfig.setGroup(providerConfig.getUniqueId());
        serviceConfig.setVersion("1.0");
        serviceConfig.setActives(Integer.valueOf(providerConfig.getConcurrents()));
        serviceConfig.setDelay(Integer.valueOf(providerConfig.getDelay()));
        serviceConfig.setDynamic(Boolean.valueOf(providerConfig.isDynamic()));
        serviceConfig.setRegister(Boolean.valueOf(providerConfig.isRegister()));
        serviceConfig.setProxy(providerConfig.getProxy());
        serviceConfig.setWeight(Integer.valueOf(providerConfig.getWeight()));
        if (providerConfig.getTimeout() > 0) {
            serviceConfig.setTimeout(Integer.valueOf(providerConfig.getTimeout()));
        }
        serviceConfig.setParameters(providerConfig.getParameters());
    }

    private void copyMethods(ProviderConfig<T> providerConfig, ServiceConfig<T> serviceConfig) {
        Map<String, MethodConfig> methodConfigs = providerConfig.getMethods();
        if (CommonUtils.isNotEmpty(methodConfigs)) {
            ArrayList<com.alibaba.dubbo.config.MethodConfig> dubboMethodConfigs = new ArrayList<com.alibaba.dubbo.config.MethodConfig>();
            for (Map.Entry<String, MethodConfig> entry : methodConfigs.entrySet()) {
                MethodConfig methodConfig = entry.getValue();
                com.alibaba.dubbo.config.MethodConfig dubboMethodConfig = new com.alibaba.dubbo.config.MethodConfig();
                dubboMethodConfig.setName(methodConfig.getName());
                dubboMethodConfig.setParameters(methodConfig.getParameters());
                dubboMethodConfigs.add(dubboMethodConfig);
            }
            serviceConfig.setMethods(dubboMethodConfigs);
        }
    }

    @Override
    public synchronized void unExport() {
        if (!this.exported) {
            return;
        }
        this.serviceConfig.unexport();
        this.exported = false;
    }

    public List<String> buildUrls() {
        List<ServerConfig> servers;
        if (this.exported && (servers = this.providerConfig.getServer()) != null && !servers.isEmpty()) {
            ArrayList<String> urls = new ArrayList<String>();
            for (ServerConfig server : servers) {
                StringBuilder sb = new StringBuilder(200);
                sb.append(server.getProtocol()).append("://").append(server.getHost()).append(":").append(server.getPort()).append(server.getContextPath()).append(this.providerConfig.getInterfaceId()).append("?uniqueId=").append(this.providerConfig.getUniqueId()).append(this.getKeyPairs("version", "1.0")).append(this.getKeyPairs("delay", this.providerConfig.getDelay())).append(this.getKeyPairs("weight", this.providerConfig.getWeight())).append(this.getKeyPairs("register", this.providerConfig.isRegister())).append(this.getKeyPairs("maxThreads", server.getMaxThreads())).append(this.getKeyPairs("ioThreads", server.getIoThreads())).append(this.getKeyPairs("threadPoolType", server.getThreadPoolType())).append(this.getKeyPairs("accepts", server.getAccepts())).append(this.getKeyPairs("dynamic", this.providerConfig.isDynamic())).append(this.getKeyPairs("rpcVer", 50500));
                urls.add(sb.toString());
            }
            return urls;
        }
        return null;
    }

    private String getKeyPairs(String key, Object value) {
        if (value != null) {
            return "&" + key + "=" + value.toString();
        }
        return "";
    }
}

