/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring.health;

import com.alipay.sofa.runtime.spi.component.ComponentInfo;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.health.HealthResult;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

public abstract class AbstractComponentHealthChecker {
    private SofaRuntimeContext sofaRuntimeContext;

    public AbstractComponentHealthChecker(SofaRuntimeContext sofaRuntimeContext) {
        this.sofaRuntimeContext = sofaRuntimeContext;
    }

    public Health doHealthCheck() {
        boolean allPassed = true;
        Health.Builder builder = new Health.Builder();
        for (ComponentInfo componentInfo : this.sofaRuntimeContext.getComponentManager().getComponents()) {
            HealthResult healthy = componentInfo.isHealthy();
            if (healthy.isHealthy()) {
                builder.withDetail(healthy.getHealthName(), (Object)"passed");
                continue;
            }
            builder.withDetail(healthy.getHealthName(), (Object)healthy.getHealthReport());
            allPassed = false;
        }
        if (allPassed) {
            return builder.status(Status.UP).build();
        }
        return builder.status(Status.DOWN).build();
    }
}

