/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring.configuration;

import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.healthcheck.core.HealthChecker;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spring.AsyncProxyBeanPostProcessor;
import com.alipay.sofa.runtime.spring.async.AsyncTaskExecutionListener;
import com.alipay.sofa.runtime.spring.callback.CloseApplicationContextCallBack;
import com.alipay.sofa.runtime.spring.config.SofaRuntimeConfigurationProperties;
import com.alipay.sofa.runtime.spring.health.DefaultRuntimeHealthChecker;
import com.alipay.sofa.runtime.spring.health.MultiApplicationHealthIndicator;
import com.alipay.sofa.runtime.spring.health.SofaComponentHealthChecker;
import com.alipay.sofa.runtime.spring.health.SofaComponentHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SofaRuntimeConfigurationProperties.class})
public class SofaRuntimeAutoConfiguration {
    @Bean
    public CloseApplicationContextCallBack closeApplicationContextCallBack() {
        return new CloseApplicationContextCallBack();
    }

    @Bean
    public AsyncProxyBeanPostProcessor asyncProxyBeanPostProcessor() {
        return new AsyncProxyBeanPostProcessor();
    }

    @Bean
    public AsyncTaskExecutionListener asyncTaskExecutionListener() {
        return new AsyncTaskExecutionListener();
    }

    @Configuration
    @ConditionalOnClass(value={HealthChecker.class})
    @AutoConfigureAfter(value={SofaRuntimeAutoConfiguration.class})
    public static class SofaModuleHealthCheckerConfiguration {
        @Bean
        public SofaComponentHealthChecker sofaComponentHealthChecker(SofaRuntimeContext sofaRuntimeContext) {
            return new SofaComponentHealthChecker(sofaRuntimeContext);
        }
    }

    @Configuration
    @ConditionalOnClass(value={HealthIndicator.class})
    @ConditionalOnMissingClass(value={"com.alipay.sofa.healthcheck.core.HealthChecker"})
    @AutoConfigureAfter(value={SofaRuntimeAutoConfiguration.class})
    public static class SofaRuntimeHealthIndicatorConfiguration {
        @Bean
        public SofaComponentHealthIndicator sofaComponentHealthIndicator(SofaRuntimeContext sofaRuntimeContext) {
            return new SofaComponentHealthIndicator(sofaRuntimeContext);
        }
    }

    @Configuration
    @ConditionalOnClass(value={HealthChecker.class, Biz.class})
    public static class MultiApplicationHealthIndicatorConfiguration {
        @Bean
        public MultiApplicationHealthIndicator multiApplicationHealthIndicator() {
            return new MultiApplicationHealthIndicator();
        }
    }

    @Configuration
    @ConditionalOnClass(value={HealthChecker.class})
    @AutoConfigureAfter(value={SofaRuntimeAutoConfiguration.class})
    public static class DefaultRuntimeHealthCheckerConfiguration {
        @Bean
        public DefaultRuntimeHealthChecker defaultRuntimeHealthChecker(SofaRuntimeContext sofaRuntimeContext) {
            return new DefaultRuntimeHealthChecker(sofaRuntimeContext);
        }
    }
}

