/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.xmap;

import java.util.Collection;
import java.util.Iterator;

public final class PrimitiveArrays {
    private PrimitiveArrays() {
    }

    public static Object toPrimitiveArray(Collection<Object> col, Class primitiveArrayType) {
        if (primitiveArrayType == Integer.TYPE) {
            return PrimitiveArrays.toIntArray(col);
        }
        if (primitiveArrayType == Long.TYPE) {
            return PrimitiveArrays.toLongArray(col);
        }
        if (primitiveArrayType == Double.TYPE) {
            return PrimitiveArrays.toDoubleArray(col);
        }
        if (primitiveArrayType == Float.TYPE) {
            return PrimitiveArrays.toFloatArray(col);
        }
        if (primitiveArrayType == Boolean.TYPE) {
            return PrimitiveArrays.toBooleanArray(col);
        }
        if (primitiveArrayType == Byte.TYPE) {
            return PrimitiveArrays.toByteArray(col);
        }
        if (primitiveArrayType == Character.TYPE) {
            return PrimitiveArrays.toCharArray(col);
        }
        if (primitiveArrayType == Short.TYPE) {
            return PrimitiveArrays.toShortArray(col);
        }
        return null;
    }

    public static int[] toIntArray(Collection col) {
        int size = col.size();
        int[] ar = new int[size];
        Iterator it = col.iterator();
        int i = 0;
        while (it.hasNext()) {
            ar[i++] = (Integer)it.next();
        }
        return ar;
    }

    public static long[] toLongArray(Collection col) {
        int size = col.size();
        long[] ar = new long[size];
        Iterator it = col.iterator();
        int i = 0;
        while (it.hasNext()) {
            ar[i++] = (Long)it.next();
        }
        return ar;
    }

    public static double[] toDoubleArray(Collection col) {
        int size = col.size();
        double[] ar = new double[size];
        Iterator it = col.iterator();
        int i = 0;
        while (it.hasNext()) {
            ar[i++] = (Double)it.next();
        }
        return ar;
    }

    public static float[] toFloatArray(Collection col) {
        int size = col.size();
        float[] ar = new float[size];
        Iterator it = col.iterator();
        int i = 0;
        while (it.hasNext()) {
            ar[i++] = ((Float)it.next()).floatValue();
        }
        return ar;
    }

    public static boolean[] toBooleanArray(Collection col) {
        int size = col.size();
        boolean[] ar = new boolean[size];
        Iterator it = col.iterator();
        int i = 0;
        while (it.hasNext()) {
            ar[i++] = (Boolean)it.next();
        }
        return ar;
    }

    public static short[] toShortArray(Collection col) {
        int size = col.size();
        short[] ar = new short[size];
        Iterator it = col.iterator();
        int i = 0;
        while (it.hasNext()) {
            ar[i++] = (Short)it.next();
        }
        return ar;
    }

    public static byte[] toByteArray(Collection col) {
        int size = col.size();
        byte[] ar = new byte[size];
        Iterator it = col.iterator();
        int i = 0;
        while (it.hasNext()) {
            ar[i++] = (Byte)it.next();
        }
        return ar;
    }

    public static char[] toCharArray(Collection col) {
        int size = col.size();
        char[] ar = new char[size];
        Iterator it = col.iterator();
        int i = 0;
        while (it.hasNext()) {
            ar[i++] = ((Character)it.next()).charValue();
        }
        return ar;
    }
}

