/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.scheduler.task;

import com.alipay.sofa.registry.common.model.dataserver.SessionServerRegisterRequest;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.remoting.Server;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.node.SessionProcessIdGenerator;
import com.alipay.sofa.registry.server.session.node.service.DataNodeService;
import com.alipay.sofa.registry.server.session.scheduler.task.AbstractSessionTask;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashSet;

public class SessionRegisterDataTask
extends AbstractSessionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionRegisterDataTask.class, (String)"[Task]");
    private final Exchange boltExchange;
    private final DataNodeService dataNodeService;
    private final SessionServerConfig sessionServerConfig;
    private SessionServerRegisterRequest sessionServerRegisterRequest;
    private URL dataUrl;

    public SessionRegisterDataTask(Exchange boltExchange, DataNodeService dataNodeService, SessionServerConfig sessionServerConfig) {
        this.boltExchange = boltExchange;
        this.dataNodeService = dataNodeService;
        this.sessionServerConfig = sessionServerConfig;
    }

    public boolean checkRetryTimes() {
        return this.checkRetryTimes(this.sessionServerConfig.getSessionRegisterDataServerTaskRetryTimes());
    }

    public void setTaskEvent(TaskEvent taskEvent) {
        Object obj = taskEvent.getEventObj();
        if (!(obj instanceof URL)) {
            throw new IllegalArgumentException("Input task event object error!");
        }
        this.dataUrl = (URL)obj;
        Server sessionServer = this.boltExchange.getServer(Integer.valueOf(this.sessionServerConfig.getServerPort()));
        if (sessionServer != null) {
            Collection chs = sessionServer.getChannels();
            HashSet clientHosts = new HashSet();
            chs.forEach(channel -> clientHosts.add(NetUtil.toAddressString((InetSocketAddress)channel.getRemoteAddress())));
            this.sessionServerRegisterRequest = new SessionServerRegisterRequest(SessionProcessIdGenerator.getSessionProcessId(), clientHosts);
        } else {
            LOGGER.error("get null session server,please check server started before register!port {}", (Object)this.sessionServerConfig.getServerPort());
            this.sessionServerRegisterRequest = new SessionServerRegisterRequest(SessionProcessIdGenerator.getSessionProcessId(), new HashSet());
        }
    }

    public void execute() {
        this.dataNodeService.registerSessionProcessId(this.sessionServerRegisterRequest, this.dataUrl);
    }

    public String toString() {
        return "SESSION_REGISTER_DATA_TASK{taskId='" + this.taskId + '\'' + ", sessionServerRegisterRequest=" + this.sessionServerRegisterRequest.getProcessId() + ", clientList=" + this.sessionServerRegisterRequest.getClientHosts().size() + ", dataUrl=" + this.dataUrl + '}';
    }
}

