/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.scheduler.task;

import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.common.model.sessionserver.DataChangeRequest;
import com.alipay.sofa.registry.common.model.store.BaseInfo;
import com.alipay.sofa.registry.common.model.store.Subscriber;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.core.model.ReceivedData;
import com.alipay.sofa.registry.core.model.ScopeEnum;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.cache.CacheService;
import com.alipay.sofa.registry.server.session.cache.DatumKey;
import com.alipay.sofa.registry.server.session.cache.Key;
import com.alipay.sofa.registry.server.session.cache.Value;
import com.alipay.sofa.registry.server.session.converter.ReceivedDataConverter;
import com.alipay.sofa.registry.server.session.scheduler.ExecutorManager;
import com.alipay.sofa.registry.server.session.scheduler.task.AbstractSessionTask;
import com.alipay.sofa.registry.server.session.scheduler.task.PushTaskClosure;
import com.alipay.sofa.registry.server.session.store.Interests;
import com.alipay.sofa.registry.server.session.store.ReSubscribers;
import com.alipay.sofa.registry.task.TaskClosure;
import com.alipay.sofa.registry.task.batcher.TaskProcessor;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class DataChangeFetchTask
extends AbstractSessionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataChangeFetchTask.class);
    private static final Logger taskLogger = LoggerFactory.getLogger(DataChangeFetchTask.class, (String)"[Task]");
    private final SessionServerConfig sessionServerConfig;
    private final TaskListenerManager taskListenerManager;
    private final ExecutorManager executorManager;
    private DataChangeRequest dataChangeRequest;
    private final Interests sessionInterests;
    private final CacheService sessionCacheService;

    public DataChangeFetchTask(SessionServerConfig sessionServerConfig, TaskListenerManager taskListenerManager, ExecutorManager executorManager, Interests sessionInterests, CacheService sessionCacheService) {
        this.sessionServerConfig = sessionServerConfig;
        this.taskListenerManager = taskListenerManager;
        this.executorManager = executorManager;
        this.sessionInterests = sessionInterests;
        this.sessionCacheService = sessionCacheService;
    }

    public void execute() {
        String localDataCenterID = this.sessionServerConfig.getSessionServerDataCenter();
        boolean ifLocalDataCenter = localDataCenterID.equals(this.dataChangeRequest.getDataCenter());
        Datum datum = this.getDatumCache();
        if (datum != null) {
            PushTaskClosure pushTaskClosure = this.getTaskClosure();
            for (ScopeEnum scopeEnum : ScopeEnum.values()) {
                Map<InetSocketAddress, Map<String, Subscriber>> map = this.getCache(scopeEnum);
                if (map == null || map.isEmpty()) continue;
                block6: for (Map.Entry<InetSocketAddress, Map<String, Subscriber>> entry : map.entrySet()) {
                    Collection<Subscriber> subscribersSend;
                    Map<String, Subscriber> subscriberMap = entry.getValue();
                    if (subscriberMap == null || subscriberMap.isEmpty() || (subscribersSend = this.subscribersVersionCheck(subscriberMap.values())).isEmpty()) continue;
                    this.evictReSubscribers(subscribersSend);
                    ArrayList<String> subscriberRegisterIdList = new ArrayList<String>(subscriberMap.keySet());
                    Subscriber subscriber = subscriberMap.values().iterator().next();
                    boolean isOldVersion = !BaseInfo.ClientVersion.StoreData.equals((Object)subscriber.getClientVersion());
                    switch (scopeEnum) {
                        case zone: {
                            if (!ifLocalDataCenter) continue block6;
                            if (isOldVersion) {
                                this.fireUserDataElementPushTask(entry.getKey(), datum, subscribersSend, pushTaskClosure);
                                continue block6;
                            }
                            this.fireReceivedDataMultiPushTask(datum, subscriberRegisterIdList, subscribersSend, ScopeEnum.zone, subscriber, pushTaskClosure);
                            continue block6;
                        }
                        case dataCenter: {
                            if (!ifLocalDataCenter) continue block6;
                            if (isOldVersion) {
                                this.fireUserDataElementMultiPushTask(entry.getKey(), datum, subscribersSend, pushTaskClosure);
                                continue block6;
                            }
                            this.fireReceivedDataMultiPushTask(datum, subscriberRegisterIdList, subscribersSend, scopeEnum, subscriber, pushTaskClosure);
                            continue block6;
                        }
                        case global: {
                            this.fireReceivedDataMultiPushTask(datum, subscriberRegisterIdList, subscribersSend, scopeEnum, subscriber, pushTaskClosure);
                            continue block6;
                        }
                    }
                    LOGGER.warn("unknown scope, {}", (Object)subscriber);
                }
            }
            pushTaskClosure.start();
        } else {
            LOGGER.error("Get publisher data error,which dataInfoId:" + this.dataChangeRequest.getDataInfoId() + " on dataCenter:" + this.dataChangeRequest.getDataCenter());
        }
    }

    private Collection<Subscriber> subscribersVersionCheck(Collection<Subscriber> subscribers) {
        ArrayList<Subscriber> subscribersSend = new ArrayList<Subscriber>();
        for (Subscriber subscriber : subscribers) {
            if (!subscriber.checkVersion(this.dataChangeRequest.getDataCenter(), Long.valueOf(this.dataChangeRequest.getVersion()))) continue;
            subscribersSend.add(subscriber);
        }
        return subscribersSend;
    }

    public PushTaskClosure getTaskClosure() {
        PushTaskClosure pushTaskClosure = new PushTaskClosure(this.executorManager.getPushTaskClosureExecutor());
        pushTaskClosure.setTaskClosure((status, task) -> {
            String dataCenter = this.dataChangeRequest.getDataCenter();
            String dataInfoId = this.dataChangeRequest.getDataInfoId();
            Long version = this.dataChangeRequest.getVersion();
            if (status == TaskProcessor.ProcessingResult.Success) {
                if (this.sessionServerConfig.isStopPushSwitch()) {
                    LOGGER.info("Stop Push switch on,dataCenter {} dataInfoId {} version {} can not be update!", new Object[]{dataCenter, dataInfoId, version});
                    return;
                }
                boolean result = this.sessionInterests.checkAndUpdateInterestVersions(dataCenter, dataInfoId, version);
                if (result) {
                    LOGGER.info("Push all tasks success,dataCenter:{} dataInfoId:{} version:{} update!", new Object[]{dataCenter, dataInfoId, version});
                } else {
                    LOGGER.info("Push all tasks success,but dataCenter:{} dataInfoId:{} version:{} need not update!", new Object[]{dataCenter, dataInfoId, version});
                }
            } else {
                LOGGER.warn("Push tasks found error,subscribers version can not be update!dataCenter:{} dataInfoId:{} version:{}", new Object[]{dataCenter, dataInfoId, version});
            }
        });
        return pushTaskClosure;
    }

    private void evictReSubscribers(Collection<Subscriber> subscribersPush) {
        if (this.sessionInterests instanceof ReSubscribers) {
            ReSubscribers reSubscribers = (ReSubscribers)((Object)this.sessionInterests);
            subscribersPush.forEach(reSubscribers::deleteReSubscriber);
        }
    }

    private void fireReceivedDataMultiPushTask(Datum datum, List<String> subscriberRegisterIdList, Collection<Subscriber> subscribers, ScopeEnum scopeEnum, Subscriber subscriber, PushTaskClosure pushTaskClosure) {
        String dataId = datum.getDataId();
        Predicate<String> zonePredicate = zone -> {
            if (!this.sessionServerConfig.getSessionServerRegion().equals(zone)) {
                if (ScopeEnum.zone == scopeEnum) {
                    return true;
                }
                if (ScopeEnum.dataCenter == scopeEnum) {
                    return this.sessionServerConfig.isInvalidForeverZone((String)zone) && !this.sessionServerConfig.isInvalidIgnored(dataId);
                }
            }
            return false;
        };
        ReceivedData receivedData = ReceivedDataConverter.getReceivedDataMulti(datum, scopeEnum, subscriberRegisterIdList, this.sessionServerConfig.getSessionServerRegion(), zonePredicate);
        HashMap<ReceivedData, URL> parameter = new HashMap<ReceivedData, URL>();
        parameter.put(receivedData, subscriber.getSourceAddress());
        TaskEvent taskEvent = new TaskEvent(parameter, TaskEvent.TaskType.RECEIVED_DATA_MULTI_PUSH_TASK);
        taskEvent.setTaskClosure((TaskClosure)pushTaskClosure);
        taskEvent.setAttribute("PUSH_CLIENT_SUBSCRIBERS", subscribers);
        taskLogger.info("send {} taskURL:{},taskScope:{}", new Object[]{taskEvent.getTaskType(), subscriber.getSourceAddress(), scopeEnum});
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }

    private Map<InetSocketAddress, Map<String, Subscriber>> getCache(ScopeEnum scopeEnum) {
        return this.sessionInterests.querySubscriberIndex(this.dataChangeRequest.getDataInfoId(), scopeEnum);
    }

    private Datum getDatumCache() {
        DatumKey datumKey = new DatumKey(this.dataChangeRequest.getDataInfoId(), this.dataChangeRequest.getDataCenter());
        Key key = new Key(Key.KeyType.OBJ, datumKey.getClass().getName(), datumKey);
        Value value = this.sessionCacheService.getValue(key);
        return value == null ? null : (Datum)value.getPayload();
    }

    private void fireUserDataElementPushTask(InetSocketAddress address, Datum datum, Collection<Subscriber> subscribers, PushTaskClosure pushTaskClosure) {
        TaskEvent taskEvent = new TaskEvent(TaskEvent.TaskType.USER_DATA_ELEMENT_PUSH_TASK);
        taskEvent.setTaskClosure((TaskClosure)pushTaskClosure);
        taskEvent.setSendTimeStamp(datum.getVersion());
        taskEvent.setAttribute("PUSH_CLIENT_SUBSCRIBERS", subscribers);
        taskEvent.setAttribute("PUSH_CLIENT_DATUM", (Object)datum);
        taskEvent.setAttribute("PUSH_CLIENT_URL", (Object)new URL(address));
        int size = datum != null && datum.getPubMap() != null ? datum.getPubMap().size() : 0;
        taskLogger.info("send {} taskURL:{},dataInfoId={},dataCenter={},pubSize={},subSize={}", new Object[]{taskEvent.getTaskType(), address, datum.getDataInfoId(), datum.getDataCenter(), size, subscribers.size()});
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }

    private void fireUserDataElementMultiPushTask(InetSocketAddress address, Datum datum, Collection<Subscriber> subscribers, PushTaskClosure pushTaskClosure) {
        TaskEvent taskEvent = new TaskEvent(TaskEvent.TaskType.USER_DATA_ELEMENT_MULTI_PUSH_TASK);
        taskEvent.setTaskClosure((TaskClosure)pushTaskClosure);
        taskEvent.setSendTimeStamp(datum.getVersion());
        taskEvent.setAttribute("PUSH_CLIENT_SUBSCRIBERS", subscribers);
        taskEvent.setAttribute("PUSH_CLIENT_DATUM", (Object)datum);
        taskEvent.setAttribute("PUSH_CLIENT_URL", (Object)new URL(address));
        int size = datum != null && datum.getPubMap() != null ? datum.getPubMap().size() : 0;
        taskLogger.info("send {} taskURL:{},dataInfoId={},dataCenter={},pubSize={},subSize={}", new Object[]{taskEvent.getTaskType(), address, datum.getDataInfoId(), datum.getDataCenter(), size, subscribers.size()});
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }

    @Override
    public long getExpiryTime() {
        return -1L;
    }

    public void setTaskEvent(TaskEvent taskEvent) {
        Object obj = taskEvent.getEventObj();
        if (!(obj instanceof DataChangeRequest)) {
            throw new IllegalArgumentException("Input task event object error!");
        }
        this.dataChangeRequest = (DataChangeRequest)obj;
    }

    public void setDataChangeRequest(DataChangeRequest dataChangeRequest) {
        this.dataChangeRequest = dataChangeRequest;
    }

    public boolean checkRetryTimes() {
        return this.checkRetryTimes(this.sessionServerConfig.getDataChangeFetchTaskRetryTimes());
    }

    public String toString() {
        return "DATA_CHANGE_FETCH_TASK{taskId='" + this.getTaskId() + '\'' + ", dataChangeRequest=" + this.dataChangeRequest + ", expiryTime='" + this.getExpiryTime() + '\'' + '}';
    }
}

