/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.resource;

import com.alipay.sofa.registry.common.model.store.Publisher;
import com.alipay.sofa.registry.common.model.store.StoreData;
import com.alipay.sofa.registry.common.model.store.Subscriber;
import com.alipay.sofa.registry.common.model.store.Watcher;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.store.DataStore;
import com.alipay.sofa.registry.server.session.store.Interests;
import com.alipay.sofa.registry.server.session.store.Watchers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@Path(value="digest")
public class SessionDigestResource {
    @Autowired
    private Interests sessionInterests;
    @Autowired
    private Watchers sessionWatchers;
    @Autowired
    private DataStore sessionDataStore;
    @Autowired
    private SessionServerConfig sessionServerConfig;
    private static final String SUB = "SUB";
    private static final String PUB = "PUB";
    private static final String WAT = "WAT";

    @GET
    @Path(value="{type}/data/query")
    @Produces(value={"application/json"})
    public Map<String, Collection<? extends StoreData>> getSessionDataByDataInfoId(@QueryParam(value="dataInfoId") String dataInfoId, @PathParam(value="type") String type) {
        HashMap<String, Collection<? extends StoreData>> serverList = new HashMap<String, Collection<? extends StoreData>>();
        if (dataInfoId != null) {
            Collection<Publisher> publishers = this.sessionDataStore.getStoreDataByDataInfoId(dataInfoId);
            Collection<Subscriber> subscribers = this.sessionInterests.getInterests(dataInfoId);
            Collection<Watcher> watchers = this.sessionWatchers.getWatchers(dataInfoId);
            this.fillServerList(type, serverList, publishers, subscribers, watchers);
        }
        return serverList;
    }

    @POST
    @Path(value="{type}/connect/query")
    @Produces(value={"application/json"})
    public Map<String, Collection<? extends StoreData>> getSessionDataByConnectId(List<String> connectIds, @PathParam(value="type") String type) {
        HashMap<String, Collection<? extends StoreData>> serverList = new HashMap<String, Collection<? extends StoreData>>();
        if (connectIds != null) {
            connectIds.forEach(connectId -> {
                Map pubMap = this.sessionDataStore.queryByConnectId((String)connectId);
                Map subMap = this.sessionInterests.queryByConnectId((String)connectId);
                Map watcherMap = this.sessionWatchers.queryByConnectId((String)connectId);
                ArrayList<Publisher> publishers = pubMap != null && !pubMap.isEmpty() ? pubMap.values() : new ArrayList<Publisher>();
                ArrayList<Subscriber> subscribers = subMap != null && !subMap.isEmpty() ? subMap.values() : new ArrayList<Subscriber>();
                ArrayList<Watcher> watchers = watcherMap != null && !watcherMap.isEmpty() ? watcherMap.values() : new ArrayList<Watcher>();
                this.fillServerList(type, serverList, publishers, subscribers, watchers);
            });
        }
        return serverList;
    }

    @GET
    @Path(value="/data/count")
    @Produces(value={"application/json"})
    public String getSessionDataCount() {
        long countSub = this.sessionInterests.count();
        long countPub = this.sessionDataStore.count();
        long countSubW = this.sessionWatchers.count();
        return String.format("Subscriber count: %s, Publisher count: %s, Watcher count: %s", countSub, countPub, countSubW);
    }

    @GET
    @Path(value="pushSwitch")
    @Produces(value={"application/json"})
    public Map<String, Object> getPushSwitch() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(1);
        resultMap.put("pushSwitch", !this.sessionServerConfig.isStopPushSwitch() ? "open" : "closed");
        return resultMap;
    }

    private void fillServerList(String type, Map<String, Collection<? extends StoreData>> serverList, Collection<Publisher> publishers, Collection<Subscriber> subscribers, Collection<Watcher> watchers) {
        block20: {
            block19: {
                String inputType;
                if (type == null || type.isEmpty()) break block19;
                switch (inputType = type.toUpperCase()) {
                    case "PUB": {
                        if (!CollectionUtils.isEmpty(publishers)) {
                            serverList.put(PUB, publishers);
                            break;
                        }
                        break block20;
                    }
                    case "SUB": {
                        if (!CollectionUtils.isEmpty(subscribers)) {
                            serverList.put(SUB, subscribers);
                            break;
                        }
                        break block20;
                    }
                    case "WAT": {
                        if (!CollectionUtils.isEmpty(watchers)) {
                            serverList.put(WAT, watchers);
                            break;
                        }
                        break block20;
                    }
                    default: {
                        if (!CollectionUtils.isEmpty(publishers)) {
                            serverList.put(PUB, publishers);
                        }
                        if (!CollectionUtils.isEmpty(subscribers)) {
                            serverList.put(SUB, subscribers);
                        }
                        if (!CollectionUtils.isEmpty(watchers)) {
                            serverList.put(WAT, watchers);
                            break;
                        }
                        break block20;
                    }
                }
                break block20;
            }
            if (publishers != null) {
                serverList.put(PUB, publishers);
            }
            if (subscribers != null) {
                serverList.put(SUB, subscribers);
            }
            if (watchers != null) {
                serverList.put(WAT, watchers);
            }
        }
    }
}

