/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.node.processor;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.scheduler.task.SessionTask;
import com.alipay.sofa.registry.task.Retryable;
import com.alipay.sofa.registry.task.batcher.TaskProcessor;
import java.util.List;

public class DataNodeSingleTaskProcessor
implements TaskProcessor<SessionTask> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeSingleTaskProcessor.class, (String)"[Task]");

    public TaskProcessor.ProcessingResult process(SessionTask task) {
        try {
            LOGGER.info("execute " + task);
            task.execute();
            LOGGER.info("end " + task);
            return TaskProcessor.ProcessingResult.Success;
        }
        catch (Throwable throwable) {
            Retryable retryAbleTask;
            LOGGER.error("Data node SingleTask Process error! Task:" + task, throwable);
            if (task instanceof Retryable && (retryAbleTask = (Retryable)task).checkRetryTimes()) {
                return TaskProcessor.ProcessingResult.TransientError;
            }
            return TaskProcessor.ProcessingResult.PermanentError;
        }
    }

    public TaskProcessor.ProcessingResult process(List<SessionTask> tasks) {
        return null;
    }
}

