/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.converters.string;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.util.DateUtils;
import com.alibaba.excel.util.NumberUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.DateUtil;

public class StringNumberConverter
implements Converter<String> {
    @Override
    public Class supportJavaTypeKey() {
        return String.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.NUMBER;
    }

    @Override
    public String convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        if (contentProperty != null && contentProperty.getDateTimeFormatProperty() != null) {
            return DateUtils.format(HSSFDateUtil.getJavaDate((double)cellData.getDoubleValue(), (boolean)contentProperty.getDateTimeFormatProperty().getUse1904windowing(), null), contentProperty.getDateTimeFormatProperty().getFormat());
        }
        if (contentProperty != null && contentProperty.getNumberFormatProperty() != null) {
            return NumberUtils.format(cellData.getDoubleValue(), contentProperty);
        }
        if (cellData.getDataFormat() != null) {
            if (DateUtil.isADateFormat((int)cellData.getDataFormat(), (String)cellData.getDataFormatString())) {
                return DateUtils.format(HSSFDateUtil.getJavaDate((double)cellData.getDoubleValue(), (boolean)globalConfiguration.getUse1904windowing(), null));
            }
            return NumberUtils.format(cellData.getDoubleValue(), contentProperty);
        }
        return NumberUtils.format(cellData.getDoubleValue(), contentProperty);
    }

    @Override
    public CellData convertToExcelData(String value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        return new CellData(Double.valueOf(value));
    }
}

