/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.rule;

import com.ql.util.express.rule.ConditionType;
import com.ql.util.express.rule.Node;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Condition
extends Node {
    private boolean prior = false;
    private ConditionType type;
    private List<Condition> children;

    public Condition(ConditionType type) {
        this.type = type;
    }

    public Condition() {
    }

    public boolean isPrior() {
        return this.prior;
    }

    public void setPrior(boolean prior) {
        this.prior = prior;
    }

    public ConditionType getType() {
        return this.type;
    }

    public void setType(ConditionType type) {
        this.type = type;
    }

    public List<Condition> getChildren() {
        return this.children;
    }

    public void setChildren(List<Condition> children) {
        this.children = children;
    }

    public void addChild(Condition child) {
        if (this.children == null) {
            this.children = new ArrayList<Condition>();
        }
        this.children.add(child);
    }

    public String toString() {
        if (this.type == ConditionType.Leaf) {
            return this.priorString(this.getText());
        }
        if (this.type == ConditionType.And) {
            return this.priorString(StringUtils.join(this.getChildren(), (String)" and "));
        }
        if (this.type == ConditionType.Or) {
            return this.priorString(StringUtils.join(this.getChildren(), (String)" or "));
        }
        return null;
    }

    private String priorString(String orig) {
        if (this.isPrior()) {
            return "(" + orig + ")";
        }
        return orig;
    }
}

