/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.instruction;

import com.ql.util.express.CallResult;
import com.ql.util.express.ExpressLoader;
import com.ql.util.express.ExpressRunner;
import com.ql.util.express.IExpressContext;
import com.ql.util.express.InstructionSet;
import com.ql.util.express.InstructionSetContext;
import com.ql.util.express.OperateData;
import com.ql.util.express.RunEnvironment;
import com.ql.util.express.instruction.IOperateDataCache;
import com.ql.util.express.instruction.opdata.OperateDataArrayItem;
import com.ql.util.express.instruction.opdata.OperateDataAttr;
import com.ql.util.express.instruction.opdata.OperateDataField;
import com.ql.util.express.instruction.opdata.OperateDataKeyValue;
import com.ql.util.express.instruction.opdata.OperateDataLocalVar;

public class OperateDataCacheImpl
implements IOperateDataCache {
    OperateData[] dataList;
    OperateDataAttr[] attrList;
    OperateDataLocalVar[] localVarList;
    OperateDataField[] fieldList;
    OperateDataArrayItem[] arrayList;
    OperateDataKeyValue[] keyValueList;
    RunEnvironment[] environmentList;
    CallResult[] callResultList;
    InstructionSetContext[] contextList;
    int dataPoint = 0;
    int attrPoint = 0;
    int localVarPoint = 0;
    int fieldPoint = 0;
    int arrayPoint = 0;
    int keyValuePoint = 0;
    int environmentPoint = 0;
    int callResultPoint = 0;
    int contextPoint = 0;
    int length;

    public OperateDataCacheImpl(int len) {
        this.length = len;
        this.dataList = new OperateData[len];
        this.attrList = new OperateDataAttr[len];
        this.localVarList = new OperateDataLocalVar[len];
        this.fieldList = new OperateDataField[len];
        this.arrayList = new OperateDataArrayItem[len];
        this.keyValueList = new OperateDataKeyValue[len];
        this.callResultList = new CallResult[len];
        this.environmentList = new RunEnvironment[len];
        this.contextList = new InstructionSetContext[len];
        for (int i = 0; i < len; ++i) {
            this.dataList[i] = new OperateData(null, null);
            this.attrList[i] = new OperateDataAttr(null, null);
            this.localVarList[i] = new OperateDataLocalVar(null, null);
            this.fieldList[i] = new OperateDataField((Object)null, null);
            this.arrayList[i] = new OperateDataArrayItem(null, -1);
            this.keyValueList[i] = new OperateDataKeyValue(null, null);
            this.callResultList[i] = new CallResult(null, false);
            this.environmentList[i] = new RunEnvironment(null, null, false);
            this.contextList[i] = new InstructionSetContext(false, null, null, null, false);
        }
    }

    @Override
    public void resetCache() {
        int i;
        for (i = 0; i <= this.dataPoint && i < this.length; ++i) {
            this.dataList[i].clear();
        }
        for (i = 0; i <= this.attrPoint && i < this.length; ++i) {
            this.attrList[i].clearDataAttr();
        }
        for (i = 0; i <= this.localVarPoint && i < this.length; ++i) {
            this.localVarList[i].clearDataLocalVar();
        }
        for (i = 0; i <= this.fieldPoint && i < this.length; ++i) {
            this.fieldList[i].clearDataField();
        }
        for (i = 0; i <= this.arrayPoint && i < this.length; ++i) {
            this.arrayList[i].clearDataArrayItem();
        }
        for (i = 0; i <= this.keyValuePoint && i < this.length; ++i) {
            this.keyValueList[i].clearDataKeyValue();
        }
        for (i = 0; i <= this.callResultPoint && i < this.length; ++i) {
            this.callResultList[i].clear();
        }
        for (i = 0; i <= this.environmentPoint && i < this.length; ++i) {
            this.environmentList[i].clear();
        }
        for (i = 0; i <= this.contextPoint && i < this.length; ++i) {
            this.contextList[i].clear();
        }
        this.dataPoint = 0;
        this.attrPoint = 0;
        this.localVarPoint = 0;
        this.fieldPoint = 0;
        this.arrayPoint = 0;
        this.keyValuePoint = 0;
        this.callResultPoint = 0;
        this.environmentPoint = 0;
        this.contextPoint = 0;
    }

    @Override
    public InstructionSetContext fetchInstructionSetContext(boolean aIsExpandToParent, ExpressRunner aRunner, IExpressContext<String, Object> aParent, ExpressLoader aExpressLoader, boolean aIsSupportDynamicFieldName) {
        InstructionSetContext result = null;
        if (this.contextPoint < this.length) {
            result = this.contextList[this.contextPoint];
            result.initial(aIsExpandToParent, aRunner, aParent, aExpressLoader, aIsSupportDynamicFieldName);
            ++this.contextPoint;
        } else {
            result = new InstructionSetContext(aIsExpandToParent, aRunner, aParent, aExpressLoader, aIsSupportDynamicFieldName);
        }
        return result;
    }

    @Override
    public RunEnvironment fetRunEnvironment(InstructionSet aInstructionSet, InstructionSetContext aContext, boolean aIsTrace) {
        RunEnvironment result = null;
        if (this.environmentPoint < this.length) {
            result = this.environmentList[this.environmentPoint];
            result.initial(aInstructionSet, aContext, aIsTrace);
            ++this.environmentPoint;
        } else {
            result = new RunEnvironment(aInstructionSet, aContext, aIsTrace);
        }
        return result;
    }

    @Override
    public CallResult fetchCallResult(Object aReturnValue, boolean aIsExit) {
        CallResult result = null;
        if (this.callResultPoint < this.length) {
            result = this.callResultList[this.callResultPoint];
            result.initial(aReturnValue, aIsExit);
            ++this.callResultPoint;
        } else {
            result = new CallResult(aReturnValue, aIsExit);
        }
        return result;
    }

    @Override
    public OperateData fetchOperateData(Object obj, Class<?> aType) {
        OperateData result = null;
        if (this.dataPoint < this.length) {
            result = this.dataList[this.dataPoint];
            result.initial(obj, aType);
            ++this.dataPoint;
        } else {
            result = new OperateData(obj, aType);
        }
        return result;
    }

    @Override
    public OperateDataAttr fetchOperateDataAttr(String name, Class<?> aType) {
        OperateDataAttr result = null;
        if (this.attrPoint < this.length) {
            result = this.attrList[this.attrPoint];
            result.initialDataAttr(name, aType);
            ++this.attrPoint;
        } else {
            result = new OperateDataAttr(name, aType);
        }
        return result;
    }

    @Override
    public OperateDataLocalVar fetchOperateDataLocalVar(String name, Class<?> aType) {
        OperateDataLocalVar result = null;
        if (this.localVarPoint < this.length) {
            result = this.localVarList[this.localVarPoint];
            result.initialDataLocalVar(name, aType);
            ++this.localVarPoint;
        } else {
            result = new OperateDataLocalVar(name, aType);
        }
        return result;
    }

    @Override
    public OperateDataField fetchOperateDataField(Object aFieldObject, String aFieldName) {
        OperateDataField result = null;
        if (this.fieldPoint < this.length) {
            result = this.fieldList[this.fieldPoint];
            result.initialDataField(aFieldObject, aFieldName);
            ++this.fieldPoint;
        } else {
            result = new OperateDataField(aFieldObject, aFieldName);
        }
        return result;
    }

    @Override
    public OperateDataArrayItem fetchOperateDataArrayItem(OperateData aArrayObject, int aIndex) {
        OperateDataArrayItem result = null;
        if (this.arrayPoint < this.length) {
            result = this.arrayList[this.arrayPoint];
            result.initialDataArrayItem(aArrayObject, aIndex);
            ++this.arrayPoint;
        } else {
            result = new OperateDataArrayItem(aArrayObject, aIndex);
        }
        return result;
    }

    @Override
    public OperateDataKeyValue fetchOperateDataKeyValue(OperateData aKey, OperateData aValue) {
        OperateDataKeyValue result = null;
        if (this.keyValuePoint < this.length) {
            result = this.keyValueList[this.keyValuePoint];
            result.initialDataKeyValue(aKey, aValue);
            ++this.keyValuePoint;
        } else {
            result = new OperateDataKeyValue(aKey, aValue);
        }
        return result;
    }

    @Override
    public long getFetchCount() {
        return 0L;
    }
}

