/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express;

import com.ql.util.express.CallResult;
import com.ql.util.express.ExpressLoader;
import com.ql.util.express.ExpressRunner;
import com.ql.util.express.IExpressContext;
import com.ql.util.express.InstructionSet;
import com.ql.util.express.InstructionSetContext;
import com.ql.util.express.RunEnvironment;
import com.ql.util.express.instruction.OperateDataCacheManager;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InstructionSetRunner {
    private static final Log log = LogFactory.getLog(InstructionSetRunner.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object executeOuter(ExpressRunner runner, InstructionSet sets, ExpressLoader loader, IExpressContext<String, Object> aContext, List<String> errorList, boolean isTrace, boolean isCatchException, Log aLog, boolean isSupportDynamicFieldName) throws Exception {
        try {
            OperateDataCacheManager.push(runner);
            Object object = InstructionSetRunner.execute(runner, sets, loader, aContext, errorList, isTrace, isCatchException, true, aLog, isSupportDynamicFieldName);
            return object;
        }
        finally {
            OperateDataCacheManager.resetCache(runner);
        }
    }

    public static Object execute(ExpressRunner runner, InstructionSet sets, ExpressLoader loader, IExpressContext<String, Object> aContext, List<String> errorList, boolean isTrace, boolean isCatchException, boolean isReturnLastData, Log aLog, boolean isSupportDynamicFieldName) throws Exception {
        InstructionSetContext context = OperateDataCacheManager.fetchInstructionSetContext(true, runner, aContext, loader, isSupportDynamicFieldName);
        Object result = InstructionSetRunner.execute(sets, context, errorList, isTrace, isCatchException, isReturnLastData, aLog);
        return result;
    }

    public static Object execute(InstructionSet set, InstructionSetContext context, List<String> errorList, boolean isTrace, boolean isCatchException, boolean isReturnLastData, Log aLog) throws Exception {
        RunEnvironment environmen = null;
        Object result = null;
        environmen = OperateDataCacheManager.fetRunEnvironment(set, context, isTrace);
        try {
            CallResult tempResult = set.excute(environmen, context, errorList, isReturnLastData, aLog);
            if (tempResult.isExit()) {
                result = tempResult.getReturnValue();
            }
        }
        catch (Exception e) {
            if (isCatchException) {
                if (aLog != null) {
                    aLog.error((Object)e.getMessage(), (Throwable)e);
                } else {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            throw e;
        }
        return result;
    }
}

