/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.orm;

import com.alibaba.p3c.pmd.I18nResources;
import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import com.alibaba.p3c.pmd.lang.java.util.ViolationUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import org.apache.commons.lang3.StringUtils;
import org.jaxen.JaxenException;

public class IbatisMethodQueryForListRule
extends AbstractAliRule {
    private static final String SQL_MAP_CLIENT_IMPORT_FULL_NAME = "com.ibatis.sqlmap.client.SqlMapClient";
    private static final String SQL_MAP_CLIENT_IMPORT_SIMPLE_NAME = "com.ibatis.sqlmap.client.*";
    private static final String SQL_MAP_CLIENT_NAME = "SqlMapClient";
    private static final String IBATIS_QUERY_FOR_LIST_METHOD_NAME = ".queryForList";
    private static final String PRIMARY_METHOD_NAME_XPATH = "PrimaryPrefix/Name";
    private static final String PRIMARY_METHOD_ARGUMENT_XPATH = "PrimarySuffix/Arguments/ArgumentList/Expression/PrimaryExpression/PrimaryPrefix/Literal";
    private static final String FIELDS_XPATH = "ClassOrInterfaceBody/ClassOrInterfaceBodyDeclaration/FieldDeclaration";

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        boolean hasImportSqlMapClient = this.hasSqlMapClientImport(node.findChildrenOfType(ASTImportDeclaration.class));
        if (!hasImportSqlMapClient) {
            return super.visit(node, data);
        }
        List classOrInterfaceDeclarations = node.findDescendantsOfType(ASTClassOrInterfaceDeclaration.class);
        if (classOrInterfaceDeclarations == null || classOrInterfaceDeclarations.isEmpty()) {
            return super.visit(node, data);
        }
        for (ASTClassOrInterfaceDeclaration classOrInterfaceDeclaration : classOrInterfaceDeclarations) {
            this.visitASTClassOrInterfaceDeclaration(classOrInterfaceDeclaration, data);
        }
        return super.visit(node, data);
    }

    private void visitASTClassOrInterfaceDeclaration(ASTClassOrInterfaceDeclaration classOrInterfaceDeclaration, Object data) {
        try {
            List fieldDeclarations = classOrInterfaceDeclaration.findChildNodesWithXPath(FIELDS_XPATH);
            Set<String> sqlMapFields = this.getSqlMapFields(fieldDeclarations);
            if (sqlMapFields.isEmpty()) {
                return;
            }
            List primaryExpressions = classOrInterfaceDeclaration.findDescendantsOfType(ASTPrimaryExpression.class);
            for (ASTPrimaryExpression primaryExpression : primaryExpressions) {
                this.visitPrimaryExpression(primaryExpression, data, sqlMapFields);
            }
        }
        catch (JaxenException jaxenException) {
            // empty catch block
        }
    }

    private Set<String> getSqlMapFields(List<Node> fieldDeclarations) {
        if (fieldDeclarations == null || fieldDeclarations.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        for (Node node : fieldDeclarations) {
            ASTFieldDeclaration fieldDeclaration = (ASTFieldDeclaration)node;
            if (!this.sqlMapClientField(fieldDeclaration)) continue;
            set.add(fieldDeclaration.getVariableName());
        }
        return set;
    }

    private boolean hasSqlMapClientImport(List<ASTImportDeclaration> importDeclarations) {
        if (importDeclarations == null || importDeclarations.isEmpty()) {
            return false;
        }
        for (ASTImportDeclaration importDeclaration : importDeclarations) {
            ASTName astName = (ASTName)importDeclaration.getFirstChildOfType(ASTName.class);
            boolean hasImport = astName != null && (SQL_MAP_CLIENT_IMPORT_FULL_NAME.equals(astName.getImage()) || SQL_MAP_CLIENT_IMPORT_SIMPLE_NAME.equals(astName.getImage()));
            if (!hasImport) continue;
            return true;
        }
        return false;
    }

    private void visitPrimaryExpression(ASTPrimaryExpression node, Object data, Set<String> sqlMapFields) throws JaxenException {
        List astNames = node.findChildNodesWithXPath(PRIMARY_METHOD_NAME_XPATH);
        for (Node astName : astNames) {
            List literals;
            String methodInvokeName;
            String methodName = astName.getImage();
            if (!StringUtils.isNotEmpty((CharSequence)methodName) || !methodName.contains(IBATIS_QUERY_FOR_LIST_METHOD_NAME) || StringUtils.isEmpty((CharSequence)(methodInvokeName = methodName.substring(0, methodName.indexOf(IBATIS_QUERY_FOR_LIST_METHOD_NAME)))) || !sqlMapFields.contains(methodInvokeName) || (literals = node.findChildNodesWithXPath(PRIMARY_METHOD_ARGUMENT_XPATH)) == null || literals.size() != 3) continue;
            boolean firstMethodArgumentString = "java.lang.String".equals(((ASTLiteral)literals.get(0)).getType().getName());
            boolean secondMethodArgumentInt = "int".equals(((ASTLiteral)literals.get(1)).getType().getName());
            boolean thirdMethodArgumentInt = "int".equals(((ASTLiteral)literals.get(2)).getType().getName());
            if (!firstMethodArgumentString || !secondMethodArgumentInt || !thirdMethodArgumentInt) continue;
            ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)node, data, I18nResources.getMessage("java.naming.IbatisMethodQueryForListRule.violation.msg"));
        }
    }

    private boolean sqlMapClientField(ASTFieldDeclaration node) {
        try {
            List astClassOrInterfaceTypes = node.findChildNodesWithXPath("Type/ReferenceType/ClassOrInterfaceType");
            for (Node astClassOrInterfaceType : astClassOrInterfaceTypes) {
                String fieldTypeName = astClassOrInterfaceType.getImage();
                if (!SQL_MAP_CLIENT_NAME.equals(fieldTypeName) && !SQL_MAP_CLIENT_IMPORT_FULL_NAME.equals(fieldTypeName)) continue;
                return true;
            }
        }
        catch (JaxenException jaxenException) {
            // empty catch block
        }
        return false;
    }
}

