/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.api.selector.AbstractSelector;
import com.alibaba.nacos.client.identify.CredentialService;
import com.alibaba.nacos.client.naming.beat.BeatInfo;
import com.alibaba.nacos.client.naming.beat.BeatReactor;
import com.alibaba.nacos.client.naming.core.Balancer;
import com.alibaba.nacos.client.naming.core.EventDispatcher;
import com.alibaba.nacos.client.naming.core.HostReactor;
import com.alibaba.nacos.client.naming.net.NamingProxy;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.naming.utils.StringUtils;
import com.alibaba.nacos.client.naming.utils.UtilAndComs;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.TemplateUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class NacosNamingService
implements NamingService {
    private String namespace;
    private String endpoint;
    private String serverList;
    private String cacheDir;
    private String logName;
    private HostReactor hostReactor;
    private BeatReactor beatReactor;
    private EventDispatcher eventDispatcher;
    private NamingProxy serverProxy;

    public NacosNamingService(String serverList) {
        Properties properties = new Properties();
        properties.setProperty("serverAddr", serverList);
        this.init(properties);
    }

    public NacosNamingService(Properties properties) {
        this.init(properties);
    }

    private void init(Properties properties) {
        this.serverList = properties.getProperty("serverAddr");
        this.initNamespace(properties);
        this.initEndpoint(properties);
        this.initWebRootContext();
        this.initCacheDir();
        this.initLogName(properties);
        this.eventDispatcher = new EventDispatcher();
        this.serverProxy = new NamingProxy(this.namespace, this.endpoint, this.serverList);
        this.serverProxy.setProperties(properties);
        this.beatReactor = new BeatReactor(this.serverProxy, this.initClientBeatThreadCount(properties));
        this.hostReactor = new HostReactor(this.eventDispatcher, this.serverProxy, this.cacheDir, this.isLoadCacheAtStart(properties), this.initPollingThreadCount(properties));
    }

    private int initClientBeatThreadCount(Properties properties) {
        if (properties == null) {
            return UtilAndComs.DEFAULT_CLIENT_BEAT_THREAD_COUNT;
        }
        return NumberUtils.toInt((String)properties.getProperty("namingClientBeatThreadCount"), (int)UtilAndComs.DEFAULT_CLIENT_BEAT_THREAD_COUNT);
    }

    private int initPollingThreadCount(Properties properties) {
        if (properties == null) {
            return UtilAndComs.DEFAULT_POLLING_THREAD_COUNT;
        }
        return NumberUtils.toInt((String)properties.getProperty("namingPollingThreadCount"), (int)UtilAndComs.DEFAULT_POLLING_THREAD_COUNT);
    }

    private boolean isLoadCacheAtStart(Properties properties) {
        boolean loadCacheAtStart = false;
        if (properties != null && StringUtils.isNotEmpty(properties.getProperty("namingLoadCacheAtStart"))) {
            loadCacheAtStart = BooleanUtils.toBoolean((String)properties.getProperty("namingLoadCacheAtStart"));
        }
        return loadCacheAtStart;
    }

    private void initLogName(Properties properties) {
        this.logName = System.getProperty("com.alibaba.nacos.naming.log.filename");
        if (StringUtils.isEmpty(this.logName)) {
            this.logName = properties != null && StringUtils.isNotEmpty(properties.getProperty("com.alibaba.nacos.naming.log.filename")) ? properties.getProperty("com.alibaba.nacos.naming.log.filename") : "naming.log";
        }
    }

    private void initCacheDir() {
        this.cacheDir = System.getProperty("com.alibaba.nacos.naming.cache.dir");
        if (StringUtils.isEmpty(this.cacheDir)) {
            this.cacheDir = System.getProperty("user.home") + "/nacos/naming/" + this.namespace;
        }
    }

    private void initEndpoint(Properties properties) {
        if (properties == null) {
            return;
        }
        String endpointUrl = TemplateUtils.stringEmptyAndThenExecute(properties.getProperty("endpoint"), new Callable<String>(){

            @Override
            public String call() {
                return System.getenv("ALIBABA_ALIWARE_ENDPOINT_URL");
            }
        });
        if (com.alibaba.nacos.client.utils.StringUtils.isBlank(endpointUrl)) {
            return;
        }
        String endpointPort = TemplateUtils.stringEmptyAndThenExecute(properties.getProperty("endpointPort"), new Callable<String>(){

            @Override
            public String call() {
                return System.getenv("ALIBABA_ALIWARE_ENDPOINT_PORT");
            }
        });
        endpointPort = TemplateUtils.stringEmptyAndThenExecute(endpointPort, new Callable<String>(){

            @Override
            public String call() {
                return "8080";
            }
        });
        this.endpoint = endpointUrl + ":" + endpointPort;
    }

    private void initNamespace(Properties properties) {
        String tmpNamespace = null;
        if (properties != null) {
            tmpNamespace = properties.getProperty("namespace");
        }
        tmpNamespace = TemplateUtils.stringEmptyAndThenExecute(tmpNamespace, new Callable<String>(){

            @Override
            public String call() {
                String namespace = System.getProperty("namespace");
                LogUtils.NAMING_LOGGER.info("initializer namespace from System Property :" + namespace);
                return namespace;
            }
        });
        tmpNamespace = TemplateUtils.stringEmptyAndThenExecute(tmpNamespace, new Callable<String>(){

            @Override
            public String call() {
                String namespace = System.getenv("ALIBABA_ALIWARE_NAMESPACE");
                LogUtils.NAMING_LOGGER.info("initializer namespace from System Environment :" + namespace);
                return namespace;
            }
        });
        tmpNamespace = TemplateUtils.stringEmptyAndThenExecute(tmpNamespace, new Callable<String>(){

            @Override
            public String call() {
                String namespace = CredentialService.getInstance().getCredential().getTenantId();
                LogUtils.NAMING_LOGGER.info("initializer namespace from Credential Module " + namespace);
                return namespace;
            }
        });
        this.namespace = tmpNamespace = TemplateUtils.stringEmptyAndThenExecute(tmpNamespace, new Callable<String>(){

            @Override
            public String call() {
                return "public";
            }
        });
    }

    private void initWebRootContext() {
        final String webContext = System.getProperty("nacos.naming.web.context");
        TemplateUtils.stringNotEmptyAndThenExecute(webContext, new Runnable(){

            @Override
            public void run() {
                UtilAndComs.WEB_CONTEXT = webContext.indexOf("/") > -1 ? webContext : "/" + webContext;
                UtilAndComs.NACOS_URL_BASE = UtilAndComs.WEB_CONTEXT + "/v1/ns";
                UtilAndComs.NACOS_URL_INSTANCE = UtilAndComs.NACOS_URL_BASE + "/instance";
            }
        });
    }

    public void registerInstance(String serviceName, String ip, int port) throws NacosException {
        this.registerInstance(serviceName, ip, port, "DEFAULT");
    }

    public void registerInstance(String serviceName, String groupName, String ip, int port) throws NacosException {
        this.registerInstance(serviceName, groupName, ip, port, "DEFAULT");
    }

    public void registerInstance(String serviceName, String ip, int port, String clusterName) throws NacosException {
        this.registerInstance(serviceName, "DEFAULT_GROUP", ip, port, clusterName);
    }

    public void registerInstance(String serviceName, String groupName, String ip, int port, String clusterName) throws NacosException {
        Instance instance = new Instance();
        instance.setIp(ip);
        instance.setPort(port);
        instance.setWeight(1.0);
        instance.setClusterName(clusterName);
        this.registerInstance(serviceName, groupName, instance);
    }

    public void registerInstance(String serviceName, Instance instance) throws NacosException {
        this.registerInstance(serviceName, "DEFAULT_GROUP", instance);
    }

    public void registerInstance(String serviceName, String groupName, Instance instance) throws NacosException {
        if (instance.isEphemeral()) {
            BeatInfo beatInfo = new BeatInfo();
            beatInfo.setServiceName(NamingUtils.getGroupedName((String)serviceName, (String)groupName));
            beatInfo.setIp(instance.getIp());
            beatInfo.setPort(instance.getPort());
            beatInfo.setCluster(instance.getClusterName());
            beatInfo.setWeight(instance.getWeight());
            beatInfo.setMetadata(instance.getMetadata());
            beatInfo.setScheduled(false);
            this.beatReactor.addBeatInfo(NamingUtils.getGroupedName((String)serviceName, (String)groupName), beatInfo);
        }
        this.serverProxy.registerService(NamingUtils.getGroupedName((String)serviceName, (String)groupName), groupName, instance);
    }

    public void deregisterInstance(String serviceName, String ip, int port) throws NacosException {
        this.deregisterInstance(serviceName, ip, port, "DEFAULT");
    }

    public void deregisterInstance(String serviceName, String groupName, String ip, int port) throws NacosException {
        this.deregisterInstance(serviceName, groupName, ip, port, "DEFAULT");
    }

    public void deregisterInstance(String serviceName, String ip, int port, String clusterName) throws NacosException {
        this.deregisterInstance(serviceName, "DEFAULT_GROUP", ip, port, clusterName);
    }

    public void deregisterInstance(String serviceName, String groupName, String ip, int port, String clusterName) throws NacosException {
        Instance instance = new Instance();
        instance.setIp(ip);
        instance.setPort(port);
        instance.setClusterName(clusterName);
        this.deregisterInstance(serviceName, groupName, instance);
    }

    public void deregisterInstance(String serviceName, String groupName, Instance instance) throws NacosException {
        this.beatReactor.removeBeatInfo(NamingUtils.getGroupedName((String)serviceName, (String)groupName), instance.getIp(), instance.getPort());
        this.serverProxy.deregisterService(NamingUtils.getGroupedName((String)serviceName, (String)groupName), instance);
    }

    public List<Instance> getAllInstances(String serviceName) throws NacosException {
        return this.getAllInstances(serviceName, new ArrayList<String>());
    }

    public List<Instance> getAllInstances(String serviceName, String groupName) throws NacosException {
        return this.getAllInstances(serviceName, groupName, new ArrayList<String>());
    }

    public List<Instance> getAllInstances(String serviceName, boolean subscribe) throws NacosException {
        return this.getAllInstances(serviceName, new ArrayList<String>(), subscribe);
    }

    public List<Instance> getAllInstances(String serviceName, String groupName, boolean subscribe) throws NacosException {
        return this.getAllInstances(serviceName, groupName, new ArrayList<String>(), subscribe);
    }

    public List<Instance> getAllInstances(String serviceName, List<String> clusters) throws NacosException {
        return this.getAllInstances(serviceName, clusters, true);
    }

    public List<Instance> getAllInstances(String serviceName, String groupName, List<String> clusters) throws NacosException {
        return this.getAllInstances(serviceName, groupName, clusters, true);
    }

    public List<Instance> getAllInstances(String serviceName, List<String> clusters, boolean subscribe) throws NacosException {
        return this.getAllInstances(serviceName, "DEFAULT_GROUP", clusters, subscribe);
    }

    public List<Instance> getAllInstances(String serviceName, String groupName, List<String> clusters, boolean subscribe) throws NacosException {
        List list;
        ServiceInfo serviceInfo = subscribe ? this.hostReactor.getServiceInfo(NamingUtils.getGroupedName((String)serviceName, (String)groupName), StringUtils.join(clusters, ",")) : this.hostReactor.getServiceInfoDirectlyFromServer(NamingUtils.getGroupedName((String)serviceName, (String)groupName), StringUtils.join(clusters, ","));
        if (serviceInfo == null || CollectionUtils.isEmpty(list = serviceInfo.getHosts())) {
            return new ArrayList<Instance>();
        }
        return list;
    }

    public List<Instance> selectInstances(String serviceName, boolean healthy) throws NacosException {
        return this.selectInstances(serviceName, new ArrayList<String>(), healthy);
    }

    public List<Instance> selectInstances(String serviceName, String groupName, boolean healthy) throws NacosException {
        return this.selectInstances(serviceName, groupName, healthy, true);
    }

    public List<Instance> selectInstances(String serviceName, boolean healthy, boolean subscribe) throws NacosException {
        return this.selectInstances(serviceName, new ArrayList<String>(), healthy, subscribe);
    }

    public List<Instance> selectInstances(String serviceName, String groupName, boolean healthy, boolean subscribe) throws NacosException {
        return this.selectInstances(serviceName, groupName, new ArrayList<String>(), healthy, subscribe);
    }

    public List<Instance> selectInstances(String serviceName, List<String> clusters, boolean healthy) throws NacosException {
        return this.selectInstances(serviceName, clusters, healthy, true);
    }

    public List<Instance> selectInstances(String serviceName, String groupName, List<String> clusters, boolean healthy) throws NacosException {
        return this.selectInstances(serviceName, groupName, clusters, healthy, true);
    }

    public List<Instance> selectInstances(String serviceName, List<String> clusters, boolean healthy, boolean subscribe) throws NacosException {
        return this.selectInstances(serviceName, "DEFAULT_GROUP", clusters, healthy, subscribe);
    }

    public List<Instance> selectInstances(String serviceName, String groupName, List<String> clusters, boolean healthy, boolean subscribe) throws NacosException {
        ServiceInfo serviceInfo = subscribe ? this.hostReactor.getServiceInfo(NamingUtils.getGroupedName((String)serviceName, (String)groupName), StringUtils.join(clusters, ",")) : this.hostReactor.getServiceInfoDirectlyFromServer(NamingUtils.getGroupedName((String)serviceName, (String)groupName), StringUtils.join(clusters, ","));
        return this.selectInstances(serviceInfo, healthy);
    }

    public Instance selectOneHealthyInstance(String serviceName) throws NacosException {
        return this.selectOneHealthyInstance(serviceName, new ArrayList<String>());
    }

    public Instance selectOneHealthyInstance(String serviceName, String groupName) throws NacosException {
        return this.selectOneHealthyInstance(serviceName, groupName, true);
    }

    public Instance selectOneHealthyInstance(String serviceName, boolean subscribe) throws NacosException {
        return this.selectOneHealthyInstance(serviceName, new ArrayList<String>(), subscribe);
    }

    public Instance selectOneHealthyInstance(String serviceName, String groupName, boolean subscribe) throws NacosException {
        return this.selectOneHealthyInstance(serviceName, groupName, new ArrayList<String>(), subscribe);
    }

    public Instance selectOneHealthyInstance(String serviceName, List<String> clusters) throws NacosException {
        return this.selectOneHealthyInstance(serviceName, clusters, true);
    }

    public Instance selectOneHealthyInstance(String serviceName, String groupName, List<String> clusters) throws NacosException {
        return this.selectOneHealthyInstance(serviceName, groupName, clusters, true);
    }

    public Instance selectOneHealthyInstance(String serviceName, List<String> clusters, boolean subscribe) throws NacosException {
        return this.selectOneHealthyInstance(serviceName, "DEFAULT_GROUP", clusters, subscribe);
    }

    public Instance selectOneHealthyInstance(String serviceName, String groupName, List<String> clusters, boolean subscribe) throws NacosException {
        if (subscribe) {
            return Balancer.RandomByWeight.selectHost(this.hostReactor.getServiceInfo(NamingUtils.getGroupedName((String)serviceName, (String)groupName), StringUtils.join(clusters, ",")));
        }
        return Balancer.RandomByWeight.selectHost(this.hostReactor.getServiceInfoDirectlyFromServer(NamingUtils.getGroupedName((String)serviceName, (String)groupName), StringUtils.join(clusters, ",")));
    }

    public void subscribe(String serviceName, EventListener listener) throws NacosException {
        this.subscribe(serviceName, new ArrayList<String>(), listener);
    }

    public void subscribe(String serviceName, String groupName, EventListener listener) throws NacosException {
        this.subscribe(serviceName, groupName, new ArrayList<String>(), listener);
    }

    public void subscribe(String serviceName, List<String> clusters, EventListener listener) throws NacosException {
        this.subscribe(serviceName, "DEFAULT_GROUP", clusters, listener);
    }

    public void subscribe(String serviceName, String groupName, List<String> clusters, EventListener listener) throws NacosException {
        this.eventDispatcher.addListener(this.hostReactor.getServiceInfo(NamingUtils.getGroupedName((String)serviceName, (String)groupName), StringUtils.join(clusters, ",")), StringUtils.join(clusters, ","), listener);
    }

    public void unsubscribe(String serviceName, EventListener listener) throws NacosException {
        this.unsubscribe(serviceName, new ArrayList<String>(), listener);
    }

    public void unsubscribe(String serviceName, String groupName, EventListener listener) throws NacosException {
        this.unsubscribe(serviceName, groupName, new ArrayList<String>(), listener);
    }

    public void unsubscribe(String serviceName, List<String> clusters, EventListener listener) throws NacosException {
        this.unsubscribe(serviceName, "DEFAULT_GROUP", clusters, listener);
    }

    public void unsubscribe(String serviceName, String groupName, List<String> clusters, EventListener listener) throws NacosException {
        this.eventDispatcher.removeListener(NamingUtils.getGroupedName((String)serviceName, (String)groupName), StringUtils.join(clusters, ","), listener);
    }

    public ListView<String> getServicesOfServer(int pageNo, int pageSize) throws NacosException {
        return this.serverProxy.getServiceList(pageNo, pageSize, "DEFAULT_GROUP");
    }

    public ListView<String> getServicesOfServer(int pageNo, int pageSize, String groupName) throws NacosException {
        return this.getServicesOfServer(pageNo, pageSize, groupName, null);
    }

    public ListView<String> getServicesOfServer(int pageNo, int pageSize, AbstractSelector selector) throws NacosException {
        return this.getServicesOfServer(pageNo, pageSize, "DEFAULT_GROUP", selector);
    }

    public ListView<String> getServicesOfServer(int pageNo, int pageSize, String groupName, AbstractSelector selector) throws NacosException {
        return this.serverProxy.getServiceList(pageNo, pageSize, groupName, selector);
    }

    public List<ServiceInfo> getSubscribeServices() {
        return this.eventDispatcher.getSubscribeServices();
    }

    public String getServerStatus() {
        return this.serverProxy.serverHealthy() ? "UP" : "DOWN";
    }

    private List<Instance> selectInstances(ServiceInfo serviceInfo, boolean healthy) {
        List list;
        if (serviceInfo == null || CollectionUtils.isEmpty(list = serviceInfo.getHosts())) {
            return new ArrayList<Instance>();
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Instance instance = (Instance)iterator.next();
            if (healthy == instance.isHealthy() && instance.isEnabled() && !(instance.getWeight() <= 0.0)) continue;
            iterator.remove();
        }
        return list;
    }

    public BeatReactor getBeatReactor() {
        return this.beatReactor;
    }
}

