/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.http;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.http.HttpAgent;
import com.alibaba.nacos.client.config.impl.HttpSimpleClient;
import com.alibaba.nacos.client.config.impl.ServerListManager;
import com.alibaba.nacos.client.config.impl.SpasAdapter;
import com.alibaba.nacos.client.config.utils.IOUtils;
import com.alibaba.nacos.client.config.utils.LogUtils;
import com.alibaba.nacos.client.identify.STSConfig;
import com.alibaba.nacos.client.logger.Logger;
import com.alibaba.nacos.client.logger.support.LoggerHelper;
import com.alibaba.nacos.client.utils.JSONUtils;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.client.utils.StringUtils;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.type.TypeReference;

public class ServerHttpAgent
implements HttpAgent {
    public static final Logger log = LogUtils.logger(ServerHttpAgent.class);
    private String accessKey;
    private String secretKey;
    private String encode;
    private volatile STSCredential sTSCredential;
    final ServerListManager serverListMgr;

    @Override
    public HttpSimpleClient.HttpResult httpGet(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        long endTime = System.currentTimeMillis() + readTimeoutMs;
        boolean isSSL = false;
        do {
            try {
                List<String> newHeaders = this.getSpasHeaders(paramValues);
                if (headers != null) {
                    newHeaders.addAll(headers);
                }
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpGet(this.getUrl(this.serverListMgr.getCurrentServerAddr(), path, isSSL), newHeaders, paramValues, encoding, readTimeoutMs, isSSL);
                if (result.code != 500 && result.code != 502 && result.code != 503) {
                    return result;
                }
                log.error("NACOS ConnectException", "currentServerAddr:{}. httpCode:", new Object[]{this.serverListMgr.getCurrentServerAddr(), result.code});
            }
            catch (ConnectException ce) {
                log.error("NACOS ConnectException", "currentServerAddr:{}", new Object[]{this.serverListMgr.getCurrentServerAddr()});
                this.serverListMgr.refreshCurrentServerAddr();
            }
            catch (SocketTimeoutException stoe) {
                log.error("NACOS  SocketTimeoutException", "currentServerAddr:{}", new Object[]{this.serverListMgr.getCurrentServerAddr()});
                this.serverListMgr.refreshCurrentServerAddr();
            }
            catch (IOException ioe) {
                log.error("NACOS  IOException", "currentServerAddr:{}", new Object[]{this.serverListMgr.getCurrentServerAddr()});
                throw ioe;
            }
        } while (System.currentTimeMillis() <= endTime);
        log.error("NACOS-0002", LoggerHelper.getErrorCodeStr("NACOS", "NACOS-0002", "\u73af\u5883\u95ee\u9898", "no available server"));
        throw new ConnectException("no available server");
    }

    @Override
    public HttpSimpleClient.HttpResult httpPost(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        long endTime = System.currentTimeMillis() + readTimeoutMs;
        boolean isSSL = false;
        do {
            try {
                List<String> newHeaders = this.getSpasHeaders(paramValues);
                if (headers != null) {
                    newHeaders.addAll(headers);
                }
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpPost(this.getUrl(this.serverListMgr.getCurrentServerAddr(), path, isSSL), newHeaders, paramValues, encoding, readTimeoutMs, isSSL);
                if (result.code != 500 && result.code != 502 && result.code != 503) {
                    return result;
                }
                log.error("NACOS ConnectException", "currentServerAddr:{}. httpCode:", new Object[]{this.serverListMgr.getCurrentServerAddr(), result.code});
            }
            catch (ConnectException ce) {
                log.error("NACOS ConnectException", "currentServerAddr:{}", new Object[]{this.serverListMgr.getCurrentServerAddr()});
                this.serverListMgr.refreshCurrentServerAddr();
            }
            catch (SocketTimeoutException stoe) {
                log.error("NACOS  SocketTimeoutException", "currentServerAddr:{}", new Object[]{this.serverListMgr.getCurrentServerAddr()});
                this.serverListMgr.refreshCurrentServerAddr();
            }
            catch (IOException ioe) {
                log.error("NACOS  IOException", "currentServerAddr:{}", new Object[]{this.serverListMgr.getCurrentServerAddr()});
                throw ioe;
            }
        } while (System.currentTimeMillis() <= endTime);
        log.error("NACOS-0002", LoggerHelper.getErrorCodeStr("NACOS", "NACOS-0002", "\u73af\u5883\u95ee\u9898", "no available server"));
        throw new ConnectException("no available server");
    }

    @Override
    public HttpSimpleClient.HttpResult httpDelete(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        long endTime = System.currentTimeMillis() + readTimeoutMs;
        boolean isSSL = false;
        do {
            try {
                List<String> newHeaders = this.getSpasHeaders(paramValues);
                if (headers != null) {
                    newHeaders.addAll(headers);
                }
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpDelete(this.getUrl(this.serverListMgr.getCurrentServerAddr(), path, isSSL), newHeaders, paramValues, encoding, readTimeoutMs, isSSL);
                if (result.code != 500 && result.code != 502 && result.code != 503) {
                    return result;
                }
                log.error("NACOS ConnectException", "currentServerAddr:{}. httpCode:", new Object[]{this.serverListMgr.getCurrentServerAddr(), result.code});
            }
            catch (ConnectException ce) {
                log.error("NACOS ConnectException", "currentServerAddr:{}", new Object[]{this.serverListMgr.getCurrentServerAddr()});
                this.serverListMgr.refreshCurrentServerAddr();
            }
            catch (SocketTimeoutException stoe) {
                log.error("NACOS  SocketTimeoutException", "currentServerAddr:{}", new Object[]{this.serverListMgr.getCurrentServerAddr()});
                this.serverListMgr.refreshCurrentServerAddr();
            }
            catch (IOException ioe) {
                log.error("NACOS  IOException", "currentServerAddr:{}", new Object[]{this.serverListMgr.getCurrentServerAddr()});
                throw ioe;
            }
        } while (System.currentTimeMillis() <= endTime);
        log.error("NACOS-0002", LoggerHelper.getErrorCodeStr("NACOS", "NACOS-0002", "\u73af\u5883\u95ee\u9898", "no available server"));
        throw new ConnectException("no available server");
    }

    private String getUrl(String serverAddr, String relativePath, boolean isSSL) {
        String httpPrefix = "http://";
        if (isSSL) {
            httpPrefix = "https://";
        }
        return httpPrefix + serverAddr + "/" + this.serverListMgr.getContentPath() + relativePath;
    }

    public static String getAppname() {
        return ParamUtil.getAppName();
    }

    public ServerHttpAgent(ServerListManager mgr) {
        this.serverListMgr = mgr;
    }

    public ServerHttpAgent(ServerListManager mgr, Properties properties) {
        this.serverListMgr = mgr;
        String ak = properties.getProperty("accessKey");
        this.accessKey = StringUtils.isBlank(ak) ? SpasAdapter.getAk() : ak;
        String sk = properties.getProperty("secretKey");
        this.secretKey = StringUtils.isBlank(sk) ? SpasAdapter.getSk() : sk;
    }

    public ServerHttpAgent(Properties properties) throws NacosException {
        String encodeTmp = properties.getProperty("encode");
        this.encode = StringUtils.isBlank(encodeTmp) ? "UTF-8" : encodeTmp.trim();
        this.serverListMgr = new ServerListManager(properties);
        String ak = properties.getProperty("accessKey");
        this.accessKey = StringUtils.isBlank(ak) ? SpasAdapter.getAk() : ak;
        String sk = properties.getProperty("secretKey");
        this.secretKey = StringUtils.isBlank(sk) ? SpasAdapter.getSk() : sk;
    }

    @Override
    public synchronized void start() throws NacosException {
        this.serverListMgr.start();
    }

    private List<String> getSpasHeaders(List<String> paramValues) throws IOException {
        ArrayList<String> newHeaders = new ArrayList<String>();
        if (STSConfig.getInstance().isSTSOn()) {
            STSCredential sTSCredential = this.getSTSCredential();
            this.accessKey = sTSCredential.accessKeyId;
            this.secretKey = sTSCredential.accessKeySecret;
            newHeaders.add("Spas-SecurityToken");
            newHeaders.add(sTSCredential.securityToken);
        }
        if (StringUtils.isNotEmpty(this.accessKey) && StringUtils.isNotEmpty(this.secretKey)) {
            newHeaders.add("Spas-AccessKey");
            newHeaders.add(this.accessKey);
            List<String> signHeaders = SpasAdapter.getSignHeaders(paramValues, this.secretKey);
            if (signHeaders != null) {
                newHeaders.addAll(signHeaders);
            }
        }
        return newHeaders;
    }

    private STSCredential getSTSCredential() throws IOException {
        STSCredential stsCredentialTmp;
        boolean cacheSecurityCredentials = STSConfig.getInstance().isCacheSecurityCredentials();
        if (cacheSecurityCredentials && this.sTSCredential != null) {
            int timeToRefreshInMillisecond;
            long currentTime = System.currentTimeMillis();
            long expirationTime = this.sTSCredential.expiration.getTime();
            if (expirationTime - currentTime > (long)(timeToRefreshInMillisecond = STSConfig.getInstance().getTimeToRefreshInMillisecond())) {
                return this.sTSCredential;
            }
        }
        String stsResponse = ServerHttpAgent.getSTSResponse();
        this.sTSCredential = stsCredentialTmp = (STSCredential)JSONUtils.deserializeObject(stsResponse, new TypeReference<STSCredential>(){});
        log.info("getSTSCredential", "code:{}, accessKeyId:{}, lastUpdated:{}, expiration:{}", this.sTSCredential.getCode(), this.sTSCredential.getAccessKeyId(), this.sTSCredential.getLastUpdated(), this.sTSCredential.getExpiration());
        return this.sTSCredential;
    }

    private static String getSTSResponse() throws IOException {
        String response;
        int respCode;
        String securityCredentials = STSConfig.getInstance().getSecurityCredentials();
        if (securityCredentials != null) {
            return securityCredentials;
        }
        String securityCredentialsUrl = STSConfig.getInstance().getSecurityCredentialsUrl();
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(securityCredentialsUrl).openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(ParamUtil.getConnectTimeout() > 100 ? ParamUtil.getConnectTimeout() : 100);
            conn.setReadTimeout(1000);
            conn.connect();
            respCode = conn.getResponseCode();
            response = 200 == respCode ? IOUtils.toString(conn.getInputStream(), "UTF-8") : IOUtils.toString(conn.getErrorStream(), "UTF-8");
        }
        catch (IOException e) {
            log.error("500", "can not get security credentials", e);
            throw e;
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
        if (200 == respCode) {
            return response;
        }
        log.error(respCode + "", "can not get security credentials, securityCredentialsUrl:{}, response:{}", new Object[]{securityCredentialsUrl, response});
        throw new IOException("can not get security credentials, responseCode: " + respCode + ", response: " + response);
    }

    @Override
    public String getName() {
        return this.serverListMgr.getName();
    }

    @Override
    public String getNamespace() {
        return this.serverListMgr.getNamespace();
    }

    @Override
    public String getTenant() {
        return this.serverListMgr.getTenant();
    }

    @Override
    public String getEncode() {
        return this.encode;
    }

    private static class STSCredential {
        @JsonProperty(value="AccessKeyId")
        private String accessKeyId;
        @JsonProperty(value="AccessKeySecret")
        private String accessKeySecret;
        @JsonProperty(value="Expiration")
        private Date expiration;
        @JsonProperty(value="SecurityToken")
        private String securityToken;
        @JsonProperty(value="LastUpdated")
        private Date lastUpdated;
        @JsonProperty(value="Code")
        private String code;

        private STSCredential() {
        }

        public String getAccessKeyId() {
            return this.accessKeyId;
        }

        public Date getExpiration() {
            return this.expiration;
        }

        public Date getLastUpdated() {
            return this.lastUpdated;
        }

        public String getCode() {
            return this.code;
        }

        public String toString() {
            return "STSCredential{accessKeyId='" + this.accessKeyId + '\'' + ", accessKeySecret='" + this.accessKeySecret + '\'' + ", expiration=" + this.expiration + ", securityToken='" + this.securityToken + '\'' + ", lastUpdated=" + this.lastUpdated + ", code='" + this.code + '\'' + '}';
        }
    }
}

