/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.http;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.http.HttpAgent;
import com.alibaba.nacos.client.config.impl.HttpSimpleClient;
import com.alibaba.nacos.client.monitor.MetricsMonitor;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class MetricsHttpAgent
implements HttpAgent {
    private HttpAgent httpAgent;

    public MetricsHttpAgent(HttpAgent httpAgent) {
        this.httpAgent = httpAgent;
    }

    @Override
    public void start() throws NacosException {
        this.httpAgent.start();
    }

    @Override
    public HttpSimpleClient.HttpResult httpGet(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        long start = System.currentTimeMillis();
        long end = 0L;
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.httpAgent.httpGet(path, headers, paramValues, encoding, readTimeoutMs);
        }
        catch (IOException e) {
            end = System.currentTimeMillis();
            MetricsMonitor.getConfigRequestMonitor("GET", path, "NA").record(end - start, TimeUnit.MILLISECONDS);
            throw e;
        }
        end = System.currentTimeMillis();
        MetricsMonitor.getConfigRequestMonitor("GET", path, String.valueOf(result.code)).record(end - start, TimeUnit.MILLISECONDS);
        return result;
    }

    @Override
    public HttpSimpleClient.HttpResult httpPost(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        long start = System.currentTimeMillis();
        long end = 0L;
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.httpAgent.httpPost(path, headers, paramValues, encoding, readTimeoutMs);
        }
        catch (IOException e) {
            end = System.currentTimeMillis();
            MetricsMonitor.getConfigRequestMonitor("POST", path, "NA").record(end - start, TimeUnit.MILLISECONDS);
            throw e;
        }
        end = System.currentTimeMillis();
        MetricsMonitor.getConfigRequestMonitor("POST", path, String.valueOf(result.code)).record(end - start, TimeUnit.MILLISECONDS);
        return result;
    }

    @Override
    public HttpSimpleClient.HttpResult httpDelete(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        long start = System.currentTimeMillis();
        long end = 0L;
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.httpAgent.httpDelete(path, headers, paramValues, encoding, readTimeoutMs);
        }
        catch (IOException e) {
            end = System.currentTimeMillis();
            MetricsMonitor.getConfigRequestMonitor("DELETE", path, "NA").record(end - start, TimeUnit.MILLISECONDS);
            throw e;
        }
        end = System.currentTimeMillis();
        MetricsMonitor.getConfigRequestMonitor("DELETE", path, String.valueOf(result.code)).record(end - start, TimeUnit.MILLISECONDS);
        return result;
    }

    @Override
    public String getName() {
        return this.httpAgent.getName();
    }

    @Override
    public String getNamespace() {
        return this.httpAgent.getNamespace();
    }

    @Override
    public String getTenant() {
        return this.httpAgent.getTenant();
    }

    @Override
    public String getEncode() {
        return this.httpAgent.getEncode();
    }
}

