/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.logger.log4j2;

import com.alibaba.nacos.client.logger.Logger;
import com.alibaba.nacos.client.logger.log4j2.Log4j2Logger;
import com.alibaba.nacos.client.logger.nop.NopLogger;
import com.alibaba.nacos.client.logger.support.ILoggerFactory;
import com.alibaba.nacos.client.logger.support.LogLog;
import org.apache.logging.log4j.LogManager;

public class Log4j2LoggerFactory
implements ILoggerFactory {
    public Log4j2LoggerFactory() throws ClassNotFoundException {
        Class.forName("org.apache.logging.log4j.core.Logger");
    }

    @Override
    public Logger getLogger(Class<?> clazz) {
        try {
            return new Log4j2Logger(LogManager.getLogger(clazz));
        }
        catch (Throwable t) {
            LogLog.error("Failed to get Log4j2Logger", t);
            return new NopLogger();
        }
    }

    @Override
    public Logger getLogger(String name) {
        try {
            return new Log4j2Logger(LogManager.getLogger((String)name));
        }
        catch (Throwable t) {
            LogLog.error("Failed to get Log4j2Logger", t);
            return new NopLogger();
        }
    }
}

