/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.naming.pojo;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ServiceInfo {
    @JSONField(serialize=false)
    private String jsonFromServer = "";
    public static final String SPLITER = "@@";
    @JSONField(name="dom")
    private String name;
    private String clusters;
    private long cacheMillis = 1000L;
    @JSONField(name="hosts")
    private List<Instance> hosts = new ArrayList<Instance>();
    private long lastRefTime = 0L;
    private String checksum = "";
    private String env = "";
    private volatile boolean allIPs = false;
    private static final String EMPTY = "";
    private static final String ALL_IPS = "000--00-ALL_IPS--00--000";

    public ServiceInfo() {
    }

    public boolean isAllIPs() {
        return this.allIPs;
    }

    public void setAllIPs(boolean allIPs) {
        this.allIPs = allIPs;
    }

    public ServiceInfo(String key) {
        int maxKeySectionCount = 4;
        int allIpFlagIndex = 3;
        int envIndex = 2;
        int clusterIndex = 1;
        int serviceNameIndex = 0;
        String[] keys = key.split(SPLITER);
        if (keys.length >= maxKeySectionCount) {
            this.name = keys[serviceNameIndex];
            this.clusters = keys[clusterIndex];
            this.env = keys[envIndex];
            if (ServiceInfo.strEquals(keys[allIpFlagIndex], ALL_IPS)) {
                this.setAllIPs(true);
            }
        } else if (keys.length >= allIpFlagIndex) {
            this.name = keys[serviceNameIndex];
            this.clusters = keys[clusterIndex];
            if (ServiceInfo.strEquals(keys[envIndex], ALL_IPS)) {
                this.setAllIPs(true);
            } else {
                this.env = keys[envIndex];
            }
        } else if (keys.length >= envIndex) {
            this.name = keys[serviceNameIndex];
            if (ServiceInfo.strEquals(keys[clusterIndex], ALL_IPS)) {
                this.setAllIPs(true);
            } else {
                this.clusters = keys[clusterIndex];
            }
        }
        this.name = keys[0];
    }

    public ServiceInfo(String name, String clusters) {
        this(name, clusters, EMPTY);
    }

    public ServiceInfo(String name, String clusters, String env) {
        this.name = name;
        this.clusters = clusters;
        this.env = env;
    }

    public int ipCount() {
        return this.hosts.size();
    }

    public boolean expired() {
        return System.currentTimeMillis() - this.lastRefTime > this.cacheMillis;
    }

    public void setHosts(List<Instance> hosts) {
        this.hosts = hosts;
    }

    public boolean isValid() {
        return this.hosts != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLastRefTime(long lastRefTime) {
        this.lastRefTime = lastRefTime;
    }

    public long getLastRefTime() {
        return this.lastRefTime;
    }

    public String getClusters() {
        return this.clusters;
    }

    public void setClusters(String clusters) {
        this.clusters = clusters;
    }

    public long getCacheMillis() {
        return this.cacheMillis;
    }

    public void setCacheMillis(long cacheMillis) {
        this.cacheMillis = cacheMillis;
    }

    public List<Instance> getHosts() {
        return new ArrayList<Instance>(this.hosts);
    }

    public boolean validate() {
        if (this.isAllIPs()) {
            return true;
        }
        ArrayList<Instance> validHosts = new ArrayList<Instance>();
        for (Instance host : this.hosts) {
            if (!host.isHealthy()) continue;
            int i = 0;
            while ((double)i < host.getWeight()) {
                validHosts.add(host);
                ++i;
            }
        }
        return true;
    }

    @JSONField(serialize=false)
    public String getJsonFromServer() {
        return this.jsonFromServer;
    }

    public void setJsonFromServer(String jsonFromServer) {
        this.jsonFromServer = jsonFromServer;
    }

    @JSONField(serialize=false)
    public String getKey() {
        return ServiceInfo.getKey(this.name, this.clusters, this.env, this.isAllIPs());
    }

    @JSONField(serialize=false)
    public String getKeyEncoded() {
        try {
            return ServiceInfo.getKey(URLEncoder.encode(this.name, "UTF-8"), this.clusters, this.env, this.isAllIPs());
        }
        catch (UnsupportedEncodingException e) {
            return this.getKey();
        }
    }

    @JSONField(serialize=false)
    public static String getKey(String name, String clusters, String unit) {
        return ServiceInfo.getKey(name, clusters, unit, false);
    }

    @JSONField(serialize=false)
    public static String getKey(String name, String clusters, String unit, boolean isAllIPs) {
        if (ServiceInfo.isEmpty(unit)) {
            unit = EMPTY;
        }
        if (!ServiceInfo.isEmpty(clusters) && !ServiceInfo.isEmpty(unit)) {
            return isAllIPs ? name + SPLITER + clusters + SPLITER + unit + SPLITER + ALL_IPS : name + SPLITER + clusters + SPLITER + unit;
        }
        if (!ServiceInfo.isEmpty(clusters)) {
            return isAllIPs ? name + SPLITER + clusters + SPLITER + ALL_IPS : name + SPLITER + clusters;
        }
        if (!ServiceInfo.isEmpty(unit)) {
            return isAllIPs ? name + SPLITER + EMPTY + SPLITER + unit + SPLITER + ALL_IPS : name + SPLITER + EMPTY + SPLITER + unit;
        }
        return isAllIPs ? name + SPLITER + ALL_IPS : name;
    }

    public String toString() {
        return this.getKey();
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private static boolean strEquals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    private static boolean isEmpty(Collection coll) {
        return coll == null || coll.isEmpty();
    }
}

