/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.common.domain.result;

import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.remoting.protocol.RemotingSerializable;

public enum ResultCode implements Constants
{
    SUCCESS(true, 100, "success"),
    FAILURE(false, 101, "failure"),
    NO_SUCH_METHOD(false, 102, "no such method"),
    SC_FAIL_INVALID_TIMESTAMP(false, 103, "\u9274\u6743\u5931\u8d25\uff0c\u65e0\u6548\u7684\u65f6\u95f4\u6233"),
    SC_FAIL_INVALID_SIGN(false, 104, "\u9274\u6743\u5931\u8d25\uff0c\u65e0\u6548\u7684\u7b7e\u540d"),
    SC_FAIL_NO_PERMISSION(false, 105, "\u9274\u6743\u5931\u8d25\uff0c\u6ca1\u6709\u8d44\u6e90\u8bbf\u95ee\u6743\u9650"),
    CLIENT_VERSION_ERROR(false, 106, "\u9274\u6743\u5931\u8d25\uff0c\u5ba2\u6237\u7aef\u7248\u672c\u9519\u8bef"),
    TIMEOUT(false, 201, "timeout"),
    SERVER_ERROR(false, 202, "TMQ server error"),
    HALF_MESSAGE_ERROR(false, 203, "half message send error"),
    UNKNOW_TRANSACTION_STATUS_ERROR(false, 204, "unknow transaction status error"),
    TRANSACTION_ROLLBACK_ERROR(false, 205, "transaction rollback"),
    CONFIRM_MESSAGE_TIMEOUT(false, 206, "confirm message timeout, waiting check"),
    CONFIRM_MESSAGE_ERROR(false, 207, "confirm message error, waiting check"),
    UPDATE_MESSAGE_TIMEOUT(false, 208, "update message timeout"),
    DELETE_MESSAGE_TIMEOUT(false, 209, "delete message timeout"),
    MESSAGE_FIRE_TIME_NULL_ERROR(false, 301, "fireTime can not be empty"),
    MESSAGE_TOPIC_NULL_ERROR(false, 302, "topic can not be empty"),
    MESSAGE_ID_NULL_ERROR(false, 303, "messageId can not be empty"),
    MESSAGE_BODY_NULL_ERROR(false, 304, "message body can not be empty"),
    MESSAGE_ID_DUPLICATE_ERROR(false, 305, "messageId duplicate"),
    SECQUENCE_DUPLICATE_ERROR(false, 306, "sequence duplicate"),
    STAGE_FIRE_TIME_NULL_ERROR(false, 307, "stage fireTime can not be empty"),
    STAGE_BODY_NULL_ERROR(false, 308, "stage body can not be empty"),
    STAGE_SECQUENCE_NULL_ERROR(false, 309, "stage sequence can not be empty"),
    MESSAGE_KEY_NULL_ERROR(false, 310, "messageKey can not be empty"),
    MESSAGE_NULL_ERROR(false, 311, "message can not be empty"),
    MESSAGE_ID_AND_KEY_NULL_ERROR(false, 312, "messageId and messageKey can not be both empty"),
    MESSAGE_LIST_EMPTY_ERROR(false, 313, "messageList can not be empty"),
    MESSAGE_CRON_EXPRESSION_NULL_ERROR(false, 314, "cronExpression can not be empty"),
    MESSAGE_TIME_BOTH_NULL_ERROR(false, 315, "cronExpression and fireTime can not be both empty"),
    MESSAGE_CRON_EXPRESSION_INVALID_ERROR(false, 316, "cronExpression is invalid"),
    MESSAGE_CRON_EXPRESSION_OBSOLETE_ERROR(false, 317, "cronExpression is obsolete"),
    MESSAGE_KEY_NOT_ALL_THE_SAME_ERROR(false, 318, "messageKey of message are not all the same in messageList"),
    MESSAGE_TOPIC_NOT_ALL_THE_SAME_ERROR(false, 319, "topic of message are not all the same in messageList"),
    MESSAGE_FIRE_TIME_AND_BODY_NULL_ERROR(false, 320, "body and fireTime can not be both empty"),
    MESSAGE_UNIT_ROUTE_NULL_ERROR(false, 321, "unitRoute can not be empty"),
    MESSAGE_TAG_NULL_ERROR(false, 322, "tag can not be empty"),
    MESSAGE_CLASS_ERROR(false, 323, "message must be CreateMessage or UpdateMessage or DeleteMessage"),
    MESSAGE_CLASS_NOT_ALL_THE_SAME_ERROR(false, 324, "class of message are not all the same in messageList"),
    MESSAGE_START_TIME_NULL_ERROR(false, 325, "startTime can not be empty"),
    MESSAGE_TOTAL_EXE_COUNT_ERROR(false, 326, "totalExeCount must bigger than -1"),
    MESSAGE_END_TIME_NULL_ERROR(false, 327, "endTime can not be empty"),
    MESSAGE_OLD_CLASS_ERROR(false, 328, "message can not be CreateMessage or UpdateMessage or DeleteMessage"),
    MESSAGE_ARGUMENTS_ERROR(false, 329, "too less arguments error"),
    MESSAGE_START_TIME_ERROR(false, 330, "startTime after endTime error"),
    MESSAGE_FIRE_TIME_ERROR(false, 331, "fireTime more than three years from now on"),
    CONSUME_EXCEPTION(false, 401, "consume exception"),
    CONSUME_RETURN_NULL_ERROR(false, 402, "consume return null"),
    CONSUMER_NULL_ERROR(false, 403, "consumer is null"),
    PRODUCER_NULL_ERROR(false, 404, "producer is null"),
    CHECK_EXCEPTION(false, 405, "check exception"),
    CHECK_RETURN_NULL_ERROR(false, 406, "check return null"),
    CHECKER_NULL_ERROR(false, 407, "localTransactionChecker is null"),
    LISTENER_NULL_ERROR(false, 408, "messageListener is null"),
    INSERT_EXCEPTION(false, 501, "internal db exception, insert"),
    INSERT_ERROR(false, 502, "insert db error"),
    UPDATE_EXCEPTION(false, 503, "internal db exception, update"),
    UPDATE_ERROR(false, 504, "update db error"),
    DELETE_EXCEPTION(false, 505, "internal db exception, delete"),
    DELETE_ERROR(false, 506, "delete db error"),
    DELETE_FIND_MESSAGE_ERROR(false, 507, "delete find message error"),
    DELETE_CAN_NOT_FIND_MESSAGE_ERROR(false, 508, "delete db can not find message error"),
    UPDATE_MESSAGE_NULL_ERROR(false, 509, "update can not find message error"),
    CONNECTION_PRODUCER_IS_NULL_ERROR(false, 601, "there is no producer config on console"),
    CONNECTION_RELATION_IS_NULL_ERROR(false, 602, "there is no publisher and subscriber relation config on console"),
    TOPIC_DUPLICATE_ERROR(false, 701, "topic duplicate"),
    PUBLISHER_DUPLICATE_ERROR(false, 702, "publisher duplicate"),
    SUBSCRIBER_DUPLICATE_ERROR(false, 703, "subscriber duplicate");

    private boolean success;
    private int code;
    private String information;

    private ResultCode(boolean success, int code, String information) {
        this.success = success;
        this.code = code;
        this.information = information;
    }

    public String toString() {
        return this.success + " " + this.code + " " + this.information;
    }

    public static ResultCode newInstance(String json) {
        return RemotingSerializable.fromJson(json, ResultCode.class);
    }

    public String toJsonString() {
        return RemotingSerializable.toJson(this, false);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getInformation() {
        return this.information;
    }

    public void setInformation(String information) {
        this.information = information;
    }
}

