/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.client.system.producer.implement;

import com.alibaba.tmq.client.TMQFactory;
import com.alibaba.tmq.client.remoting.ClientRemoting;
import com.alibaba.tmq.client.system.producer.TransactionProducer;
import com.alibaba.tmq.client.system.producer.config.ProducerConfig;
import com.alibaba.tmq.client.system.producer.executer.LocalTransactionExecuter;
import com.alibaba.tmq.client.system.producer.executer.ProducerExecuter;
import com.alibaba.tmq.client.system.producer.implement.DefaultProducer;
import com.alibaba.tmq.client.util.StringUtil;
import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.context.InvocationContext;
import com.alibaba.tmq.common.domain.KeyValuePair;
import com.alibaba.tmq.common.domain.Message;
import com.alibaba.tmq.common.domain.MessageStatus;
import com.alibaba.tmq.common.domain.MessageType;
import com.alibaba.tmq.common.domain.TransactionStatus;
import com.alibaba.tmq.common.domain.remoting.ConnectionChannel;
import com.alibaba.tmq.common.domain.result.Result;
import com.alibaba.tmq.common.domain.result.ResultCode;
import com.alibaba.tmq.common.domain.result.SendResult;
import com.alibaba.tmq.common.exception.TMQException;
import com.alibaba.tmq.common.service.ServerService;
import com.alibaba.tmq.common.util.MessageUtil;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultTransactionProducer
extends DefaultProducer
implements TransactionProducer,
Constants {
    private static final Log logger = LogFactory.getLog(DefaultTransactionProducer.class);
    private final ServerService serverService = ClientRemoting.proxyInterface(ServerService.class);
    private final ProducerConfig producerConfig;
    private final ProducerExecuter producerExecuter;

    public DefaultTransactionProducer(ProducerConfig producerConfig, ProducerExecuter producerExecuter) {
        super(producerConfig, producerExecuter);
        this.producerConfig = producerConfig;
        this.producerExecuter = producerExecuter;
    }

    @Override
    public SendResult send(Message message, LocalTransactionExecuter localTransactionExecuter, Object object) throws TMQException {
        if (StringUtil.isNotBlank(clientConfig.getBackupDomainName())) {
            MessageUtil.reset(message, clientConfig.getBackupClusterId());
        } else {
            MessageUtil.reset(message, clientConfig.getClusterId());
        }
        Result<Boolean> checkResult = MessageUtil.check4Send(message);
        if (!checkResult.getData().booleanValue()) {
            return new SendResult(checkResult);
        }
        KeyValuePair<String, Message> messageKeyValue = MessageUtil.renderingMessage(this.producerConfig.getProducerId(), message, MessageStatus.INITIALIZATION, MessageType.TRANSACTION_ONCE);
        String server = clientRemoting.acquireFireServer(message.getMessageKey());
        if (StringUtil.isBlank(server)) {
            return new SendResult((Boolean)false, ResultCode.SERVER_ERROR, messageKeyValue);
        }
        Result<Boolean> sendResult = null;
        try {
            InvocationContext.setConnectionChannel(new ConnectionChannel(server, 0, this.producerConfig.getProducerId()));
            sendResult = this.serverService.send(message);
        }
        catch (Throwable e) {
            logger.error((Object)("[DefaultTransactionProducer]: send message error, message:" + message), e);
        }
        if (null == sendResult) {
            return new SendResult((Boolean)false, ResultCode.HALF_MESSAGE_ERROR, messageKeyValue);
        }
        if (!sendResult.getData().booleanValue()) {
            return new SendResult((Boolean)false, sendResult.getResultCode(), messageKeyValue);
        }
        TransactionStatus transactionStatus = TransactionStatus.UnKnow;
        try {
            transactionStatus = localTransactionExecuter.execute(object);
        }
        catch (Throwable e) {
            logger.error((Object)("[DefaultTransactionProducer]: execute message error, message:" + message), e);
            transactionStatus = TransactionStatus.Rollback;
        }
        if (null == transactionStatus) {
            transactionStatus = TransactionStatus.UnKnow;
        }
        switch (transactionStatus) {
            case UnKnow: {
                return new SendResult((Boolean)false, ResultCode.UNKNOW_TRANSACTION_STATUS_ERROR, messageKeyValue);
            }
            case Commit: {
                MessageUtil.setMessageStatus(message, MessageStatus.READY_TO_FIRE);
                break;
            }
            case Rollback: {
                MessageUtil.setMessageStatus(message, MessageStatus.DISCARD);
                break;
            }
        }
        Result<Boolean> updateResult = null;
        try {
            InvocationContext.setConnectionChannel(new ConnectionChannel(server, 0, this.producerConfig.getProducerId()));
            updateResult = this.serverService.update(message);
        }
        catch (Throwable e) {
            logger.error((Object)("[DefaultTransactionProducer]: confirm message error, message:" + message), e);
        }
        if (null == updateResult) {
            return new SendResult((Boolean)false, ResultCode.CONFIRM_MESSAGE_TIMEOUT, messageKeyValue);
        }
        return new SendResult(updateResult, messageKeyValue);
    }

    @Override
    public SendResult send(List<Message> messageList, LocalTransactionExecuter localTransactionExecuter, Object object) throws TMQException {
        if (StringUtil.isNotBlank(clientConfig.getBackupDomainName())) {
            MessageUtil.reset(messageList, clientConfig.getBackupClusterId());
        } else {
            MessageUtil.reset(messageList, clientConfig.getClusterId());
        }
        Result<Boolean> checkResult = MessageUtil.check4Send(messageList);
        if (!checkResult.getData().booleanValue()) {
            return new SendResult(checkResult);
        }
        List<KeyValuePair<String, Message>> messageKeyValueList = MessageUtil.renderingMessage(this.producerConfig.getProducerId(), messageList, MessageStatus.READY_TO_FIRE, MessageType.TRANSACTION_ONCE);
        String server = clientRemoting.acquireFireServer(messageList.get(0).getMessageKey());
        if (StringUtil.isBlank(server)) {
            return new SendResult((Boolean)false, ResultCode.SERVER_ERROR, messageKeyValueList);
        }
        Result<Boolean> sendResult = null;
        try {
            InvocationContext.setConnectionChannel(new ConnectionChannel(server, 0, this.producerConfig.getProducerId()));
            sendResult = this.serverService.send(messageList);
        }
        catch (Throwable e) {
            logger.error((Object)("[DefaultTransactionProducer]: send message error, messageList:" + messageList), e);
        }
        if (null == sendResult) {
            return new SendResult((Boolean)false, ResultCode.HALF_MESSAGE_ERROR, messageKeyValueList);
        }
        if (!sendResult.getData().booleanValue()) {
            return new SendResult((Boolean)false, sendResult.getResultCode(), messageKeyValueList);
        }
        TransactionStatus transactionStatus = TransactionStatus.UnKnow;
        try {
            transactionStatus = localTransactionExecuter.execute(object);
        }
        catch (Throwable e) {
            logger.error((Object)("[DefaultTransactionProducer]: execute message error, messageList:" + messageList), e);
            transactionStatus = TransactionStatus.Rollback;
        }
        if (null == transactionStatus) {
            transactionStatus = TransactionStatus.UnKnow;
        }
        switch (transactionStatus) {
            case UnKnow: {
                return new SendResult((Boolean)false, ResultCode.UNKNOW_TRANSACTION_STATUS_ERROR, messageKeyValueList);
            }
            case Commit: {
                MessageUtil.setMessageStatus(messageList, MessageStatus.READY_TO_FIRE);
                break;
            }
            case Rollback: {
                MessageUtil.setMessageStatus(messageList, MessageStatus.DISCARD);
                break;
            }
        }
        Result<Boolean> updateResult = null;
        try {
            InvocationContext.setConnectionChannel(new ConnectionChannel(server, 0, this.producerConfig.getProducerId()));
            updateResult = this.serverService.update(messageList);
        }
        catch (Throwable e) {
            logger.error((Object)("[DefaultTransactionProducer]: confirm message error, messageList:" + messageList), e);
        }
        if (null == updateResult) {
            return new SendResult((Boolean)false, ResultCode.CONFIRM_MESSAGE_TIMEOUT, messageKeyValueList);
        }
        return new SendResult(updateResult, messageKeyValueList);
    }

    @Override
    public void shutdown() {
        TMQFactory.removeTransactionProducer(this.producerConfig.getProducerId(), null);
    }
}

