/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.value;

import com.alibaba.dts.shade.org.h2.engine.Constants;
import com.alibaba.dts.shade.org.h2.engine.SysProperties;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.mvstore.DataUtils;
import com.alibaba.dts.shade.org.h2.store.DataHandler;
import com.alibaba.dts.shade.org.h2.store.FileStore;
import com.alibaba.dts.shade.org.h2.store.FileStoreInputStream;
import com.alibaba.dts.shade.org.h2.store.FileStoreOutputStream;
import com.alibaba.dts.shade.org.h2.store.fs.FileUtils;
import com.alibaba.dts.shade.org.h2.util.IOUtils;
import com.alibaba.dts.shade.org.h2.util.MathUtils;
import com.alibaba.dts.shade.org.h2.util.SmallLRUCache;
import com.alibaba.dts.shade.org.h2.util.StringUtils;
import com.alibaba.dts.shade.org.h2.util.Utils;
import com.alibaba.dts.shade.org.h2.value.CompareMode;
import com.alibaba.dts.shade.org.h2.value.Value;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ValueLob
extends Value {
    private static int dirCounter;
    private final int type;
    private long precision;
    private DataHandler handler;
    private int tableId;
    private int objectId;
    private String fileName;
    private boolean linked;
    private byte[] small;
    private int hash;
    private boolean compressed;
    private FileStore tempFile;

    private ValueLob(int type, DataHandler handler, String fileName, int tableId, int objectId, boolean linked, long precision, boolean compressed) {
        this.type = type;
        this.handler = handler;
        this.fileName = fileName;
        this.tableId = tableId;
        this.objectId = objectId;
        this.linked = linked;
        this.precision = precision;
        this.compressed = compressed;
    }

    private ValueLob(int type, byte[] small) {
        this.type = type;
        this.small = small;
        if (small != null) {
            this.precision = type == 15 ? (long)small.length : (long)this.getString().length();
        }
    }

    private static ValueLob copy(ValueLob lob) {
        ValueLob copy = new ValueLob(lob.type, lob.handler, lob.fileName, lob.tableId, lob.objectId, lob.linked, lob.precision, lob.compressed);
        copy.small = lob.small;
        copy.hash = lob.hash;
        return copy;
    }

    private static ValueLob createSmallLob(int type, byte[] small) {
        return new ValueLob(type, small);
    }

    private static String getFileName(DataHandler handler, int tableId, int objectId) {
        if (SysProperties.CHECK && tableId == 0 && objectId == 0) {
            DbException.throwInternalError("0 LOB");
        }
        String table = tableId < 0 ? ".temp" : ".t" + tableId;
        return ValueLob.getFileNamePrefix(handler.getDatabasePath(), objectId) + table + ".lob.db";
    }

    public static ValueLob openLinked(int type, DataHandler handler, int tableId, int objectId, long precision, boolean compression) {
        String fileName = ValueLob.getFileName(handler, tableId, objectId);
        return new ValueLob(type, handler, fileName, tableId, objectId, true, precision, compression);
    }

    public static ValueLob openUnlinked(int type, DataHandler handler, int tableId, int objectId, long precision, boolean compression, String fileName) {
        return new ValueLob(type, handler, fileName, tableId, objectId, false, precision, compression);
    }

    private static ValueLob createClob(Reader in, long length, DataHandler handler) {
        try {
            char[] buff;
            int len;
            if (handler == null) {
                String s = IOUtils.readStringAndClose(in, (int)length);
                return ValueLob.createSmallLob(16, s.getBytes(Constants.UTF8));
            }
            boolean compress = handler.getLobCompressionAlgorithm(16) != null;
            long remaining = Long.MAX_VALUE;
            if (length >= 0L && length < remaining) {
                remaining = length;
            }
            if ((len = ValueLob.getBufferSize(handler, compress, remaining)) >= Integer.MAX_VALUE) {
                String data = IOUtils.readStringAndClose(in, -1);
                buff = data.toCharArray();
                len = buff.length;
            } else {
                buff = new char[len];
                len = IOUtils.readFully(in, buff, len);
            }
            if (len <= handler.getMaxLengthInplaceLob()) {
                byte[] small = new String(buff, 0, len).getBytes(Constants.UTF8);
                return ValueLob.createSmallLob(16, small);
            }
            ValueLob lob = new ValueLob(16, null);
            lob.createFromReader(buff, len, in, remaining, handler);
            return lob;
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    private static int getBufferSize(DataHandler handler, boolean compress, long remaining) {
        long m;
        if (remaining < 0L || remaining > Integer.MAX_VALUE) {
            remaining = Integer.MAX_VALUE;
        }
        int inplace = handler.getMaxLengthInplaceLob();
        long l = m = compress ? 131072L : 4096L;
        if (m < remaining && m <= (long)inplace) {
            m = Math.min(remaining, (long)inplace + 1L);
            m = MathUtils.roundUpLong(m, 4096L);
        }
        m = Math.min(remaining, m);
        if ((m = (long)MathUtils.convertLongToInt(m)) < 0L) {
            m = Integer.MAX_VALUE;
        }
        return (int)m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFromReader(char[] buff, int len, Reader in, long remaining, DataHandler h) throws IOException {
        FileStoreOutputStream out = this.initLarge(h);
        boolean compress = h.getLobCompressionAlgorithm(16) != null;
        try {
            do {
                this.precision += (long)len;
                byte[] b = new String(buff, 0, len).getBytes(Constants.UTF8);
                out.write(b, 0, b.length);
                if ((remaining -= (long)len) <= 0L) {
                    break;
                }
                len = ValueLob.getBufferSize(h, compress, remaining);
            } while ((len = IOUtils.readFully(in, buff, len)) != 0);
        }
        finally {
            out.close();
        }
    }

    private static String getFileNamePrefix(String path, int objectId) {
        int f = objectId % SysProperties.LOB_FILES_PER_DIRECTORY;
        String name = f > 0 ? SysProperties.FILE_SEPARATOR + objectId : "";
        objectId /= SysProperties.LOB_FILES_PER_DIRECTORY;
        while (objectId > 0) {
            f = objectId % SysProperties.LOB_FILES_PER_DIRECTORY;
            name = SysProperties.FILE_SEPARATOR + f + ".lobs.db" + name;
            objectId /= SysProperties.LOB_FILES_PER_DIRECTORY;
        }
        name = FileUtils.toRealPath(path + ".lobs.db" + name);
        return name;
    }

    private static int getNewObjectId(DataHandler h) {
        int fileId;
        String dir;
        String path = h.getDatabasePath();
        if (path != null && path.length() == 0) {
            path = new File(Utils.getProperty("java.io.tmpdir", "."), SysProperties.PREFIX_TEMP_FILE).getAbsolutePath();
        }
        int newId = 0;
        int lobsPerDir = SysProperties.LOB_FILES_PER_DIRECTORY;
        while (true) {
            dir = ValueLob.getFileNamePrefix(path, newId);
            String[] list = ValueLob.getFileList(h, dir);
            int fileCount = 0;
            boolean[] used = new boolean[lobsPerDir];
            for (String name : list) {
                int id;
                if (!name.endsWith(".db")) continue;
                name = FileUtils.getName(name);
                String n = name.substring(0, name.indexOf(46));
                try {
                    id = Integer.parseInt(n);
                }
                catch (NumberFormatException e) {
                    id = -1;
                }
                if (id <= 0) continue;
                ++fileCount;
                used[id % lobsPerDir] = true;
            }
            fileId = -1;
            if (fileCount < lobsPerDir) {
                for (int i = 1; i < lobsPerDir; ++i) {
                    if (used[i]) continue;
                    fileId = i;
                    break;
                }
            }
            if (fileId > 0) break;
            if (newId > Integer.MAX_VALUE / lobsPerDir) {
                newId = 0;
                dirCounter = MathUtils.randomInt(lobsPerDir - 1) * lobsPerDir;
                continue;
            }
            int dirId = dirCounter++ / (lobsPerDir - 1) + 1;
            newId *= lobsPerDir;
            newId += dirId * lobsPerDir;
        }
        ValueLob.invalidateFileList(h, dir);
        return newId += fileId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invalidateFileList(DataHandler h, String dir) {
        SmallLRUCache<String, String[]> cache = h.getLobFileListCache();
        if (cache != null) {
            SmallLRUCache<String, String[]> smallLRUCache = cache;
            synchronized (smallLRUCache) {
                cache.remove(dir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getFileList(DataHandler h, String dir) {
        String[] list;
        SmallLRUCache<String, String[]> cache = h.getLobFileListCache();
        if (cache == null) {
            list = FileUtils.newDirectoryStream(dir).toArray(new String[0]);
        } else {
            SmallLRUCache<String, String[]> smallLRUCache = cache;
            synchronized (smallLRUCache) {
                list = (String[])cache.get(dir);
                if (list == null) {
                    list = FileUtils.newDirectoryStream(dir).toArray(new String[0]);
                    cache.put(dir, list);
                }
            }
        }
        return list;
    }

    private static ValueLob createBlob(InputStream in, long length, DataHandler handler) {
        try {
            byte[] buff;
            int len;
            boolean compress;
            if (handler == null) {
                byte[] data = IOUtils.readBytesAndClose(in, (int)length);
                return ValueLob.createSmallLob(15, data);
            }
            long remaining = Long.MAX_VALUE;
            boolean bl = compress = handler.getLobCompressionAlgorithm(15) != null;
            if (length >= 0L && length < remaining) {
                remaining = length;
            }
            if ((len = ValueLob.getBufferSize(handler, compress, remaining)) >= Integer.MAX_VALUE) {
                buff = IOUtils.readBytesAndClose(in, -1);
                len = buff.length;
            } else {
                buff = DataUtils.newBytes(len);
                len = IOUtils.readFully(in, buff, len);
            }
            if (len <= handler.getMaxLengthInplaceLob()) {
                byte[] small = DataUtils.newBytes(len);
                System.arraycopy(buff, 0, small, 0, len);
                return ValueLob.createSmallLob(15, small);
            }
            ValueLob lob = new ValueLob(15, null);
            lob.createFromStream(buff, len, in, remaining, handler);
            return lob;
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileStoreOutputStream initLarge(DataHandler h) {
        this.handler = h;
        this.tableId = 0;
        this.linked = false;
        this.precision = 0L;
        this.small = null;
        this.hash = 0;
        String compressionAlgorithm = h.getLobCompressionAlgorithm(this.type);
        this.compressed = compressionAlgorithm != null;
        DataHandler dataHandler = h;
        synchronized (dataHandler) {
            String path = h.getDatabasePath();
            if (path != null && path.length() == 0) {
                path = new File(Utils.getProperty("java.io.tmpdir", "."), SysProperties.PREFIX_TEMP_FILE).getAbsolutePath();
            }
            this.objectId = ValueLob.getNewObjectId(h);
            this.fileName = ValueLob.getFileNamePrefix(path, this.objectId) + ".temp.db";
            this.tempFile = h.openFile(this.fileName, "rw", false);
            this.tempFile.autoDelete();
        }
        FileStoreOutputStream out = new FileStoreOutputStream(this.tempFile, h, compressionAlgorithm);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFromStream(byte[] buff, int len, InputStream in, long remaining, DataHandler h) throws IOException {
        FileStoreOutputStream out = this.initLarge(h);
        boolean compress = h.getLobCompressionAlgorithm(15) != null;
        try {
            do {
                this.precision += (long)len;
                out.write(buff, 0, len);
                if ((remaining -= (long)len) <= 0L) {
                    break;
                }
                len = ValueLob.getBufferSize(h, compress, remaining);
            } while ((len = IOUtils.readFully(in, buff, len)) > 0);
        }
        finally {
            out.close();
        }
    }

    @Override
    public Value convertTo(int t) {
        if (t == this.type) {
            return this;
        }
        if (t == 16) {
            ValueLob copy = ValueLob.createClob(this.getReader(), -1L, this.handler);
            return copy;
        }
        if (t == 15) {
            ValueLob copy = ValueLob.createBlob(this.getInputStream(), -1L, this.handler);
            return copy;
        }
        return super.convertTo(t);
    }

    @Override
    public boolean isLinkedToTable() {
        return this.linked;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void remove() {
        if (this.fileName != null) {
            if (this.tempFile != null) {
                this.tempFile.stopAutoDelete();
                this.tempFile = null;
            }
            ValueLob.deleteFile(this.handler, this.fileName);
        }
    }

    @Override
    public Value copy(DataHandler h, int tabId) {
        if (this.fileName == null) {
            this.tableId = tabId;
            return this;
        }
        if (this.linked) {
            ValueLob copy = ValueLob.copy(this);
            copy.objectId = ValueLob.getNewObjectId(h);
            copy.tableId = tabId;
            String live = ValueLob.getFileName(h, copy.tableId, copy.objectId);
            ValueLob.copyFileTo(h, this.fileName, live);
            copy.fileName = live;
            copy.linked = true;
            return copy;
        }
        if (!this.linked) {
            this.tableId = tabId;
            String live = ValueLob.getFileName(h, this.tableId, this.objectId);
            if (this.tempFile != null) {
                this.tempFile.stopAutoDelete();
                this.tempFile = null;
            }
            ValueLob.renameFile(h, this.fileName, live);
            this.fileName = live;
            this.linked = true;
        }
        return this;
    }

    @Override
    public int getTableId() {
        return this.tableId;
    }

    public int getObjectId() {
        return this.objectId;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public long getPrecision() {
        return this.precision;
    }

    @Override
    public String getString() {
        int len = this.precision > Integer.MAX_VALUE || this.precision == 0L ? Integer.MAX_VALUE : (int)this.precision;
        try {
            if (this.type == 16) {
                if (this.small != null) {
                    return new String(this.small, Constants.UTF8);
                }
                return IOUtils.readStringAndClose(this.getReader(), len);
            }
            byte[] buff = this.small != null ? this.small : IOUtils.readBytesAndClose(this.getInputStream(), len);
            return StringUtils.convertBytesToHex(buff);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.fileName);
        }
    }

    @Override
    public byte[] getBytes() {
        if (this.type == 16) {
            return super.getBytes();
        }
        byte[] data = this.getBytesNoCopy();
        return Utils.cloneByteArray(data);
    }

    @Override
    public byte[] getBytesNoCopy() {
        if (this.type == 16) {
            return super.getBytesNoCopy();
        }
        if (this.small != null) {
            return this.small;
        }
        try {
            return IOUtils.readBytesAndClose(this.getInputStream(), Integer.MAX_VALUE);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.fileName);
        }
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            if (this.precision > 4096L) {
                return (int)(this.precision ^ this.precision >>> 32);
            }
            this.hash = this.type == 16 ? this.getString().hashCode() : Utils.getByteArrayHash(this.getBytes());
        }
        return this.hash;
    }

    @Override
    protected int compareSecure(Value v, CompareMode mode) {
        if (this.type == 16) {
            return Integer.signum(this.getString().compareTo(v.getString()));
        }
        byte[] v2 = v.getBytesNoCopy();
        return Utils.compareNotNullSigned(this.getBytes(), v2);
    }

    @Override
    public Object getObject() {
        if (this.type == 16) {
            return this.getReader();
        }
        return this.getInputStream();
    }

    @Override
    public Reader getReader() {
        return IOUtils.getBufferedReader(this.getInputStream());
    }

    @Override
    public InputStream getInputStream() {
        if (this.fileName == null) {
            return new ByteArrayInputStream(this.small);
        }
        FileStore store = this.handler.openFile(this.fileName, "r", true);
        boolean alwaysClose = SysProperties.lobCloseBetweenReads;
        return new BufferedInputStream(new FileStoreInputStream(store, this.handler, this.compressed, alwaysClose), 4096);
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        long p = this.getPrecision();
        if (p > Integer.MAX_VALUE || p <= 0L) {
            p = -1L;
        }
        if (this.type == 15) {
            prep.setBinaryStream(parameterIndex, this.getInputStream(), (int)p);
        } else {
            prep.setCharacterStream(parameterIndex, this.getReader(), (int)p);
        }
    }

    @Override
    public String getSQL() {
        if (this.type == 16) {
            String s = this.getString();
            return StringUtils.quoteStringSQL(s);
        }
        byte[] buff = this.getBytes();
        String s = StringUtils.convertBytesToHex(buff);
        return "X'" + s + "'";
    }

    @Override
    public String getTraceSQL() {
        if (this.small != null && this.getPrecision() <= SysProperties.MAX_TRACE_DATA_LENGTH) {
            return this.getSQL();
        }
        StringBuilder buff = new StringBuilder();
        if (this.type == 16) {
            buff.append("SPACE(").append(this.getPrecision());
        } else {
            buff.append("CAST(REPEAT('00', ").append(this.getPrecision()).append(") AS BINARY");
        }
        buff.append(" /* ").append(this.fileName).append(" */)");
        return buff.toString();
    }

    @Override
    public byte[] getSmall() {
        return this.small;
    }

    @Override
    public int getDisplaySize() {
        return MathUtils.convertLongToInt(this.getPrecision());
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueLob && this.compareSecure((Value)other, null) == 0;
    }

    public void convertToFileIfRequired(DataHandler h) {
        try {
            if (this.small != null && this.small.length > h.getMaxLengthInplaceLob()) {
                boolean compress = h.getLobCompressionAlgorithm(this.type) != null;
                int len = ValueLob.getBufferSize(h, compress, Long.MAX_VALUE);
                int tabId = this.tableId;
                if (this.type == 15) {
                    this.createFromStream(DataUtils.newBytes(len), 0, this.getInputStream(), Long.MAX_VALUE, h);
                } else {
                    this.createFromReader(new char[len], 0, this.getReader(), Long.MAX_VALUE, h);
                }
                Value v2 = this.copy(h, tabId);
                if (SysProperties.CHECK && v2 != this) {
                    DbException.throwInternalError();
                }
            }
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void deleteFile(DataHandler handler, String fileName) {
        Object object = handler.getLobSyncObject();
        synchronized (object) {
            FileUtils.delete(fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void renameFile(DataHandler handler, String oldName, String newName) {
        Object object = handler.getLobSyncObject();
        synchronized (object) {
            FileUtils.move(oldName, newName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileTo(DataHandler h, String sourceFileName, String targetFileName) {
        Object object = h.getLobSyncObject();
        synchronized (object) {
            try {
                IOUtils.copyFiles(sourceFileName, targetFileName);
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, null);
            }
        }
    }

    @Override
    public int getMemory() {
        if (this.small != null) {
            return this.small.length + 104;
        }
        return 140;
    }

    @Override
    public ValueLob copyToTemp() {
        ValueLob lob = this.type == 16 ? ValueLob.createClob(this.getReader(), this.precision, this.handler) : ValueLob.createBlob(this.getInputStream(), this.precision, this.handler);
        return lob;
    }

    @Override
    public Value convertPrecision(long precision, boolean force) {
        if (this.precision <= precision) {
            return this;
        }
        ValueLob lob = this.type == 16 ? ValueLob.createClob(this.getReader(), precision, this.handler) : ValueLob.createBlob(this.getInputStream(), precision, this.handler);
        return lob;
    }
}

