/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.value;

import com.alibaba.dts.shade.org.h2.value.CompareMode;
import com.alibaba.dts.shade.org.h2.value.Value;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ValueBoolean
extends Value {
    public static final int PRECISION = 1;
    public static final int DISPLAY_SIZE = 5;
    private static final Object TRUE = new ValueBoolean(true);
    private static final Object FALSE = new ValueBoolean(false);
    private final Boolean value;

    private ValueBoolean(boolean value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getSQL() {
        return this.getString();
    }

    @Override
    public String getString() {
        return this.value != false ? "TRUE" : "FALSE";
    }

    @Override
    public Value negate() {
        return (ValueBoolean)(this.value != false ? FALSE : TRUE);
    }

    @Override
    public Boolean getBoolean() {
        return this.value;
    }

    @Override
    protected int compareSecure(Value o, CompareMode mode) {
        boolean v2 = ((ValueBoolean)o).value;
        boolean v = this.value;
        return v == v2 ? 0 : (v ? 1 : -1);
    }

    @Override
    public long getPrecision() {
        return 1L;
    }

    @Override
    public int hashCode() {
        return this.value != false ? 1 : 0;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setBoolean(parameterIndex, this.value);
    }

    public static ValueBoolean get(boolean b) {
        return (ValueBoolean)(b ? TRUE : FALSE);
    }

    @Override
    public int getDisplaySize() {
        return 5;
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }
}

