/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.store;

import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.store.InDoubtTransaction;
import com.alibaba.dts.shade.org.h2.store.PageStore;

public class PageStoreInDoubtTransaction
implements InDoubtTransaction {
    private final PageStore store;
    private final int sessionId;
    private final int pos;
    private final String transactionName;
    private int state;

    public PageStoreInDoubtTransaction(PageStore store, int sessionId, int pos, String transaction) {
        this.store = store;
        this.sessionId = sessionId;
        this.pos = pos;
        this.transactionName = transaction;
        this.state = 0;
    }

    @Override
    public void setState(int state) {
        switch (state) {
            case 1: {
                this.store.setInDoubtTransactionState(this.sessionId, this.pos, true);
                break;
            }
            case 2: {
                this.store.setInDoubtTransactionState(this.sessionId, this.pos, false);
                break;
            }
            default: {
                DbException.throwInternalError("state=" + state);
            }
        }
        this.state = state;
    }

    @Override
    public String getState() {
        switch (this.state) {
            case 0: {
                return "IN_DOUBT";
            }
            case 1: {
                return "COMMIT";
            }
            case 2: {
                return "ROLLBACK";
            }
        }
        throw DbException.throwInternalError("state=" + this.state);
    }

    @Override
    public String getTransactionName() {
        return this.transactionName;
    }
}

