/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.mvstore.db;

import com.alibaba.dts.shade.org.h2.engine.Database;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.index.BaseIndex;
import com.alibaba.dts.shade.org.h2.index.Cursor;
import com.alibaba.dts.shade.org.h2.index.IndexType;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.mvstore.DataUtils;
import com.alibaba.dts.shade.org.h2.mvstore.db.MVTable;
import com.alibaba.dts.shade.org.h2.mvstore.db.TransactionStore;
import com.alibaba.dts.shade.org.h2.mvstore.db.ValueDataType;
import com.alibaba.dts.shade.org.h2.result.Row;
import com.alibaba.dts.shade.org.h2.result.SearchRow;
import com.alibaba.dts.shade.org.h2.result.SortOrder;
import com.alibaba.dts.shade.org.h2.table.Column;
import com.alibaba.dts.shade.org.h2.table.IndexColumn;
import com.alibaba.dts.shade.org.h2.table.TableFilter;
import com.alibaba.dts.shade.org.h2.value.Value;
import com.alibaba.dts.shade.org.h2.value.ValueArray;
import com.alibaba.dts.shade.org.h2.value.ValueLong;
import com.alibaba.dts.shade.org.h2.value.ValueNull;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MVPrimaryIndex
extends BaseIndex {
    static final ValueLong MIN = ValueLong.get(Long.MIN_VALUE);
    static final ValueLong MAX = ValueLong.get(Long.MAX_VALUE);
    static final ValueLong ZERO = ValueLong.get(0L);
    private final MVTable mvTable;
    private final String mapName;
    private TransactionStore.TransactionMap<Value, Value> dataMap;
    private long lastKey;
    private int mainIndexColumn = -1;

    public MVPrimaryIndex(Database db, MVTable table, int id, IndexColumn[] columns, IndexType indexType) {
        Value k;
        this.mvTable = table;
        this.initBaseIndex(table, id, table.getName() + "_DATA", columns, indexType);
        int[] sortTypes = new int[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            sortTypes[i] = 0;
        }
        ValueDataType keyType = new ValueDataType(null, null, null);
        ValueDataType valueType = new ValueDataType(db.getCompareMode(), db, sortTypes);
        this.mapName = "table." + this.getId();
        TransactionStore.Transaction t = this.mvTable.getTransaction(null);
        this.dataMap = t.openMap(this.mapName, keyType, valueType);
        t.commit();
        if (!table.isPersistData()) {
            this.dataMap.map.setVolatile(true);
        }
        this.lastKey = (k = this.dataMap.lastKey()) == null ? 0L : k.getLong();
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public String getPlanSQL() {
        return this.table.getSQL() + ".tableScan";
    }

    public void setMainIndexColumn(int mainIndexColumn) {
        this.mainIndexColumn = mainIndexColumn;
    }

    public int getMainIndexColumn() {
        return this.mainIndexColumn;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        ValueLong key;
        TransactionStore.TransactionMap<Value, Value> map;
        Value old;
        if (this.mainIndexColumn == -1) {
            if (row.getKey() == 0L) {
                row.setKey(++this.lastKey);
            }
        } else {
            long c = row.getValue(this.mainIndexColumn).getLong();
            row.setKey(c);
        }
        if (this.mvTable.getContainsLargeObject()) {
            int len = row.getColumnCount();
            for (int i = 0; i < len; ++i) {
                Value v = row.getValue(i);
                Value v2 = v.copy(this.database, this.getId());
                if (v2.isLinkedToTable()) {
                    session.removeAtCommitStop(v2);
                }
                if (v == v2) continue;
                row.setValue(i, v2);
            }
        }
        if ((old = (map = this.getMap(session)).getLatest(key = ValueLong.get(row.getKey()))) != null) {
            String sql = "PRIMARY KEY ON " + this.table.getSQL();
            if (this.mainIndexColumn >= 0 && this.mainIndexColumn < this.indexColumns.length) {
                sql = sql + "(" + this.indexColumns[this.mainIndexColumn].getSQL() + ")";
                sql = sql + " VALUES '" + key.toString() + "'";
            }
            DbException e = DbException.get(23505, sql);
            e.setSource(this);
            throw e;
        }
        try {
            map.put(key, ValueArray.get(row.getValueList()));
        }
        catch (IllegalStateException e) {
            throw this.mvTable.convertException(e);
        }
        this.lastKey = Math.max(this.lastKey, row.getKey());
    }

    @Override
    public void remove(Session session, Row row) {
        if (this.mvTable.getContainsLargeObject()) {
            int len = row.getColumnCount();
            for (int i = 0; i < len; ++i) {
                Value v = row.getValue(i);
                if (!v.isLinkedToTable()) continue;
                session.removeAtCommit(v);
            }
        }
        TransactionStore.TransactionMap<Value, Value> map = this.getMap(session);
        try {
            Value old = map.remove(ValueLong.get(row.getKey()));
            if (old == null) {
                throw DbException.get(90112, this.getSQL() + ": " + row.getKey());
            }
        }
        catch (IllegalStateException e) {
            throw this.mvTable.convertException(e);
        }
    }

    @Override
    public void replace(Session session, Row oldRow, Row newRow) {
        TransactionStore.TransactionMap<Value, Value> map = this.getMap(session);
        ValueLong key = ValueLong.get(oldRow.getKey());
        try {
            map.replace(key, ValueArray.get(oldRow.getValueList()), ValueArray.get(newRow.getValueList()));
        }
        catch (IllegalStateException e) {
            throw this.mvTable.convertException(e);
        }
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        ValueLong v;
        ValueLong min = first == null ? MIN : (this.mainIndexColumn < 0 ? ValueLong.get(first.getKey()) : ((v = (ValueLong)first.getValue(this.mainIndexColumn)) == null ? ValueLong.get(first.getKey()) : v));
        ValueLong max = last == null ? MAX : (this.mainIndexColumn < 0 ? ValueLong.get(last.getKey()) : ((v = (ValueLong)last.getValue(this.mainIndexColumn)) == null ? ValueLong.get(last.getKey()) : v));
        TransactionStore.TransactionMap<Value, Value> map = this.getMap(session);
        return new MVStoreCursor(map.entryIterator(min), max);
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public Row getRow(Session session, long key) {
        TransactionStore.TransactionMap<Value, Value> map = this.getMap(session);
        Value v = map.get(ValueLong.get(key));
        ValueArray array = (ValueArray)v;
        Row row = new Row(array.getList(), 0);
        row.setKey(key);
        return row;
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter filter, SortOrder sortOrder) {
        try {
            long cost = 10L * (this.dataMap.sizeAsLongMax() + 1000L);
            return cost;
        }
        catch (IllegalStateException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public int getColumnIndex(Column col) {
        return -1;
    }

    @Override
    public void remove(Session session) {
        TransactionStore.TransactionMap<Value, Value> map = this.getMap(session);
        if (!map.isClosed()) {
            TransactionStore.Transaction t = this.mvTable.getTransaction(session);
            t.removeMap(map);
        }
    }

    @Override
    public void truncate(Session session) {
        TransactionStore.TransactionMap<Value, Value> map = this.getMap(session);
        if (this.mvTable.getContainsLargeObject()) {
            this.database.getLobStorage().removeAllForTable(this.table.getId());
        }
        map.clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        TransactionStore.TransactionMap<Value, Value> map = this.getMap(session);
        ValueLong v = (ValueLong)(first ? map.firstKey() : map.lastKey());
        if (v == null) {
            return new MVStoreCursor(Collections.emptyList().iterator(), null);
        }
        Value value = map.get(v);
        DataUtils.MapEntry<ValueLong, Value> e = new DataUtils.MapEntry<ValueLong, Value>(v, value);
        List<Map.Entry> list = Arrays.asList(e);
        MVStoreCursor c = new MVStoreCursor(list.iterator(), v);
        c.next();
        return c;
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public long getRowCount(Session session) {
        TransactionStore.TransactionMap<Value, Value> map = this.getMap(session);
        return map.sizeAsLong();
    }

    public long getRowCountMax() {
        try {
            return this.dataMap.sizeAsLongMax();
        }
        catch (IllegalStateException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public long getRowCountApproximation() {
        return this.getRowCountMax();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    public String getMapName() {
        return this.mapName;
    }

    @Override
    public void checkRename() {
    }

    ValueLong getKey(SearchRow row, ValueLong ifEmpty, ValueLong ifNull) {
        if (row == null) {
            return ifEmpty;
        }
        Value v = row.getValue(this.mainIndexColumn);
        if (v == null) {
            throw DbException.throwInternalError(row.toString());
        }
        if (v == ValueNull.INSTANCE) {
            return ifNull;
        }
        return (ValueLong)v.convertTo(5);
    }

    Cursor find(Session session, ValueLong first, ValueLong last) {
        TransactionStore.TransactionMap<Value, Value> map = this.getMap(session);
        return new MVStoreCursor(map.entryIterator(first), last);
    }

    @Override
    public boolean isRowIdIndex() {
        return true;
    }

    TransactionStore.TransactionMap<Value, Value> getMap(Session session) {
        if (session == null) {
            return this.dataMap;
        }
        TransactionStore.Transaction t = this.mvTable.getTransaction(session);
        return this.dataMap.getInstance(t, Long.MAX_VALUE);
    }

    class MVStoreCursor
    implements Cursor {
        private final Iterator<Map.Entry<Value, Value>> it;
        private final ValueLong last;
        private Map.Entry<Value, Value> current;
        private Row row;

        public MVStoreCursor(Iterator<Map.Entry<Value, Value>> it, ValueLong last) {
            this.it = it;
            this.last = last;
        }

        @Override
        public Row get() {
            if (this.row == null && this.current != null) {
                ValueArray array = (ValueArray)this.current.getValue();
                this.row = new Row(array.getList(), 0);
                this.row.setKey(this.current.getKey().getLong());
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            return this.get();
        }

        @Override
        public boolean next() {
            Map.Entry<Value, Value> entry = this.current = this.it.hasNext() ? this.it.next() : null;
            if (this.current != null && this.current.getKey().getLong() > this.last.getLong()) {
                this.current = null;
            }
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }
}

