/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.command.dml;

import com.alibaba.dts.shade.org.h2.command.Prepared;
import com.alibaba.dts.shade.org.h2.command.dml.ScriptBase;
import com.alibaba.dts.shade.org.h2.engine.Constants;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.result.ResultInterface;
import com.alibaba.dts.shade.org.h2.util.ScriptReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class RunScriptCommand
extends ScriptBase {
    private static final char UTF8_BOM = '\ufeff';
    private Charset charset = Constants.UTF8;

    public RunScriptCommand(Session session) {
        super(session);
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        int count = 0;
        try {
            String sql;
            this.openInput();
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.in, this.charset));
            reader.mark(1);
            if (reader.read() != 65279) {
                reader.reset();
            }
            ScriptReader r = new ScriptReader(reader);
            while ((sql = r.readStatement()) != null) {
                this.execute(sql);
                if ((++count & 0x7F) != 0) continue;
                this.checkCanceled();
            }
            reader.close();
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
        finally {
            this.closeIO();
        }
        return count;
    }

    private void execute(String sql) {
        try {
            Prepared command = this.session.prepare(sql);
            if (command.isQuery()) {
                command.query(0);
            } else {
                command.update();
            }
            if (this.session.getAutoCommit()) {
                this.session.commit(false);
            }
        }
        catch (DbException e) {
            throw e.addSQL(sql);
        }
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 64;
    }
}

