/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.command.ddl;

import com.alibaba.dts.shade.org.h2.command.ddl.SchemaCommand;
import com.alibaba.dts.shade.org.h2.constraint.Constraint;
import com.alibaba.dts.shade.org.h2.engine.Database;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.index.Index;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.schema.Schema;
import com.alibaba.dts.shade.org.h2.table.Table;
import java.util.ArrayList;

public class DropIndex
extends SchemaCommand {
    private String tableName;
    private String indexName;
    private boolean ifExists;

    public DropIndex(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean b) {
        this.ifExists = b;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database db = this.session.getDatabase();
        Index index = this.getSchema().findIndex(this.session, this.tableName, this.indexName);
        if (index == null) {
            if (!this.ifExists) {
                throw DbException.get(42112, this.indexName);
            }
        } else {
            Table table = index.getTable();
            this.session.getUser().checkRight(index.getTable(), 15);
            Constraint pkConstraint = null;
            ArrayList<Constraint> constraints = table.getConstraints();
            for (int i = 0; constraints != null && i < constraints.size(); ++i) {
                Constraint cons = constraints.get(i);
                if (!cons.usesIndex(index)) continue;
                if ("PRIMARY KEY".equals(cons.getConstraintType())) {
                    pkConstraint = cons;
                    continue;
                }
                throw DbException.get(90085, this.indexName, cons.getName());
            }
            index.getTable().setModified();
            if (pkConstraint != null) {
                db.removeSchemaObject(this.session, pkConstraint);
            } else {
                db.removeSchemaObject(this.session, index);
            }
        }
        return 0;
    }

    @Override
    public int getType() {
        return 40;
    }
}

