/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.command.ddl;

import com.alibaba.dts.shade.org.h2.command.ddl.DefineCommand;
import com.alibaba.dts.shade.org.h2.engine.Database;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.engine.User;
import com.alibaba.dts.shade.org.h2.expression.Expression;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.security.SHA256;
import com.alibaba.dts.shade.org.h2.util.StringUtils;

public class CreateUser
extends DefineCommand {
    private String userName;
    private boolean admin;
    private Expression password;
    private Expression salt;
    private Expression hash;
    private boolean ifNotExists;
    private String comment;

    public CreateUser(Session session) {
        super(session);
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(Expression password) {
        this.password = password;
    }

    static void setSaltAndHash(User user, Session session, Expression salt, Expression hash) {
        user.setSaltAndHash(CreateUser.getByteArray(session, salt), CreateUser.getByteArray(session, hash));
    }

    private static byte[] getByteArray(Session session, Expression e) {
        String s = e.optimize(session).getValue(session).getString();
        return s == null ? new byte[]{} : StringUtils.convertHexToBytes(s);
    }

    static void setPassword(User user, Session session, Expression password) {
        String pwd = password.optimize(session).getValue(session).getString();
        char[] passwordChars = pwd == null ? new char[]{} : pwd.toCharArray();
        String userName = user.getName();
        byte[] userPasswordHash = userName.length() == 0 && passwordChars.length == 0 ? new byte[]{} : SHA256.getKeyPasswordHash(userName, passwordChars);
        user.setUserPasswordHash(userPasswordHash);
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database db = this.session.getDatabase();
        if (db.findRole(this.userName) != null) {
            throw DbException.get(90069, this.userName);
        }
        if (db.findUser(this.userName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(90033, this.userName);
        }
        int id = this.getObjectId();
        User user = new User(db, id, this.userName, false);
        user.setAdmin(this.admin);
        user.setComment(this.comment);
        if (this.hash != null && this.salt != null) {
            CreateUser.setSaltAndHash(user, this.session, this.salt, this.hash);
        } else if (this.password != null) {
            CreateUser.setPassword(user, this.session, this.password);
        } else {
            throw DbException.throwInternalError();
        }
        db.addDatabaseObject(this.session, user);
        return 0;
    }

    public void setSalt(Expression e) {
        this.salt = e;
    }

    public void setHash(Expression e) {
        this.hash = e;
    }

    public void setAdmin(boolean b) {
        this.admin = b;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public int getType() {
        return 32;
    }
}

