/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.command;

import com.alibaba.dts.shade.org.h2.command.Command;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.expression.ParameterInterface;
import com.alibaba.dts.shade.org.h2.result.ResultInterface;
import java.util.ArrayList;

class CommandList
extends Command {
    private final Command command;
    private final String remaining;

    CommandList(Session session, String sql, Command c, String remaining) {
        super(session, sql);
        this.command = c;
        this.remaining = remaining;
    }

    @Override
    public ArrayList<? extends ParameterInterface> getParameters() {
        return this.command.getParameters();
    }

    private void executeRemaining() {
        Command remainingCommand = this.session.prepareLocal(this.remaining);
        if (remainingCommand.isQuery()) {
            remainingCommand.query(0);
        } else {
            remainingCommand.update();
        }
    }

    @Override
    public int update() {
        int updateCount = this.command.executeUpdate();
        this.executeRemaining();
        return updateCount;
    }

    @Override
    public ResultInterface query(int maxrows) {
        ResultInterface result = this.command.query(maxrows);
        this.executeRemaining();
        return result;
    }

    @Override
    public boolean isQuery() {
        return this.command.isQuery();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ResultInterface queryMeta() {
        return this.command.queryMeta();
    }

    @Override
    public int getCommandType() {
        return this.command.getCommandType();
    }
}

