/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.diamond.client.impl;

import com.alibaba.dts.shade.com.taobao.diamond.client.impl.DiamondEnv;
import com.alibaba.dts.shade.com.taobao.diamond.client.impl.ManagerListenerWrap;
import com.alibaba.dts.shade.com.taobao.diamond.manager.ManagerListener;
import com.alibaba.dts.shade.com.taobao.diamond.manager.SharedManagerListenerAdapter;
import com.alibaba.dts.shade.com.taobao.diamond.md5.MD5;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class CacheData {
    private final DiamondEnv env;
    public final String dataId;
    public final String group;
    private final CopyOnWriteArrayList<ManagerListenerWrap> listeners;
    private volatile String md5;
    private volatile boolean isUseLocalConfig = false;
    private volatile long localConfigLastModified;
    private volatile String content;
    private boolean isInitializing = false;

    public boolean isInitializing() {
        return this.isInitializing;
    }

    public void setInitializing(boolean isInitializing) {
        this.isInitializing = isInitializing;
    }

    public String getMd5() {
        return this.md5;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String newContent) {
        this.content = newContent;
        this.md5 = CacheData.getMd5String(this.content);
    }

    public void addListener(ManagerListener listener) {
        if (null == listener) {
            throw new IllegalArgumentException("listener is null");
        }
        ManagerListenerWrap wrap = new ManagerListenerWrap(listener);
        if (this.listeners.addIfAbsent(wrap)) {
            DiamondEnv.log.info(this.env.getName(), "[add-listener] ok, dataId={}, group={}, cnt={}", this.dataId, this.group, this.listeners.size());
        }
    }

    public void removeListener(ManagerListener listener) {
        if (null == listener) {
            throw new IllegalArgumentException("listener is null");
        }
        ManagerListenerWrap wrap = new ManagerListenerWrap(listener);
        if (this.listeners.remove(wrap)) {
            DiamondEnv.log.info(this.env.getName(), "[remove-listener] ok, dataId={}, group={}, cnt={}", this.dataId, this.group, this.listeners.size());
        }
    }

    public List<ManagerListener> getListeners() {
        ArrayList<ManagerListener> result = new ArrayList<ManagerListener>();
        for (ManagerListenerWrap wrap : this.listeners) {
            result.add(wrap.listener);
        }
        return result;
    }

    public long getLocalConfigInfoVersion() {
        return this.localConfigLastModified;
    }

    public void setLocalConfigInfoVersion(long localConfigLastModified) {
        this.localConfigLastModified = localConfigLastModified;
    }

    public boolean isUseLocalConfigInfo() {
        return this.isUseLocalConfig;
    }

    public void setUseLocalConfigInfo(boolean useLocalConfigInfo) {
        this.isUseLocalConfig = useLocalConfigInfo;
        if (!useLocalConfigInfo) {
            this.localConfigLastModified = -1L;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataId == null ? 0 : this.dataId.hashCode());
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (null == obj || obj.getClass() != this.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CacheData other = (CacheData)obj;
        return this.dataId.equals(other.dataId) && this.group.equals(other.group);
    }

    public String toString() {
        return "CacheData [" + this.dataId + ", " + this.group + "]";
    }

    void checkListenerMd5() {
        for (ManagerListenerWrap wrap : this.listeners) {
            if (this.md5.equals(wrap.lastCallMd5)) continue;
            CacheData.safeNotifyListener(this.env, this.dataId, this.group, this.content, this.md5, wrap);
        }
    }

    static void safeNotifyListener(final DiamondEnv env, final String dataId, final String group, final String content, final String md5, ManagerListenerWrap listenerWrap) {
        final ManagerListener listener = listenerWrap.listener;
        listenerWrap.lastCallMd5 = md5;
        Runnable job = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ClassLoader diamondClassLoader = Thread.currentThread().getContextClassLoader();
                ClassLoader appClassLoader = listener.getClass().getClassLoader();
                try {
                    if (listener instanceof SharedManagerListenerAdapter) {
                        SharedManagerListenerAdapter adapter = (SharedManagerListenerAdapter)listener;
                        adapter.fillContext(dataId, group);
                        DiamondEnv.log.info(env.getName(), "[notify-context] dataId={}, group={}, md5={}", dataId, group, md5);
                    }
                    Thread.currentThread().setContextClassLoader(appClassLoader);
                    listener.receiveConfigInfo(content);
                    DiamondEnv.log.info(env.getName(), "[notify-ok] dataId={}, group={}, md5={}, listener={} ", dataId, group, md5, listener);
                }
                catch (Throwable t) {
                    DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[notify-error] dataId={}, group={}, md5={}, listener={} tx={}", dataId, group, md5, listener, t.getCause());
                }
                finally {
                    Thread.currentThread().setContextClassLoader(diamondClassLoader);
                }
            }
        };
        long startNotify = System.currentTimeMillis();
        try {
            if (null != listener.getExecutor()) {
                listener.getExecutor().execute(job);
            } else {
                job.run();
            }
        }
        catch (Throwable t) {
            DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[notify-error] dataId={}, group={}, md5={}, listener={} throwable={}", dataId, group, md5, listener, t.getCause());
        }
        long finishNotify = System.currentTimeMillis();
        DiamondEnv.log.info(env.getName(), "[notify-listener] time cost={}ms in ClientWorker, dataId={}, group={}, md5={}, listener={} ", finishNotify - startNotify, dataId, group, md5, listener);
    }

    public static String getMd5String(String config) {
        return null == config ? "" : MD5.getInstance().getMD5String(config);
    }

    public CacheData(DiamondEnv env, String dataId, String group) {
        if (null == dataId || null == group) {
            throw new IllegalArgumentException("dataId=" + dataId + ", group=" + group);
        }
        this.dataId = dataId;
        this.group = group;
        this.listeners = new CopyOnWriteArrayList();
        this.isInitializing = true;
        this.content = null;
        this.md5 = CacheData.getMd5String(this.content);
        this.env = env;
    }
}

