/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.ali.dpath;

import com.alibaba.dts.shade.com.ali.dpath.rule.AppEnvRule;
import com.alibaba.dts.shade.com.ali.dpath.rule.AppRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RuleData {
    private static volatile RuleData ruleData = null;
    private static Map<String, AppRule> appRuleMap = new ConcurrentHashMap<String, AppRule>();
    private boolean enable = false;
    public Map<String, String> ip2Env = new ConcurrentHashMap<String, String>();
    public Map<String, String> machineGroup2Env = new ConcurrentHashMap<String, String>();
    public Map<String, List<String>> env2Apps = new ConcurrentHashMap<String, List<String>>();
    public Map<String, Integer> env2FailoverPolicy = new ConcurrentHashMap<String, Integer>();
    public Map<String, Boolean> env2MsgFilterEnable = new ConcurrentHashMap<String, Boolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setRuleData(RuleData ruleData) {
        Class<RuleData> clazz = RuleData.class;
        synchronized (RuleData.class) {
            RuleData.ruleData = ruleData;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RuleData getRuleData() {
        if (ruleData != null) return ruleData;
        Class<RuleData> clazz = RuleData.class;
        synchronized (RuleData.class) {
            if (ruleData != null) return ruleData;
            ruleData = new RuleData();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ruleData;
        }
    }

    public boolean isEmpty() {
        return this.ip2Env.isEmpty() && this.machineGroup2Env.isEmpty() && this.env2Apps.isEmpty() && this.env2FailoverPolicy.isEmpty();
    }

    public static synchronized void replaceAppRule(AppRule currentAppRule) {
        if (currentAppRule != null && currentAppRule.getAppName() != null && !currentAppRule.getAppName().isEmpty()) {
            appRuleMap.put(currentAppRule.getAppName(), currentAppRule);
            RuleData newRuleData = new RuleData();
            newRuleData.setEnable(RuleData.getRuleData().isEnable());
            Map<String, String> ip2Env = newRuleData.ip2Env;
            Map<String, String> machineGroup2Env = newRuleData.machineGroup2Env;
            Map<String, List<String>> env2Apps = newRuleData.env2Apps;
            Map<String, Integer> env2FailoverPolicy = newRuleData.env2FailoverPolicy;
            Map<String, Boolean> env2MsgFilterEnable = newRuleData.env2MsgFilterEnable;
            for (Map.Entry<String, AppRule> appRuleEntry : appRuleMap.entrySet()) {
                String env;
                AppRule appRule = appRuleEntry.getValue();
                List<AppEnvRule> currentAppEnvRules = appRule.getAppEnvRules();
                for (AppEnvRule appEnvRule : currentAppEnvRules) {
                    env = appEnvRule.getEnvName();
                    List<String> ipList = appEnvRule.getIps();
                    for (String ip : ipList) {
                        ip2Env.put(ip, env);
                    }
                }
                for (AppEnvRule appEnvRule : currentAppEnvRules) {
                    env = appEnvRule.getEnvName();
                    List<String> machineGroups = appEnvRule.getMachineGroups();
                    for (String machineGroup : machineGroups) {
                        machineGroup2Env.put(machineGroup, env);
                    }
                }
                for (AppEnvRule appEnvRule : currentAppEnvRules) {
                    env = appEnvRule.getEnvName();
                    String appName = appRule.getAppName();
                    List<String> appList = env2Apps.get(env);
                    if (appList != null) {
                        appList.add(appName);
                        continue;
                    }
                    appList = new ArrayList<String>();
                    env2Apps.put(env, appList);
                    appList.add(appName);
                }
                for (AppEnvRule appEnvRule : currentAppEnvRules) {
                    env = appEnvRule.getEnvName();
                    Integer failoverPolicy = appEnvRule.getFailoverPolicy();
                    env2FailoverPolicy.put(env, failoverPolicy);
                }
                for (AppEnvRule appEnvRule : currentAppEnvRules) {
                    env = appEnvRule.getEnvName();
                    Boolean msgFilterEnable = appEnvRule.getMsgFilterEnable();
                    env2MsgFilterEnable.put(env, msgFilterEnable);
                }
            }
            RuleData.setRuleData(newRuleData);
        }
    }

    RuleData cloneRuleData() {
        RuleData newRuleData = new RuleData();
        newRuleData.enable = this.enable;
        newRuleData.ip2Env = new ConcurrentHashMap<String, String>(this.ip2Env);
        newRuleData.machineGroup2Env = new ConcurrentHashMap<String, String>(this.machineGroup2Env);
        ConcurrentHashMap<String, List<String>> env2Apps = new ConcurrentHashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.env2Apps.entrySet()) {
            String env = entry.getKey();
            ArrayList appList = new ArrayList(entry.getValue());
            env2Apps.put(env, appList);
        }
        newRuleData.env2Apps = env2Apps;
        newRuleData.env2FailoverPolicy = new ConcurrentHashMap<String, Integer>(this.env2FailoverPolicy);
        newRuleData.env2MsgFilterEnable = new ConcurrentHashMap<String, Boolean>(this.env2MsgFilterEnable);
        return newRuleData;
    }

    public boolean isEnable() {
        return this.enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnableSync(boolean enable) {
        Class<RuleData> clazz = RuleData.class;
        synchronized (RuleData.class) {
            RuleData.getRuleData().enable = enable;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void setEnable(boolean enable) {
        this.enable = enable;
    }
}

