/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.ali.dpath;

import com.alibaba.dts.shade.com.ali.dpath.DPath;
import com.alibaba.dts.shade.com.ali.dpath.RuleData;
import com.alibaba.dts.shade.com.ali.dpath.rule.AppRule;
import com.alibaba.dts.shade.com.ali.dpath.util.DPathLogger;
import com.alibaba.dts.shade.com.taobao.diamond.manager.ManagerListener;
import com.alibaba.dts.shade.com.taobao.middleware.logger.Logger;
import com.alibaba.fastjson.JSON;
import java.util.concurrent.Executor;

public class DistinctAppRuleManagerListener
implements ManagerListener {
    private Logger logger = DPathLogger.logger();
    private String lastConfig = null;
    private String appName;
    private String group;
    private AppRule lastAppRule;

    public DistinctAppRuleManagerListener(String appName, String group) {
        this.appName = appName;
        this.group = group;
    }

    @Override
    public Executor getExecutor() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveConfigInfo(String configInfo) {
        try {
            DistinctAppRuleManagerListener distinctAppRuleManagerListener = this;
            synchronized (distinctAppRuleManagerListener) {
                this.logger.info("receive " + this.appName + " rule:" + configInfo);
                if (this.lastConfig != null && this.lastConfig.equals(configInfo)) {
                    return;
                }
                AppRule appRule = (AppRule)JSON.parseObject((String)configInfo, AppRule.class);
                if (appRule == null) {
                    appRule = new AppRule();
                    appRule.setAppName(this.appName);
                    RuleData.replaceAppRule(appRule);
                    if (DPath.APPNAME.equalsIgnoreCase(this.appName)) {
                        DPath.setLocalAppConfigExistFlag(false);
                    }
                } else {
                    appRule.setAppName(this.appName);
                    RuleData.replaceAppRule(appRule);
                    if (DPath.APPNAME.equalsIgnoreCase(this.appName)) {
                        DPath.setLocalAppConfigExistFlag(true);
                    }
                }
                this.lastAppRule = appRule;
                this.lastConfig = configInfo;
                this.logger.info("calculate " + this.appName + " rule:" + JSON.toJSON((Object)RuleData.getRuleData()));
                DPath.notifyRule();
            }
        }
        catch (Throwable t) {
            this.logger.error("DPATH", "Process dpath rule config error.", t);
        }
    }

    public String getAppName() {
        return this.appName;
    }

    public String getGroup() {
        return this.group;
    }
}

