/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.remoting.netty;

import com.alibaba.dts.common.helper.RemotingHelper;
import com.alibaba.dts.common.remoting.protocol.RemotingCommand;
import com.alibaba.dts.common.util.RemotingUtil;
import com.alibaba.dts.shade.io.netty.buffer.ByteBuf;
import com.alibaba.dts.shade.io.netty.channel.ChannelHandlerContext;
import com.alibaba.dts.shade.io.netty.handler.codec.MessageToByteEncoder;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NettyEncoder
extends MessageToByteEncoder<RemotingCommand> {
    private static final Log log = LogFactory.getLog(NettyEncoder.class);

    @Override
    public void encode(ChannelHandlerContext ctx, RemotingCommand remotingCommand, ByteBuf out) throws Exception {
        try {
            ByteBuffer header = remotingCommand.encodeHeader();
            out.writeBytes(header);
            byte[] body = remotingCommand.getBody();
            if (body != null) {
                out.writeBytes(body);
            }
        }
        catch (Throwable e) {
            log.error((Object)("encode exception, " + RemotingHelper.parseChannelRemoteAddr(ctx.channel())), e);
            if (remotingCommand != null) {
                log.error((Object)remotingCommand.toString());
            }
            RemotingUtil.closeChannel(ctx.channel());
        }
    }
}

