/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.store.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.store.StoreStrategy;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import java.sql.SQLException;

public class SchedulerXClientDataSource
implements Constants {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(SchedulerXClientDataSource.class);
    private String dbUrl;
    private DruidDataSource dataSource = new DruidDataSource();

    public void init(ClientContextImpl clientContext) throws InitException {
        if (clientContext.getNodeConfig().getStoreStrategy() == StoreStrategy.DISK) {
            this.dbUrl = "jdbc:h2:file:" + clientContext.getNodeConfig().getDbPath() + "schedulerx;CACHE_SIZE=1000;AUTO_SERVER=TRUE;MODE=MySQL;DB_CLOSE_ON_EXIT=FALSE";
        } else if (clientContext.getNodeConfig().getStoreStrategy() == StoreStrategy.MEMORY) {
            this.dbUrl = "jdbc:h2:mem:schedulerx";
        } else {
            throw new InitException("unable to find correct storeStrategy, the current storeStrategy is " + (Object)((Object)clientContext.getNodeConfig().getStoreStrategy()));
        }
        if (!this.dataSource.isInited()) {
            this.dataSource.setUrl(this.dbUrl);
            this.dataSource.setDriverClassName("com.alibaba.dts.shade.org.h2.Driver");
            this.dataSource.setUsername("sa");
            this.dataSource.setPassword("");
            this.dataSource.setInitialSize(4);
            this.dataSource.setMinIdle(4);
            this.dataSource.setMaxActive(32);
        }
        this.dropDB(this.dataSource);
    }

    public void dropDB(DruidDataSource dataSource) throws InitException {
        long result = 0L;
        DruidPooledConnection connection = null;
        try {
            connection = dataSource.getConnection();
            result = connection.prepareStatement("DROP DATABASE IF EXISTS schedulerx").executeUpdate();
        }
        catch (Throwable throwable) {
            logger.error("drop db error", throwable);
            throw new InitException(throwable);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error("failed to close connection {}", (Object)connection, (Object)e);
                }
            }
        }
    }

    public DruidDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DruidDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void close() {
        this.dataSource.close();
    }
}

