/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.store.access.impl;

import com.alibaba.dts.client.store.access.TaskSnapshotAccess;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.exception.AccessException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public class TaskSnapshotDaoH2
implements TaskSnapshotAccess {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(TaskSnapshotDaoH2.class);
    private DataSource dataSource;

    public TaskSnapshotDaoH2(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public int createTaskSnapshotTable() throws AccessException {
        int result = 0;
        Connection connection = null;
        Statement preparedStatement = null;
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("CREATE TABLE IF NOT EXISTS dts_task_snapshot (id bigint(20) NOT NULL, gmt_create datetime DEFAULT NULL, gmt_modified datetime DEFAULT NULL, job_instance_id bigint(20) DEFAULT NULL,         job_processor varchar(255) DEFAULT NULL,         body blob,         status int(11) DEFAULT NULL,         task_name varchar(255) DEFAULT NULL,         retry_count int(11) DEFAULT NULL,         simple_task bit(1) DEFAULT NULL,         compensation bit(1) DEFAULT NULL,         receive_node_address varchar(255) DEFAULT NULL,         PRIMARY KEY (id)         ) ");
            result = preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new AccessException("[createTaskSnapshotTable]: error", e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
        return result;
    }

    @Override
    public int insertBatch(List<TaskSnapshot> snapshots) throws AccessException {
        int result = 0;
        Connection connection = null;
        Statement preparedStatement = null;
        try {
            int[] counts;
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("insert into dts_task_snapshot(id, gmt_create, gmt_modified, job_instance_id, job_processor, body, status, task_name, retry_count, compensation) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            for (TaskSnapshot snapshot : snapshots) {
                preparedStatement.setLong(1, snapshot.getId());
                preparedStatement.setTimestamp(2, new Timestamp(snapshot.getGmtCreate().getTime()));
                preparedStatement.setTimestamp(3, new Timestamp(snapshot.getGmtModified().getTime()));
                preparedStatement.setLong(4, snapshot.getJobInstanceId());
                preparedStatement.setString(5, snapshot.getJobProcessor());
                preparedStatement.setBytes(6, snapshot.getBody());
                preparedStatement.setInt(7, snapshot.getStatus());
                preparedStatement.setString(8, snapshot.getTaskName());
                preparedStatement.setInt(9, snapshot.getRetryCount());
                preparedStatement.setBoolean(10, snapshot.isCompensation());
                preparedStatement.addBatch();
            }
            for (int count : counts = preparedStatement.executeBatch()) {
                result += count;
            }
        }
        catch (SQLException e) {
            throw new AccessException("[insertBatch]: error", e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
        return result;
    }

    @Override
    public int delete(TaskSnapshot taskSnapshot) throws AccessException {
        int result = 0;
        Connection connection = null;
        Statement preparedStatement = null;
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM dts_task_snapshot WHERE id=?");
            preparedStatement.setLong(1, taskSnapshot.getId());
            result = preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new AccessException("[delete]: error", e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
        return result;
    }

    @Override
    public int taskSnapshotAck(TaskSnapshot taskSnapshot) throws AccessException {
        int result = 0;
        Connection connection = null;
        Statement preparedStatement = null;
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("update dts_task_snapshot set gmt_modified=NOW(), status=?, retry_count=? where id=?");
            preparedStatement.setInt(1, taskSnapshot.getStatus());
            preparedStatement.setInt(2, taskSnapshot.getRetryCount());
            preparedStatement.setLong(3, taskSnapshot.getId());
            result = preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new AccessException("[taskSnapshotAck]: error", e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
        return result;
    }

    @Override
    public void deleteFinishedTasks() throws AccessException {
        Connection connection = null;
        Statement preparedStatement = null;
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("delete from dts_task_snapshot where status=3 or status = 4 and retry_count=0");
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new AccessException("[taskSnapshotAck]: error", e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public void updateReceiveNodeBatch(List<TaskSnapshot> taskSnapshotList, String receiveNode) throws AccessException {
        Connection connection = null;
        Statement preparedStatement = null;
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("update dts_task_snapshot         set         gmt_modified = now(),         receive_node_address =?         where         id =?");
            for (TaskSnapshot taskSnapshot : taskSnapshotList) {
                preparedStatement.setString(1, receiveNode);
                preparedStatement.setLong(2, taskSnapshot.getId());
                preparedStatement.addBatch();
            }
            int[] counts = preparedStatement.executeBatch();
        }
        catch (SQLException e) {
            throw new AccessException("[updateReceiveNodeBatch]: error", e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public void updateStatus2QueueIfStatusIsInitBatch(List<TaskSnapshot> taskSnapshotList) throws AccessException {
        Connection connection = null;
        Statement preparedStatement = null;
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("update dts_task_snapshot         set         gmt_modified = now(),         status = ?         where         status = 0         and         id =?");
            for (TaskSnapshot taskSnapshot : taskSnapshotList) {
                preparedStatement.setInt(1, 1);
                preparedStatement.setLong(2, taskSnapshot.getId());
                preparedStatement.addBatch();
            }
            int[] counts = preparedStatement.executeBatch();
        }
        catch (SQLException e) {
            throw new AccessException("[updateStatus2QueueIfStatusIsInitBatch]: error", e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public long queryUnFinishedTasksCount(long jobInstanceId) throws AccessException {
        Connection connection = null;
        Statement preparedStatement = null;
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement(" select count(*) from DTS_TASK_SNAPSHOT         where         job_instance_id = ?         and         (         status = 0         or status = 1         )");
            preparedStatement.setLong(1, jobInstanceId);
            long count = 0L;
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                count = resultSet.getLong(1);
            }
            long l = count;
            return l;
        }
        catch (SQLException e) {
            throw new AccessException("[queryUnFinishedTasksCount]: error", e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public long queryUnFinishedTasksCountForDelete(long jobInstanceId) throws AccessException {
        Connection connection = null;
        Statement preparedStatement = null;
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement(" select count(*) from DTS_TASK_SNAPSHOT         where         job_instance_id = ?         and         (         status = 0         or status = 1         or status = 4 and retry_count>0         or status = 9         )");
            preparedStatement.setLong(1, jobInstanceId);
            long count = 0L;
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                count = resultSet.getLong(1);
            }
            long l = count;
            return l;
        }
        catch (SQLException e) {
            throw new AccessException("[queryUnFinishedTasksCountForDelete]: error", e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public List<TaskSnapshot> listTaskSnapshotsFromStartId(long start, int limit) throws AccessException {
        Connection connection = null;
        Statement preparedStatement = null;
        ArrayList<TaskSnapshot> taskSnapshots = new ArrayList<TaskSnapshot>();
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("select * from DTS_TASK_SNAPSHOT         where         id > ?         and status = 4 and retry_count>0         order by id asc         limit ?");
            preparedStatement.setLong(1, start);
            preparedStatement.setInt(2, limit);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                TaskSnapshot taskSnapshot = this.buildTaskSnapshotFromDbRecord(resultSet);
                taskSnapshots.add(taskSnapshot);
            }
        }
        catch (SQLException e) {
            throw new AccessException("[listTaskSnapshotsFromStartId]: error", e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
        return taskSnapshots;
    }

    private TaskSnapshot buildTaskSnapshotFromDbRecord(ResultSet resultSet) throws SQLException {
        TaskSnapshot taskSnapshot = new TaskSnapshot();
        taskSnapshot.setId(resultSet.getLong("id"));
        taskSnapshot.setGmtCreate(resultSet.getDate("gmt_create"));
        taskSnapshot.setGmtModified(resultSet.getDate("gmt_modified"));
        taskSnapshot.setJobInstanceId(resultSet.getLong("job_instance_id"));
        taskSnapshot.setJobProcessor(resultSet.getString("job_processor"));
        taskSnapshot.setBody(resultSet.getBytes("body"));
        taskSnapshot.setStatus(resultSet.getInt("status"));
        taskSnapshot.setTaskName(resultSet.getString("task_name"));
        taskSnapshot.setRetryCount(resultSet.getInt("retry_count"));
        taskSnapshot.setReceiveNodeAddress(resultSet.getString("receive_node_address"));
        return taskSnapshot;
    }

    @Override
    public long deleteByJobInstanceId(long jobInstanceId) throws AccessException {
        Connection connection = null;
        Statement preparedStatement = null;
        try {
            long count;
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("delete from DTS_TASK_SNAPSHOT         where         job_instance_id=? AND ROWNUM() < 10000");
            preparedStatement.setLong(1, jobInstanceId);
            long l = count = (long)preparedStatement.executeUpdate();
            return l;
        }
        catch (SQLException e) {
            throw new AccessException("[deleteByJobInstanceId]: error", e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public long deleteByReceiveNodeAddressAndStatus(String receiveNodeAddress, int status) throws AccessException {
        Connection connection = null;
        Statement preparedStatement = null;
        try {
            long count;
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("delete from DTS_TASK_SNAPSHOT where receive_node_address=? AND status=? AND ROWNUM() < 10000");
            preparedStatement.setString(1, receiveNodeAddress);
            preparedStatement.setInt(2, status);
            long l = count = (long)preparedStatement.executeUpdate();
            return l;
        }
        catch (SQLException e) {
            throw new AccessException("[deleteByReceiveNodeAddress]: error", e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public List<TaskSnapshot> listByIdAndReceiveNodeAndStatus(long id, String receiveNodeAddress, int status) throws AccessException {
        Connection connection = null;
        Statement preparedStatement = null;
        ArrayList<TaskSnapshot> taskSnapshots = new ArrayList<TaskSnapshot>();
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("select * from DTS_TASK_SNAPSHOT where id > ? and receive_node_address=? and status=? order by id asc limit 1000");
            preparedStatement.setLong(1, id);
            preparedStatement.setString(2, receiveNodeAddress);
            preparedStatement.setInt(3, status);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                TaskSnapshot taskSnapshot = this.buildTaskSnapshotFromDbRecord(resultSet);
                taskSnapshots.add(taskSnapshot);
            }
        }
        catch (SQLException e) {
            throw new AccessException("[listByIdAndReceiveNodeAndStatus]: error", e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
        return taskSnapshots;
    }

    @Override
    public long queryTotalCount() throws AccessException {
        Connection connection = null;
        Statement preparedStatement = null;
        long total = 0L;
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("select COUNT(*) from DTS_TASK_SNAPSHOT ");
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                total = resultSet.getLong(1);
            }
        }
        catch (SQLException e) {
            throw new AccessException("[queryTotalCount]: error", e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
        return total;
    }

    @Override
    public int queryTaskCountByJobInstanceId(long jobInstanceId, int status) throws AccessException {
        Connection connection = null;
        Statement preparedStatement = null;
        int total = 0;
        try {
            connection = this.dataSource.getConnection();
            if (status == -1) {
                preparedStatement = connection.prepareStatement("select COUNT(*) from DTS_TASK_SNAPSHOT WHERE job_instance_id=?");
                preparedStatement.setLong(1, jobInstanceId);
            } else {
                preparedStatement = connection.prepareStatement("select COUNT(*) from DTS_TASK_SNAPSHOT WHERE job_instance_id=? AND status=?");
                preparedStatement.setLong(1, jobInstanceId);
                preparedStatement.setLong(2, status);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                total = resultSet.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new AccessException("[queryTaskCountByJobInstanceId]: error", e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
        return total;
    }

    @Override
    public void updateStatusBatch(List<TaskSnapshot> taskSnapshotList, int status) throws AccessException {
        if (taskSnapshotList.isEmpty()) {
            return;
        }
        Connection connection = null;
        Statement preparedStatement = null;
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement(" update         dts_task_snapshot         set         gmt_modified = now(),         status = ?         where         id =?");
            for (TaskSnapshot taskSnapshot : taskSnapshotList) {
                preparedStatement.setInt(1, status);
                preparedStatement.setLong(2, taskSnapshot.getId());
                preparedStatement.addBatch();
            }
            int[] counts = preparedStatement.executeBatch();
        }
        catch (SQLException e) {
            throw new AccessException("[updateStatusBatch]: error", e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public int createIndex(String sql) throws AccessException {
        int result = 0;
        Connection connection = null;
        Statement preparedStatement = null;
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement(sql);
            result = preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new AccessException("[createIndex]: error, sql=" + sql, e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
        return result;
    }
}

