/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.route.impl;

import com.alibaba.dts.client.executor.job.context.JobContext;
import com.alibaba.dts.client.route.RouteRule;
import com.alibaba.dts.common.domain.remoting.RemoteMachine;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class RoundRobinRule
implements RouteRule {
    private static final ConcurrentHashMap<String, AtomicLong> counters = new ConcurrentHashMap();

    @Override
    public RemoteMachine rule(JobContext jobContext, List<RemoteMachine> machines) {
        AtomicLong counterExisted;
        if (null == machines || machines.isEmpty()) {
            return null;
        }
        String jobProcessor = jobContext.getJob().getJobProcessor().trim();
        AtomicLong counter = counters.get(jobProcessor);
        if (counter == null && (counterExisted = counters.putIfAbsent(jobProcessor, counter = new AtomicLong())) != null) {
            counter = counterExisted;
        }
        int index = (int)(counter.get() % (long)machines.size());
        counter.incrementAndGet();
        return machines.get(Math.abs(index));
    }
}

