/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.grid.timer;

import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.util.NamedThreadFactory;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SystemMonitor {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(SystemMonitor.class);
    private static volatile AtomicInteger diskAvailablePercentage = new AtomicInteger(0);
    private static final String diskUsageFile = System.getProperty("user.home") + "/logs/schedulerx-log/space.log";

    public void init() {
        Executors.newScheduledThreadPool(1, new NamedThreadFactory("SchedulerX-System-Monitor-")).scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    diskAvailablePercentage.set(SystemMonitor.this.checkDiskAvailablePercentage());
                }
                catch (Throwable throwable) {
                    logger.error("failed to check system usage");
                }
            }
        }, 0L, 1L, TimeUnit.MINUTES);
    }

    public int checkDiskAvailablePercentage() throws IOException {
        File file = new File(diskUsageFile);
        if (!file.exists()) {
            file.createNewFile();
        }
        long total = file.getTotalSpace();
        long usable = file.getUsableSpace();
        int availablePercent = (int)(usable * 100L / total);
        return availablePercent;
    }

    public static AtomicInteger getDiskAvailablePercentage() {
        return diskAvailablePercentage;
    }
}

