/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.grid.queue.send;

import com.alibaba.dts.client.executor.grid.queue.send.MergingTaskGroup;
import com.alibaba.dts.client.executor.grid.queue.send.SendManager;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class TaskMergeMonitor
implements Runnable {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(TaskMergeMonitor.class);
    private SendManager sendManager;
    private AtomicBoolean readyForSend;

    public TaskMergeMonitor(SendManager sendManager) {
        this.sendManager = sendManager;
        this.readyForSend = sendManager.getReadyForSend();
    }

    @Override
    public void run() {
        try {
            this.checkReadyForSend(this.sendManager.getMergingTaskGroupMapByTargetMachine());
            this.checkReadyForSend(this.sendManager.getMergingTaskGroupMapByTargetMachineCompensation());
        }
        catch (Throwable throwable) {
            logger.error("failed to monitor task merge", throwable);
        }
    }

    private void checkReadyForSend(ConcurrentHashMap<String, ConcurrentHashMap<Long, MergingTaskGroup>> mergingTaskGroupMapByTargetMachine) {
        if (!this.readyForSend.get()) {
            for (Map.Entry<String, ConcurrentHashMap<Long, MergingTaskGroup>> entry : mergingTaskGroupMapByTargetMachine.entrySet()) {
                boolean breakFlag = false;
                ConcurrentHashMap<Long, MergingTaskGroup> mergingTaskMapByJobInstanceId = entry.getValue();
                for (Map.Entry<Long, MergingTaskGroup> mergingTaskGroupEntry : mergingTaskMapByJobInstanceId.entrySet()) {
                    MergingTaskGroup mergingTaskGroup = mergingTaskGroupEntry.getValue();
                    if (!mergingTaskGroup.isReadyForSend()) continue;
                    this.readyForSend.set(true);
                    breakFlag = true;
                    break;
                }
                if (!breakFlag) continue;
                break;
            }
        }
    }
}

