/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import com.alibaba.middleware.tls.util.TlsUtil;
import com.taobao.diamond.client.impl.DiamondEnv;
import com.taobao.diamond.client.impl.EventDispatcher;
import com.taobao.diamond.client.impl.HttpSimpleClient;
import com.taobao.diamond.client.impl.IOUtils;
import com.taobao.diamond.client.impl.ServerAddressIterator;
import com.taobao.diamond.client.impl.ServerHttpAgent;
import com.taobao.diamond.client.impl.TimerService;
import com.taobao.diamond.utils.EnvUtil;
import com.taobao.diamond.utils.MockUtil;
import com.taobao.diamond.utils.StringUtils;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class ServerListManager {
    String name;
    public static final String DEFAULT_NAME = "default";
    public static final String CUSTOM_NAME = "custom";
    public static final String FIXED_NAME = "fixed";
    static final int TIMEOUT = 5000;
    final boolean isFixed;
    boolean isStarted = false;
    volatile List<String> serverUrls = new ArrayList<String>();
    private DiamondEnv env = null;
    public static String serverPort;
    public static String ADDRESS_SERVER_URL;
    public static final String DIAMOND_SERVER_IPS;
    public static Map<String, String> ipPortMap;

    public ServerListManager() {
        this.isFixed = false;
        this.isStarted = false;
        this.name = DEFAULT_NAME;
    }

    public ServerListManager(List<String> fixed) {
        this.isFixed = true;
        this.isStarted = true;
        this.serverUrls = new ArrayList<String>(fixed);
        this.name = "fixed-" + this.getFixedNameSuffix(fixed.toArray(new String[fixed.size()]));
    }

    public ServerListManager(String host, int port) {
        this.isFixed = false;
        this.isStarted = false;
        this.name = "custom-" + host + "-" + port;
        ADDRESS_SERVER_URL = String.format("http://%s:%d/diamond-server/diamond", host, port);
    }

    public synchronized void start() {
        if (MockUtil.isMock()) {
            return;
        }
        if (this.isStarted || this.isFixed) {
            return;
        }
        GetServerListTask getServersTask = new GetServerListTask(ADDRESS_SERVER_URL);
        for (int i = 0; i < 5 && this.serverUrls.isEmpty(); ++i) {
            getServersTask.run();
            try {
                Thread.sleep((long)(i + 1) * 100L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.serverUrls.isEmpty()) {
            DiamondEnv.log.error("Diamond-0008", LoggerHelper.getErrorCodeStr("Diamond", "Diamond-0008", "\u73af\u5883\u95ee\u9898", "fail to get diamond-server serverlist! env:" + this.name + ", not connnect url:" + ADDRESS_SERVER_URL));
            DiamondEnv.log.error(this.name, "DIAMOND-XXXX", "[init-serverlist] fail to get diamond-server serverlist!");
            RuntimeException e = new RuntimeException("fail to get diamond-server serverlist! env:" + this.name + ", not connnect url:" + ADDRESS_SERVER_URL);
            e.printStackTrace();
            throw e;
        }
        TimerService.scheduleWithFixedDelay(getServersTask, 0L, 30L, TimeUnit.SECONDS);
        this.isStarted = true;
    }

    Iterator<String> iterator() {
        if (this.serverUrls.isEmpty()) {
            DiamondEnv.log.error(this.name, "DIAMOND-XXXX", "[iterator-serverlist] No server address defined!");
        }
        return new ServerAddressIterator(this.serverUrls);
    }

    private void updateIfChanged(List<String> newList) {
        if (null == newList || newList.isEmpty()) {
            DiamondEnv.log.warn("Diamond-0001", LoggerHelper.getErrorCodeStr("Diamond", "Diamond-0001", "\u73af\u5883\u95ee\u9898", "[update-serverlist] current serverlist from address server is empty!!!"));
            DiamondEnv.log.warn(this.name, "[update-serverlist] current serverlist from address server is empty!!!");
            return;
        }
        if (newList.equals(this.serverUrls)) {
            return;
        }
        this.serverUrls = new ArrayList<String>(newList);
        if (this.env != null && this.env.agent != null) {
            this.env.agent.reSetCurrentServerIp();
        }
        for (Map.Entry<String, String> ipPort : ipPortMap.entrySet()) {
            if (newList.contains(ipPort.getKey())) continue;
            ipPortMap.remove(ipPort.getKey());
        }
        EventDispatcher.fireEvent(new EventDispatcher.ServerlistChangeEvent());
        DiamondEnv.log.info(this.name, "[update-serverlist] serverlist updated to {}", this.serverUrls);
    }

    static List<String> getApacheServerList(String url, String name) {
        try {
            HttpSimpleClient.HttpResult httpResult = HttpSimpleClient.httpGet(url, null, null, null, 3000L);
            if (200 == httpResult.code) {
                if (DEFAULT_NAME.equals(name)) {
                    EnvUtil.setSelfEnv(httpResult.headers);
                }
                List<String> lines = IOUtils.readLines(new StringReader(httpResult.content));
                ArrayList<String> result = new ArrayList<String>(lines.size());
                for (String line : lines) {
                    if (null == line || line.trim().isEmpty()) continue;
                    String[] ipPort = line.trim().split(":");
                    String ip = ipPort[0].trim();
                    if (ipPort.length > 1) {
                        ipPortMap.put(ip, ipPort[1].trim());
                    }
                    result.add(ip);
                }
                return result;
            }
            DiamondEnv.log.error(ADDRESS_SERVER_URL, "DIAMOND-XXXX", "[check-serverlist] error. code={}", httpResult.code);
            return null;
        }
        catch (IOException e) {
            DiamondEnv.log.error("Diamond-0001", LoggerHelper.getErrorCodeStr("Diamond", "Diamond-0001", "\u73af\u5883\u95ee\u9898", e.toString()));
            DiamondEnv.log.error(ADDRESS_SERVER_URL, "DIAMOND-XXXX", "[check-serverlist] exception. msg={}", e.toString(), e);
            return null;
        }
    }

    public void initServerList() {
        GetServerListTask getServersTask = new GetServerListTask(ADDRESS_SERVER_URL);
        for (int i = 0; i < 3 && this.serverUrls.isEmpty(); ++i) {
            getServersTask.run();
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    String getUrlString() {
        return this.serverUrls.toString();
    }

    String getFixedNameSuffix(String ... serverIps) {
        StringBuilder sb = new StringBuilder();
        String split = "";
        for (String serverIp : serverIps) {
            sb.append(split);
            sb.append(serverIp);
            split = "-";
        }
        return sb.toString();
    }

    public DiamondEnv getEnv() {
        return this.env;
    }

    public void setEnv(DiamondEnv env) {
        this.env = env;
    }

    public String toString() {
        return "ServerManager-" + this.name + "-" + this.getUrlString();
    }

    public boolean contain(String ip) {
        return this.serverUrls.contains(ip);
    }

    public String getPortByIp(String ip) {
        String port = StringUtils.defaultIfEmpty(ipPortMap.get(ip), serverPort);
        return port;
    }

    static {
        ipPortMap = new ConcurrentHashMap<String, String>();
        String defaultServerPort = "8080";
        if (TlsUtil.tlsEnable()) {
            defaultServerPort = "443";
        }
        serverPort = System.getProperty("diamond.server.port", defaultServerPort);
        DiamondEnv.log.info("settings", "[req-serv] diamond-server port:{}", serverPort);
        DIAMOND_SERVER_IPS = System.getProperty("DIAMOND.SERVER.IPS", "");
        if (!StringUtils.isBlank(DIAMOND_SERVER_IPS)) {
            try {
                String[] ips;
                for (String ip : ips = DIAMOND_SERVER_IPS.split(",")) {
                    InetAddress.getByName(ip);
                }
            }
            catch (UnknownHostException e) {
                String msg = "[custom-serverlist] invalid custom server ips:" + DIAMOND_SERVER_IPS;
                DiamondEnv.log.error("settings", "DIAMOND-XXXX", msg, e);
                throw new IllegalArgumentException(msg, e);
            }
            DiamondEnv.log.info("settings", "[custom-serverlist] use custom server ips:{}", DIAMOND_SERVER_IPS);
        }
        ADDRESS_SERVER_URL = "http://" + ServerHttpAgent.domainName + ":" + ServerHttpAgent.addressPort + "/diamond-server/diamond";
    }

    class GetServerListTask
    implements Runnable {
        final String url;

        GetServerListTask(String url) {
            this.url = url;
        }

        @Override
        public void run() {
            if (!StringUtils.isEmpty(DIAMOND_SERVER_IPS) && ServerListManager.DEFAULT_NAME.equals(ServerListManager.this.name)) {
                String[] ips;
                ArrayList<String> customIps = new ArrayList<String>();
                for (String ip : ips = DIAMOND_SERVER_IPS.split(",")) {
                    customIps.add(ip);
                }
                ServerListManager.this.updateIfChanged(customIps);
                return;
            }
            try {
                ServerListManager.this.updateIfChanged(ServerListManager.getApacheServerList(this.url, ServerListManager.this.name));
            }
            catch (Throwable e) {
                DiamondEnv.log.error(ServerListManager.this.name, "DIAMOND-XXXX", "[update-serverlist] failed to update serverlist from address server!", e);
            }
        }
    }
}

